/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.matchLibrary;

import java.util.Vector;
import tv.ingames.j2dm.display.J2DM_DisplayContainer;
import tv.ingames.j2dm.gameplay.IPlaying;
import tv.ingames.j2dm.matchLibrary.J2DM_StructControlBalls;
import tv.ingames.j2dm.matchLibrary.ballType.J2DM_TypeColorBall;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_AbstractMatrixData;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_Ball;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataBloqued;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataBrick;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataEmpty;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataToFillWithBall;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_MatrixManager
extends J2DM_DisplayContainer
implements IPlaying {
    protected J2DM_AbstractMatrixData[][] _matrix = new J2DM_AbstractMatrixData[0][0];
    protected int _maxx;
    protected int _maxy;
    protected J2DM_Ball[] _ballsBuffer = new J2DM_Ball[0];
    protected int _cantBallsInBuffer = 0;
    protected J2DM_MatrixDataBrick _slotBrick = new J2DM_MatrixDataBrick(null);
    protected J2DM_MatrixDataBloqued _slotBloqued = new J2DM_MatrixDataBloqued(null);
    protected J2DM_MatrixDataEmpty _slotEmpty = new J2DM_MatrixDataEmpty(null);
    protected Vector _ballsInMatrix = new Vector();
    protected Vector _ballsToControl = new Vector();
    protected int _typeControlNewBalls = 7;
    protected int _cantMatch = 3;
    protected int _cantMatchDiagonal = 4;
    protected J2DM_DisplayContainer _ballsContainer = new J2DM_DisplayContainer();

    public J2DM_MatrixManager() {
        this.addChild(this._ballsContainer);
    }

    public int getCantMatch() {
        return this._cantMatch;
    }

    public void setCantMatch(int value) {
        this._cantMatch = value;
    }

    public int getCantMatchDiagonal() {
        return this._cantMatchDiagonal;
    }

    public void setCantMatchDiagonal(int value) {
        this._cantMatchDiagonal = value;
    }

    public void createBufferBalls(J2DM_Ball ball, int cant) {
        this._cantBallsInBuffer = cant;
        this._ballsBuffer = new J2DM_Ball[this._cantBallsInBuffer];
        int i = 0;
        while (i < this._cantBallsInBuffer) {
            J2DM_Ball newBall = ball.duplicate();
            newBall.unsuscribeUpdate();
            this._ballsBuffer[i] = newBall;
            ++i;
        }
    }

    public void createMatrix(int maxy, int maxx) {
        this._maxx = maxx;
        this._maxy = maxy;
        this._matrix = new J2DM_AbstractMatrixData[this._maxy][this._maxx];
        int j = 0;
        while (j < this._maxy) {
            int i;
            if (j == 0 || j == this._maxy - 1) {
                i = 0;
                while (i < this._maxx) {
                    this._matrix[j][i] = this._slotBloqued;
                    ++i;
                }
            } else {
                this._matrix[j][0] = this._slotBloqued;
                this._matrix[j][this._maxx - 1] = this._slotBloqued;
                i = 1;
                while (i < this._maxx - 1) {
                    this._matrix[j][i] = this._slotEmpty;
                    ++i;
                }
            }
            ++j;
        }
    }

    public J2DM_AbstractMatrixData[][] getMatrix() {
        return this._matrix;
    }

    public J2DM_Ball getFreeBall() {
        int i = 0;
        while (i < this._cantBallsInBuffer) {
            if (this._ballsBuffer[i].getFreeState()) {
                this._ballsBuffer[i].setFreeState(false);
                this._ballsBuffer[i].suscribeUpdate();
                return this._ballsBuffer[i];
            }
            ++i;
        }
        J2DM_Console.getInstance().addLog("J2DM_MatrixManager::getFreeBall", "There is no Free Ball in buffer", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return null;
    }

    public void fillMatrixFromDown(int cantFill, int matchLimit) {
        Vector matchBalls = new Vector();
        int i = this._maxy - 1 - cantFill;
        while (i < this._maxy - 1) {
            int j = 1;
            while (j < this._maxx - 1) {
                J2DM_Ball actualBall = this.getFreeBall();
                actualBall.setGridx(j);
                actualBall.setGridy(i);
                actualBall.refreshCoordinatesFromGridXY();
                actualBall.changeColor();
                this.addBallToMatrix(actualBall, i, j);
                this.cleanAllCheckFlags();
                matchBalls.removeAllElements();
                this.getMatchBallsFree(this._matrix, i, j, ((J2DM_TypeColorBall)actualBall._typeBall)._color, matchBalls);
                while (matchBalls.size() >= matchLimit) {
                    actualBall.changeColor();
                    this.cleanAllCheckFlags();
                    matchBalls.removeAllElements();
                    this.getMatchBallsFree(this._matrix, i, j, ((J2DM_TypeColorBall)actualBall._typeBall)._color, matchBalls);
                }
                ++j;
            }
            ++i;
        }
    }

    public void fillMatrixFromSpecialMatrix(J2DM_AbstractMatrixData[][] matrix, int matchLimit) {
        int maxx = matrix[0].length;
        int maxy = matrix.length;
        Vector matchBalls = new Vector();
        int i = 1;
        while (i < maxy - 1) {
            int j = 1;
            while (j < maxx - 1) {
                if (matrix[i][j] instanceof J2DM_MatrixDataToFillWithBall) {
                    J2DM_Ball actualBall = this.getFreeBall();
                    actualBall.setGridx(j);
                    actualBall.setGridy(i);
                    actualBall.refreshCoordinatesFromGridXY();
                    actualBall.changeColor();
                    this.addBallToMatrix(actualBall, i, j);
                    this.cleanAllCheckFlags();
                    matchBalls.removeAllElements();
                    this.getMatchBallsFree(this._matrix, i, j, ((J2DM_TypeColorBall)actualBall._typeBall)._color, matchBalls);
                    while (matchBalls.size() >= matchLimit) {
                        actualBall.changeColor();
                        this.cleanAllCheckFlags();
                        matchBalls.removeAllElements();
                        this.getMatchBallsFree(this._matrix, i, j, ((J2DM_TypeColorBall)actualBall._typeBall)._color, matchBalls);
                    }
                } else if (matrix[i][j] instanceof J2DM_MatrixDataBrick) {
                    this._matrix[i][j] = this._slotBrick;
                }
                ++j;
            }
            ++i;
        }
    }

    public void fillPresetMatrixFromDown(int cantFill, int matchLimit) {
        int[][] nArrayArray = new int[12][];
        nArrayArray[0] = new int[17];
        nArrayArray[1] = new int[17];
        nArrayArray[2] = new int[17];
        nArrayArray[3] = new int[17];
        nArrayArray[4] = new int[17];
        int[] nArray = new int[17];
        nArray[8] = 1;
        nArrayArray[5] = nArray;
        int[] nArray2 = new int[17];
        nArray2[8] = 3;
        nArrayArray[6] = nArray2;
        int[] nArray3 = new int[17];
        nArray3[8] = 1;
        nArrayArray[7] = nArray3;
        int[] nArray4 = new int[17];
        nArray4[8] = 3;
        nArrayArray[8] = nArray4;
        int[] nArray5 = new int[17];
        nArray5[1] = 2;
        nArray5[2] = 2;
        nArray5[3] = 2;
        nArray5[4] = 2;
        nArray5[5] = 2;
        nArray5[6] = 2;
        nArray5[7] = 2;
        nArray5[8] = 2;
        nArray5[9] = 2;
        nArray5[10] = 2;
        nArray5[11] = 2;
        nArray5[12] = 2;
        nArray5[13] = 2;
        nArray5[14] = 2;
        nArray5[15] = 2;
        nArrayArray[9] = nArray5;
        int[] nArray6 = new int[17];
        nArray6[1] = 2;
        nArray6[2] = 2;
        nArray6[3] = 2;
        nArray6[4] = 2;
        nArray6[5] = 2;
        nArray6[6] = 2;
        nArray6[7] = 2;
        nArray6[8] = 2;
        nArray6[9] = 2;
        nArray6[10] = 2;
        nArray6[11] = 2;
        nArray6[12] = 2;
        nArray6[13] = 2;
        nArray6[14] = 2;
        nArray6[15] = 2;
        nArrayArray[10] = nArray6;
        nArrayArray[11] = new int[17];
        int[][] lines = nArrayArray;
        int i = this._maxy - 1 - 8;
        while (i < this._maxy - 1) {
            int j = 1;
            while (j < this._maxx - 1) {
                if (lines[i][j] != 0) {
                    J2DM_Ball actualBall = this.getFreeBall();
                    actualBall.setGridx(j);
                    actualBall.setGridy(i);
                    actualBall.refreshCoordinatesFromGridXY();
                    actualBall.changeColor();
                    actualBall.setColor(lines[i][j]);
                    this.addBallToMatrix(actualBall, i, j);
                }
                ++j;
            }
            ++i;
        }
        this.printMatrix();
    }

    public void cleanAllCheckFlags() {
        int cant = this._ballsInMatrix.size();
        int i = 0;
        while (i < cant) {
            ((J2DM_Ball)this._ballsInMatrix.elementAt((int)i)).checkFlag = false;
            ++i;
        }
    }

    public void addBallToMatrix(J2DM_Ball ball, int gridy, int gridx) {
        this._matrix[gridy][gridx] = ball;
        this._ballsInMatrix.addElement(ball);
        this._ballsContainer.addChild(ball);
    }

    public void removeBallFromMatrix(J2DM_Ball ball) {
        this._matrix[ball.getGridy()][ball.getGridx()] = this._slotEmpty;
        this._ballsInMatrix.removeElement(ball);
        ball.setFreeState(true);
        ball.unsuscribeUpdate();
        this._ballsContainer.removeChild(ball);
    }

    public void destroy() {
        if (this._ballsInMatrix != null) {
            int j = 0;
            while (j < this._ballsInMatrix.size()) {
                this.removeBallFromMatrix((J2DM_Ball)this._ballsInMatrix.elementAt(j));
                ++j;
            }
        }
        if (this._ballsInMatrix != null) {
            this._ballsInMatrix.removeAllElements();
            this._ballsInMatrix = null;
        }
        int i = 0;
        while (i < this._cantBallsInBuffer) {
            if (this._ballsBuffer[i] != null) {
                this._ballsBuffer[i].destroy();
                this._ballsBuffer[i] = null;
            }
            ++i;
        }
        this._ballsBuffer = null;
        if (this._slotBloqued != null) {
            this._slotBloqued.destroy();
            this._slotBloqued = null;
        }
        if (this._slotEmpty != null) {
            this._slotEmpty.destroy();
            this._slotEmpty = null;
        }
        if (this._ballsToControl != null) {
            this._ballsToControl.removeAllElements();
            this._ballsToControl = null;
        }
        if (this._ballsContainer != null) {
            this.removeChild(this._ballsContainer);
            this._ballsContainer = null;
        }
        this._matrix = null;
        super.destroy();
    }

    public void printMatrix() {
        J2DM_Console.getInstance().addLog("----printMatrix----", "", J2DM_ConsoleMessageTypes.LOG);
        int j = 0;
        while (j < this._maxy) {
            String row = "";
            int i = 0;
            while (i < this._maxx) {
                if (this._matrix[j][i] instanceof J2DM_Ball) {
                    row = String.valueOf(row) + ",2";
                } else if (this._matrix[j][i] instanceof J2DM_MatrixDataEmpty) {
                    row = String.valueOf(row) + ",0";
                } else if (this._matrix[j][i] instanceof J2DM_MatrixDataBloqued) {
                    row = String.valueOf(row) + ",1";
                } else if (this._matrix[j][i] instanceof J2DM_MatrixDataBrick) {
                    row = String.valueOf(row) + ",3";
                }
                ++i;
            }
            J2DM_Console.getInstance().addLog(row, "", J2DM_ConsoleMessageTypes.LOG);
            ++j;
        }
    }

    public Vector updateAllBallsFromMatrix() {
        int cantBallsInMatrix = this._ballsInMatrix.size();
        this._ballsToControl.removeAllElements();
        int i = cantBallsInMatrix - 1;
        while (i >= 0) {
            J2DM_Ball actualBall = (J2DM_Ball)this._ballsInMatrix.elementAt(i);
            int flagLoop = actualBall.loop();
            if (flagLoop == 10) {
                this._ballsToControl.addElement(actualBall);
            }
            --i;
        }
        return this._ballsToControl;
    }

    public boolean checkIfThereIsAnyBallMoving() {
        int cantBallsInMatrix = this._ballsInMatrix.size();
        int i = cantBallsInMatrix - 1;
        while (i >= 0) {
            J2DM_Ball actualBall = (J2DM_Ball)this._ballsInMatrix.elementAt(i);
            if (actualBall.getDirection() != -1) {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean checkIfThereIsAnyBallInMatrix() {
        return this._ballsInMatrix.size() != 0;
    }

    public boolean checkIfThereIsAnyBallWithFreeMatching() {
        int i = 1;
        while (i < this._maxx - 1) {
            int j = 1;
            while (j < this._maxy - 1) {
                if (this._matrix[j][i] instanceof J2DM_Ball) {
                    J2DM_Ball ballToControl = (J2DM_Ball)this._matrix[j][i];
                    J2DM_StructControlBalls structBalls = this.getMatchBallsFreeMode(this._matrix, ballToControl.getGridy(), ballToControl.getGridx(), ballToControl.getColor());
                    this.cleanStructBalls(this._typeControlNewBalls, structBalls);
                    if (structBalls.ballsFree.size() > 0) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void destroyVectorOfBalls(Vector vectorBalls, Vector ballsDestroyed) {
        int cant = vectorBalls.size();
        int i = 0;
        while (i < cant) {
            J2DM_Ball ball = (J2DM_Ball)vectorBalls.elementAt(i);
            if (!ball.checkFlag) {
                ballsDestroyed.addElement(ball);
                this.removeBallFromMatrix(ball);
                ball.checkFlag = true;
            }
            ++i;
        }
    }

    public Vector destroyBalls(J2DM_StructControlBalls structBalls) {
        Vector ballsDestroyed = new Vector();
        this.cleanAllCheckFlags();
        if (structBalls.ballsFree.size() > 0) {
            this.destroyVectorOfBalls(structBalls.ballsFree, ballsDestroyed);
        }
        if (structBalls.ballsDiagonalUpLeft.size() > 0) {
            this.destroyVectorOfBalls(structBalls.ballsDiagonalUpLeft, ballsDestroyed);
        }
        if (structBalls.ballsDiagonalUpRight.size() > 0) {
            this.destroyVectorOfBalls(structBalls.ballsDiagonalUpRight, ballsDestroyed);
        }
        if (structBalls.ballsHorizontal.size() > 0) {
            this.destroyVectorOfBalls(structBalls.ballsHorizontal, ballsDestroyed);
        }
        if (structBalls.ballsVertical.size() > 0) {
            this.destroyVectorOfBalls(structBalls.ballsVertical, ballsDestroyed);
        }
        return ballsDestroyed;
    }

    public void moveBall(J2DM_Ball ball, int gridy, int gridx) {
        this._matrix[ball.getGridy()][ball.getGridx()] = this._slotEmpty;
        ball.setGridy(gridy);
        this._matrix[ball.getGridy()][ball.getGridx()] = ball;
    }

    public boolean checkIfThereIsAnyIdleBallInRow(int row) {
        int j = 1;
        while (j < this._maxx - 1) {
            if (this._matrix[row][j] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[row][j]).getDirection() == -1) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void addBallFromCoordenates(int gridY, int gridX) {
        if (gridX < 0 || gridY < 0 || gridX >= this._maxx || gridY >= this._maxy) {
            return;
        }
        if (!(this._matrix[gridY][gridX] instanceof J2DM_MatrixDataEmpty)) {
            return;
        }
        J2DM_Ball ball = this.getFreeBall();
        ball.setGridx(gridX);
        ball.setGridy(gridY);
        ball.refreshCoordinatesFromGridXY();
        ball.reset();
        ball.changeColor();
        this.addBallToMatrix(ball, gridY, gridX);
    }

    public void addRowFromLastLine(int matchLimit) {
        this.addRowFromLastLine(matchLimit, null);
    }

    public void addRowFromLastLine(int matchLimit, J2DM_Ball[] vectorOfBalls) {
        int j = 1;
        while (j < this._maxx - 1) {
            J2DM_Ball ball = this.getFreeBall();
            ball.setGridx(j);
            ball.setGridy(this._maxy - 2);
            ball.refreshCoordinatesFromGridXY();
            ball.reset();
            if (vectorOfBalls != null && j - 1 < vectorOfBalls.length) {
                ball.setColor(vectorOfBalls[j - 1].getColor());
            }
            this._ballsInMatrix.addElement(ball);
            this._ballsContainer.addChild(ball);
            this.addOneBallAndShiftUp(ball, this._maxy - 2, j);
            ++j;
        }
    }

    public void addOneBallAndShiftUp(J2DM_Ball ball, int gridy, int gridx) {
        this.setBallAndShiftUp(ball, gridy, gridx, true);
    }

    private void setBallAndShiftUp(J2DM_Ball ball, int gridy, int gridx, boolean isFirstBall) {
        if (this._matrix[gridy][gridx] instanceof J2DM_Ball) {
            J2DM_Ball _currentBall = (J2DM_Ball)this._matrix[gridy][gridx];
            this.setBallAndShiftUp(_currentBall, gridy - 1, gridx, false);
        } else if (this._matrix[gridy][gridx] instanceof J2DM_MatrixDataBrick) {
            this.setBallAndShiftUp(ball, gridy - 1, gridx, isFirstBall);
        }
        if (!(this._matrix[gridy][gridx] instanceof J2DM_MatrixDataBrick)) {
            ball.setGridx(gridx);
            ball.setGridy(gridy);
            this._matrix[gridy][gridx] = ball;
            ball.animateShiftUp();
        }
    }

    public void createLevel(int level) {
    }

    public int getEmptyMiddleColumn(J2DM_AbstractMatrixData[][] matrix) {
        boolean readFirstFillColumn = false;
        boolean flagEmptyColumn = false;
        int i = 1;
        while (i < this._maxx - 1) {
            flagEmptyColumn = true;
            int j = 1;
            while (j < this._maxy - 1) {
                if (this._matrix[j][i] instanceof J2DM_Ball) {
                    flagEmptyColumn = false;
                }
                ++j;
            }
            if (!flagEmptyColumn) {
                readFirstFillColumn = true;
            } else if (readFirstFillColumn) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void shiftBallsRight(J2DM_AbstractMatrixData[][] matrix, int gridx, int cantSteptsShifting) {
        int i = gridx;
        while (i > 0) {
            int j = 1;
            while (j < this._maxy - 1) {
                if (this._matrix[j][i - 1] instanceof J2DM_Ball && this._matrix[j][i] instanceof J2DM_MatrixDataEmpty) {
                    ((J2DM_Ball)this._matrix[j][i - 1]).shiftRight(cantSteptsShifting);
                    ((J2DM_Ball)this._matrix[j][i - 1]).setGridx(i);
                    this._matrix[j][i] = this._matrix[j][i - 1];
                    this._matrix[j][i - 1] = this._slotEmpty;
                }
                ++j;
            }
            --i;
        }
    }

    public void shiftBallsLeft(J2DM_AbstractMatrixData[][] matrix, int gridx, int cantSteptsShifting) {
        int i = gridx;
        while (i < this._maxx - 1) {
            int j = 1;
            while (j < this._maxy - 1) {
                if (this._matrix[j][i + 1] instanceof J2DM_Ball && this._matrix[j][i] instanceof J2DM_MatrixDataEmpty) {
                    ((J2DM_Ball)this._matrix[j][i + 1]).shiftLeft(cantSteptsShifting);
                    ((J2DM_Ball)this._matrix[j][i + 1]).setGridx(i);
                    this._matrix[j][i] = this._matrix[j][i + 1];
                    this._matrix[j][i + 1] = this._slotEmpty;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addNewBallsFromTopOnGridXFromVectorOfBalls(J2DM_AbstractMatrixData[][] matrix, Vector vectorBalls, int initY, int finalY) {
        int cant = vectorBalls.size();
        int[] vectorGridx = new int[cant];
        int i = 0;
        while (i < cant) {
            J2DM_Ball ball = (J2DM_Ball)vectorBalls.elementAt(i);
            vectorGridx[i] = ball.getGridx();
            ++i;
        }
        int j = 0;
        while (j < cant) {
            this.addNewBallFromTopOnGridX(matrix, vectorGridx[j], initY, finalY);
            ++j;
        }
    }

    public J2DM_Ball addNewBallFromTopOnGridX(J2DM_AbstractMatrixData[][] matrix, int xBall, int initY, int finalY) {
        if (xBall < 0 || initY < 0 || xBall >= this._maxx || finalY >= this._maxy) {
            return null;
        }
        int i = finalY;
        while (i >= initY) {
            if (this._matrix[i][xBall] instanceof J2DM_MatrixDataEmpty) {
                return this.createNewBall(i, xBall);
            }
            --i;
        }
        return null;
    }

    public J2DM_Ball createNewBall(int y, int x) {
        J2DM_Ball actualBall = this.getFreeBall();
        if (actualBall != null) {
            actualBall.setGridx(x);
            actualBall.setGridy(y);
            actualBall.refreshCoordinatesFromGridXY();
            actualBall.changeColor();
            this.addBallToMatrix(actualBall, y, x);
            return actualBall;
        }
        return null;
    }

    public J2DM_Ball[] getRowOfNewBalls(J2DM_Ball tempBall, int y) {
        J2DM_Ball[] balls = new J2DM_Ball[this._maxx - 2];
        int i = 1;
        while (i < this._maxx - 1) {
            J2DM_Ball newMovingBall = tempBall.duplicate();
            newMovingBall.setGridx(i);
            newMovingBall.setGridy(y);
            newMovingBall.refreshCoordinatesFromGridXY();
            newMovingBall.changeColor();
            newMovingBall.suscribeUpdate();
            balls[i - 1] = newMovingBall;
            ++i;
        }
        return balls;
    }

    public void getMatchBallsFree(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color, Vector ballsVector) {
        if (!(matrix[y][x] instanceof J2DM_Ball)) {
            return;
        }
        J2DM_Ball ball = (J2DM_Ball)matrix[y][x];
        if (ball.getDirection() != -1) {
            return;
        }
        if (ball.checkFlag) {
            return;
        }
        if (!(ball._typeBall instanceof J2DM_TypeColorBall)) {
            return;
        }
        int colorSel = ((J2DM_TypeColorBall)ball._typeBall)._color;
        if (colorSel != color) {
            return;
        }
        ball.checkFlag = true;
        this.getMatchBallsFree(matrix, y + 0, x + 1, color, ballsVector);
        this.getMatchBallsFree(matrix, y + 0, x - 1, color, ballsVector);
        this.getMatchBallsFree(matrix, y - 1, x + 0, color, ballsVector);
        this.getMatchBallsFree(matrix, y + 1, x + 0, color, ballsVector);
        ballsVector.addElement(ball);
    }

    public void getMatchBallsDiagonalUpRight(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color, Vector ballsVector) {
        if (!(matrix[y][x] instanceof J2DM_Ball)) {
            return;
        }
        J2DM_Ball ball = (J2DM_Ball)matrix[y][x];
        if (ball.getDirection() != -1) {
            return;
        }
        if (ball.checkFlag) {
            return;
        }
        if (!(ball._typeBall instanceof J2DM_TypeColorBall)) {
            return;
        }
        int colorSel = ((J2DM_TypeColorBall)ball._typeBall)._color;
        if (colorSel != color) {
            return;
        }
        ball.checkFlag = true;
        this.getMatchBallsDiagonalUpRight(matrix, y - 1, x + 1, color, ballsVector);
        this.getMatchBallsDiagonalUpRight(matrix, y + 1, x - 1, color, ballsVector);
        ballsVector.addElement(ball);
    }

    public void getMatchBallsDiagonalUpLeft(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color, Vector ballsVector) {
        if (!(matrix[y][x] instanceof J2DM_Ball)) {
            return;
        }
        J2DM_Ball ball = (J2DM_Ball)matrix[y][x];
        if (ball.getDirection() != -1) {
            return;
        }
        if (ball.checkFlag) {
            return;
        }
        if (!(ball._typeBall instanceof J2DM_TypeColorBall)) {
            return;
        }
        int colorSel = ((J2DM_TypeColorBall)ball._typeBall)._color;
        if (colorSel != color) {
            return;
        }
        ball.checkFlag = true;
        this.getMatchBallsDiagonalUpLeft(matrix, y - 1, x - 1, color, ballsVector);
        this.getMatchBallsDiagonalUpLeft(matrix, y + 1, x + 1, color, ballsVector);
        ballsVector.addElement(ball);
    }

    public void getMatchBallsHorizontal(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color, Vector ballsVector) {
        if (!(matrix[y][x] instanceof J2DM_Ball)) {
            return;
        }
        J2DM_Ball ball = (J2DM_Ball)matrix[y][x];
        if (ball.getDirection() != -1) {
            return;
        }
        if (ball.checkFlag) {
            return;
        }
        if (!(ball._typeBall instanceof J2DM_TypeColorBall)) {
            return;
        }
        int colorSel = ((J2DM_TypeColorBall)ball._typeBall)._color;
        if (colorSel != color) {
            return;
        }
        ball.checkFlag = true;
        this.getMatchBallsHorizontal(matrix, y, x - 1, color, ballsVector);
        this.getMatchBallsHorizontal(matrix, y, x + 1, color, ballsVector);
        ballsVector.addElement(ball);
    }

    public void getMatchBallsVertical(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color, Vector ballsVector) {
        if (!(matrix[y][x] instanceof J2DM_Ball)) {
            return;
        }
        J2DM_Ball ball = (J2DM_Ball)matrix[y][x];
        if (ball.getDirection() != -1) {
            return;
        }
        if (ball.checkFlag) {
            return;
        }
        if (!(ball._typeBall instanceof J2DM_TypeColorBall)) {
            return;
        }
        int colorSel = ((J2DM_TypeColorBall)ball._typeBall)._color;
        if (colorSel != color) {
            return;
        }
        ball.checkFlag = true;
        this.getMatchBallsVertical(matrix, y + 1, x, color, ballsVector);
        this.getMatchBallsVertical(matrix, y - 1, x, color, ballsVector);
        ballsVector.addElement(ball);
    }

    public J2DM_StructControlBalls getMatchBallsVerticalAndHorizontal(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        this.cleanAllCheckFlags();
        this.getMatchBallsHorizontal(matrix, y, x, color, structBalls.ballsHorizontal);
        this.cleanAllCheckFlags();
        this.getMatchBallsVertical(matrix, y, x, color, structBalls.ballsVertical);
        return structBalls;
    }

    public J2DM_StructControlBalls getMatchBallsFreeMode(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        this.cleanAllCheckFlags();
        this.getMatchBallsFree(matrix, y, x, color, structBalls.ballsFree);
        return structBalls;
    }

    public J2DM_StructControlBalls getMatchBallsDiagonalAndFree(J2DM_AbstractMatrixData[][] matrix, int y, int x, int color) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        this.cleanAllCheckFlags();
        this.getMatchBallsDiagonalUpLeft(matrix, y, x, color, structBalls.ballsDiagonalUpLeft);
        this.cleanAllCheckFlags();
        this.getMatchBallsDiagonalUpRight(matrix, y, x, color, structBalls.ballsDiagonalUpRight);
        this.cleanAllCheckFlags();
        this.getMatchBallsFree(matrix, y, x, color, structBalls.ballsFree);
        return structBalls;
    }

    public void cleanStructBalls(int _typeControlNewBalls, J2DM_StructControlBalls structBalls) {
        if (structBalls.ballsFree.size() < this._cantMatch) {
            structBalls.ballsFree.removeAllElements();
        }
        if (structBalls.ballsDiagonalUpLeft.size() < this._cantMatchDiagonal) {
            structBalls.ballsDiagonalUpLeft.removeAllElements();
        }
        if (structBalls.ballsDiagonalUpRight.size() < this._cantMatchDiagonal) {
            structBalls.ballsDiagonalUpRight.removeAllElements();
        }
        if (structBalls.ballsHorizontal.size() < this._cantMatch) {
            structBalls.ballsHorizontal.removeAllElements();
        }
        if (structBalls.ballsVertical.size() < this._cantMatch) {
            structBalls.ballsVertical.removeAllElements();
        }
    }

    public J2DM_StructControlBalls getAllBallsWithSameColor(int color) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        int i = 1;
        while (i < this._maxy - 1) {
            int j = 1;
            while (j < this._maxx - 1) {
                if (this._matrix[i][j] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[i][j]).getTypeBall() instanceof J2DM_TypeColorBall && ((J2DM_TypeColorBall)((J2DM_Ball)this._matrix[i][j]).getTypeBall())._color == color) {
                    structBalls.ballsFree.addElement(this._matrix[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return structBalls;
    }

    public J2DM_StructControlBalls getAllTouchingBalls(int y, int x) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        if (this._matrix[y][x] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y][x]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y][x]);
        }
        if (this._matrix[y - 1][x] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y - 1][x]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y - 1][x]);
        }
        if (this._matrix[y + 1][x] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y + 1][x]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y + 1][x]);
        }
        if (this._matrix[y][x - 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y][x - 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y][x - 1]);
        }
        if (this._matrix[y][x + 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y][x + 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y][x + 1]);
        }
        if (this._matrix[y - 1][x - 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y - 1][x - 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y - 1][x - 1]);
        }
        if (this._matrix[y - 1][x + 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y - 1][x + 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y - 1][x + 1]);
        }
        if (this._matrix[y + 1][x + 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y + 1][x + 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y + 1][x + 1]);
        }
        if (this._matrix[y + 1][x - 1] instanceof J2DM_Ball && ((J2DM_Ball)this._matrix[y + 1][x - 1]).getDirection() == -1) {
            structBalls.ballsFree.addElement(this._matrix[y + 1][x - 1]);
        }
        return structBalls;
    }

    public J2DM_StructControlBalls getAllDownBalls(int y, int x) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        int i = y;
        while (y < this._maxy - 1) {
            if (!(this._matrix[i][x] instanceof J2DM_Ball)) {
                return structBalls;
            }
            structBalls.ballsFree.addElement(this._matrix[i][x]);
            ++i;
        }
        return structBalls;
    }

    public J2DM_StructControlBalls getSideBalls(int y, int x) {
        J2DM_StructControlBalls structBalls = new J2DM_StructControlBalls();
        int i = 1;
        while (i < this._maxx - 1) {
            if (this._matrix[y][i] instanceof J2DM_Ball) {
                structBalls.ballsFree.addElement(this._matrix[y][i]);
            }
            ++i;
        }
        return structBalls;
    }
}

