/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameScore {
    static int MAX_LEVEL = 51;
    static int MAX_THEME = 3;
    static int MAX_SETTHEME = 3;
    static int MAX_FBSCORE = 11;
    public static short[] highScore = new short[MAX_LEVEL];
    public static int[] TopFive = new int[MAX_LEVEL];
    public static int[] Theme = new int[MAX_THEME];
    public static int[] SETTheme = new int[MAX_SETTHEME];
    public static boolean[] level_flag = new boolean[MAX_LEVEL];
    public static String[] highScoreName = new String[MAX_FBSCORE];
    public static RecordStore myStore;
    public static RecordStore rs;
    public static RecordStore Tscore;
    public static RecordStore RsTheme;
    public static RecordStore RsSetTheme;
    public static boolean highScoresHaveBeenInit;
    public static boolean LevellockHaveBeenInit;
    public static boolean TopFiveinit;
    public static boolean ThemeInit;
    public static boolean SetThemeInit;
    static final String REC_STORE = "ReadWriteRMS";

    public GameScore() {
        GameScore.openthemevalue();
        GameScore.openHighScores();
        GameScore.openLevelLock();
        GameScore.openTopFiveScores();
        GameScore.opensetthemevalue();
    }

    private static void initializeLock() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeBoolean(false);
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                rs.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    static void openLevelLock() {
        try {
            rs = RecordStore.openRecordStore((String)"Levellock", (boolean)true);
            if (LevellockHaveBeenInit) {
                return;
            }
            if (rs.getNumRecords() == 0) {
                GameScore.initializeLock();
            } else {
                for (int i = 0; i < MAX_LEVEL; ++i) {
                    byte[] data = rs.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.level_flag[i] = dis.readBoolean();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            LevellockHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private static void initializeTopFiveScores() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeInt(0);
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_FBSCORE; ++i) {
                Tscore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    private static void initializeScores() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeShort(0);
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                myStore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    static void openHighScores() {
        try {
            myStore = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            if (highScoresHaveBeenInit) {
                return;
            }
            if (myStore.getNumRecords() == 0) {
                GameScore.initializeScores();
            } else {
                for (int i = 0; i < MAX_LEVEL; ++i) {
                    byte[] data = myStore.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.highScore[i] = dis.readShort();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            highScoresHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void openTopFiveScores() {
        try {
            Tscore = RecordStore.openRecordStore((String)"TopFiveScore", (boolean)true);
            if (TopFiveinit) {
                return;
            }
            if (Tscore.getNumRecords() == 0) {
                GameScore.initializeTopFiveScores();
            } else {
                for (int i = 0; i < MAX_FBSCORE; ++i) {
                    byte[] data = Tscore.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.TopFive[i] = dis.readInt();
                        GameScore.highScoreName[i] = dis.readUTF();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            TopFiveinit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void closeHighScores() {
        if (myStore != null) {
            try {
                myStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            myStore = null;
        }
    }

    static void closeTopFiveScore() {
        if (Tscore != null) {
            try {
                Tscore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            Tscore = null;
        }
    }

    static void closeLevellock() {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            rs = null;
        }
    }

    public void setlevelLock(int level, boolean lvl_lock) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeBoolean(lvl_lock);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            rs.setRecord(level + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.level_flag[level] = lvl_lock;
    }

    static void setTopFiveScore(int count, int newScore, String name) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(newScore);
                das.writeUTF(name);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            Tscore.setRecord(count + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.TopFive[count] = newScore;
        GameScore.highScoreName[count] = name;
    }

    static void setTheme(int newTheme) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(newTheme);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            RsTheme.setRecord(newTheme, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.Theme[newTheme] = newTheme;
    }

    static void setHighScore(int level, int newScore, String name) {
        if (highScore[level] == 0) {
            if (newScore >= highScore[level]) {
                try {
                    byte[] data;
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        DataOutputStream das = new DataOutputStream(baos);
                        das.writeShort((short)newScore);
                        das.writeUTF(name);
                        data = baos.toByteArray();
                        das.close();
                    }
                    catch (IOException ioe) {
                        throw new RecordStoreException();
                    }
                    myStore.setRecord(level + 1, data, 0, data.length);
                }
                catch (RecordStoreException rse) {
                    // empty catch block
                }
                GameScore.highScore[level] = (short)newScore;
            }
        } else if (newScore < highScore[level]) {
            try {
                byte[] data;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream das = new DataOutputStream(baos);
                    das.writeShort((short)newScore);
                    das.writeUTF(name);
                    data = baos.toByteArray();
                    das.close();
                }
                catch (IOException ioe) {
                    throw new RecordStoreException();
                }
                myStore.setRecord(level + 1, data, 0, data.length);
            }
            catch (RecordStoreException rse) {
                // empty catch block
            }
            GameScore.highScore[level] = (short)newScore;
        }
    }

    static boolean getLevelLock(int Level2) {
        if (!LevellockHaveBeenInit) {
            GameScore.openLevelLock();
            GameScore.closeLevellock();
        }
        return level_flag[Level2];
    }

    static short getHighScore(int level) {
        if (!highScoresHaveBeenInit) {
            GameScore.openHighScores();
            GameScore.closeHighScores();
        }
        return highScore[level];
    }

    static int getTopFiveScore(int count) {
        if (!TopFiveinit) {
            GameScore.openTopFiveScores();
            GameScore.closeTopFiveScore();
        }
        return TopFive[count];
    }

    static String getHighScoreName(int count) {
        if (!TopFiveinit) {
            GameScore.openTopFiveScores();
            GameScore.closeTopFiveScore();
        }
        return highScoreName[count];
    }

    public void setthemevalue(int level, int themevalue) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(themevalue);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            RsTheme.setRecord(level + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.Theme[level] = themevalue;
    }

    static int getthemevalue(int Level2) {
        if (!ThemeInit) {
            GameScore.openLevelLock();
            GameScore.closeLevellock();
        }
        return Theme[Level2];
    }

    static void openthemevalue() {
        try {
            RsTheme = RecordStore.openRecordStore((String)"themevalue", (boolean)true);
            if (ThemeInit) {
                return;
            }
            if (RsTheme.getNumRecords() == 0) {
                GameScore.initializethemevalue();
            } else {
                for (int i = 0; i < MAX_THEME; ++i) {
                    byte[] data = RsTheme.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.Theme[i] = dis.readInt();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            ThemeInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private static void initializethemevalue() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeInt(0);
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                RsTheme.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    private static void initializesetthemevalue() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeInt(0);
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                RsSetTheme.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    public void setsetthemevalue(int level, int themevalue) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(themevalue);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            RsSetTheme.setRecord(level + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.SETTheme[level] = themevalue;
    }

    static int getsetthemevalue(int Level2) {
        if (!SetThemeInit) {
            GameScore.openLevelLock();
            GameScore.closeLevellock();
        }
        return SETTheme[Level2];
    }

    static void opensetthemevalue() {
        try {
            RsSetTheme = RecordStore.openRecordStore((String)"setthemevalue", (boolean)true);
            if (SetThemeInit) {
                return;
            }
            if (RsSetTheme.getNumRecords() == 0) {
                GameScore.initializesetthemevalue();
            } else {
                for (int i = 0; i < MAX_SETTHEME; ++i) {
                    byte[] data = RsSetTheme.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.SETTheme[i] = dis.readInt();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            SetThemeInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

