/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.main;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.animated.AnimatedPointer;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.ColorMatrixColorFilter;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    private GraphicsContainer gc;
    private MainActivity activity;
    private AnimatedElement focus = null;
    private AnimatedPointer pointer;
    private boolean keydown = false;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
    }

    public int getRZHeight() {
        return Math.max(super.getHeight(), Math.min(super.getHeight(), super.getWidth()) * 4 / 3);
    }

    public int getRZWidth() {
        return Math.min(super.getHeight(), super.getWidth());
    }

    protected void paint(Graphics graphics) {
        if (this.gc == null) {
            this.setFullScreenMode(true);
            this.gc = new GraphicsContainer(this.getWidth(), this.getHeight());
            try {
                this.pointer = new AnimatedPointer(this.activity, "pointerarrow", this.getWidth(), this.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.gc.setGraphics(graphics);
        this.gc.setColor(-1);
        if (this.getWidth() > this.getHeight() && (this.activity.getState() != 0 && this.activity.getState() != 1 || this.activity.getState() != 12)) {
            String string;
            if (this.activity.getState() == 10 && this.activity.getGameModel() != null) {
                this.activity.getGameModel().pause();
            }
            switch (this.activity.getLanguage()) {
                default: {
                    string = "Please reorientate handset screen.";
                    break;
                }
                case 1: {
                    string = "Veuillez r\u00c3\u00a9orienter l'\u00c3\u00a9cran de votre appareil.";
                    break;
                }
                case 2: {
                    string = "Bitte den Bildschirm des Handys neu orientieren.";
                    break;
                }
                case 3: {
                    string = "Reorienta o ecr\u00c3\u00a3 do telem\u00c3\u00b3vel.";
                    break;
                }
                case 4: {
                    string = "Reorienta la pantalla del dispositivo.";
                }
            }
            string = string.toUpperCase();
            this.gc.setColor(-1);
            this.gc.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.gc.setColor(-16777216);
            this.gc.translate(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2, this.getHeight() / 2 - 4);
            this.activity.getBrady().renderString(this.gc, -16777216, string);
            this.gc.translate(-(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2), -(this.getHeight() / 2 - 4));
            this.activity.invalidate();
            return;
        }
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onDraw(this.gc);
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onDraw(this.gc);
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onDraw(this.gc);
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onDraw(this.gc);
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onDraw(this.gc);
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onDraw(this.gc);
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onDraw(this.gc);
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onDraw(this.gc);
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onDraw(this.gc);
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onDraw(this.gc);
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onDraw(this.gc);
            }
        }
        this.gc.resetStack();
        boolean bl = false;
        if (this.activity.isDialogLoaded()) {
            this.pointer.setX(0.5f);
            this.pointer.setY(0.96f);
            bl = true;
        } else if (this.focus != null) {
            this.pointer.setTarget(this.focus);
        } else if (this.activity.getState() == 13 && this.activity.languageview != null) {
            this.focus = this.activity.languageview.traverse(this.focus, 1);
        } else if (this.activity.getState() == 2 && this.activity.soundview != null) {
            this.focus = this.activity.soundview.traverse(this.focus, 2);
        } else if (this.activity.getState() == 4 && this.activity.menu != null) {
            this.focus = this.activity.menu.traverse(this.focus, 1);
            if (this.focus != null) {
                this.pointer.setTarget(this.focus);
            }
        }
        if (this.activity.getState() == 10) {
            if (this.activity.getGameModel() == null || this.activity.getGameModel().showCursor()) {
                if (this.activity.getGameModel() != null && this.activity.getGameModel().isPaused()) {
                    this.pointer.setPNG("pointerarrow");
                    this.pointer.render(this.gc, 0, Long.MAX_VALUE);
                } else {
                    this.pointer.setPNG("gems_selector");
                    if (this.activity.isGemSelected()) {
                        this.pointer.setFilter(new ColorMatrixColorFilter(4));
                    } else if (this.pointer.getFilter() != Params.filter_dark) {
                        this.pointer.setFilter(null);
                    }
                    this.pointer.render(this.gc, -1, Long.MAX_VALUE);
                }
            }
        } else if (this.activity.getState() != 0 && this.activity.getState() != 1 && this.focus != null && this.activity.getState() != 5 || bl) {
            if (this.keydown) {
                this.pointer.setPNG("pointerarrow_click");
            } else {
                this.pointer.setPNG("pointerarrow");
            }
            this.pointer.render(this.gc, 0, Long.MAX_VALUE);
            this.pointer.render(this.gc, 0, Long.MAX_VALUE);
        } else if (this.activity.getState() == 5) {
            if (this.keydown) {
                this.pointer.setPNG("pointerarrow_click");
            } else {
                this.pointer.setPNG("pointerarrow");
            }
            if (this.activity.mapview != null && this.activity.mapview.needsTranslate(this.focus)) {
                this.gc.save();
                this.gc.translate(-240, 0);
                if (this.activity.mapview.needsDoubleTranslate(this.focus)) {
                    this.gc.translate(-240, 0);
                }
                this.pointer.render(this.gc, 0, Long.MAX_VALUE);
                this.gc.restore();
            } else {
                this.pointer.render(this.gc, 0, Long.MAX_VALUE);
            }
        }
        this.gc.resetStack();
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                return this.activity.gameview.traverse(this.focus, n);
            }
            case 5: {
                return this.activity.mapview.traverse(this.focus, n);
            }
            case 8: {
                return this.activity.pregameview.traverse(this.focus, n);
            }
            case 9: {
                return this.activity.postgameview.traverse(this.focus, n);
            }
            case 6: {
                return this.activity.selectionview.traverse(this.focus, n);
            }
            case 4: {
                return this.activity.menu.traverse(this.focus, n);
            }
            case 2: {
                return this.activity.soundview.traverse(this.focus, n);
            }
            case 13: {
                return this.activity.languageview.traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
        this.focus = animatedElement;
        if (animatedElement != null) {
            this.pointer.setTarget(animatedElement);
        }
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
        if (n != 48) {
            if (n == -6) {
                if (this.activity.getState() == 5 && this.activity.mapview != null) {
                    this.activity.mapview.showLeft();
                } else if (this.activity.getState() == 6 && this.activity.selectionview != null) {
                    this.activity.onBackPressed();
                }
                return;
            }
            if (n == -7) {
                if (this.activity.getState() == 5 && this.activity.mapview != null) {
                    this.activity.mapview.showRight();
                } else if (this.activity.getState() == 10 && this.activity.gameview != null) {
                    this.activity.gameview.lsk();
                }
                return;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                if (this.activity.getState() != 10) {
                    this.pointer.setPNG("pointerarrow_click");
                }
                this.keydown = true;
                this.pointer.setFilter(Params.filter_dark);
                System.out.println("press at: " + (int)this.pointer.getX(Long.MAX_VALUE) + ", " + (int)this.pointer.getY(Long.MAX_VALUE));
                this.pointerPressed((int)this.pointer.getX(Long.MAX_VALUE), (int)this.pointer.getY(Long.MAX_VALUE));
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.focus = this.getNeighbor(this.getGameAction(n));
                if (this.focus == null) break;
                this.pointer.setTarget(this.focus);
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        if (this.activity.getState() != 10) {
            this.pointer.setPNG("pointerarrow");
        }
        this.keydown = false;
        switch (this.getGameAction(n)) {
            case 8: {
                this.pointerReleased((int)this.pointer.getX(Long.MAX_VALUE), (int)this.pointer.getY(Long.MAX_VALUE));
                this.pointer.setFilter(null);
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

