/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class World {
    public static final int CELL_BOMB = 6;
    public static final int CELL_CANNON = 5;
    public static final int CELL_EXIT = 3;
    public static final int CELL_FREE = 0;
    public static final int CELL_MIRROR = 4;
    public static final int CELL_STONE = 2;
    public static final int CELL_WALL = 1;
    public static int CannonNumber;
    public static Cell[] Cannons;
    public static int[] CannonsColor;
    public static int[] CannonsDeltaColor;
    public static short[] CannonsI;
    public static short[] CannonsJ;
    public static Cell[][] Cells;
    static int CenterX;
    static int CenterY;
    public static Animation Clock;
    public static boolean DestroySourceCannon;
    public static byte DrawState;
    public static Image Ground;
    static int GroundI;
    static int GroundJ;
    static int GroundTilesH;
    static int GroundTilesW;
    public static int H;
    public static int Level;
    public static long PauseTime;
    public static boolean Retrace;
    static int ScreenTileH;
    static int ScreenTileW;
    public static long StartTime;
    public static final int TILE_H = 12;
    public static final int TILE_W = 12;
    public static Animation Turns;
    public static int W;
    public static final int[] WALL_ARRAY;
    public static Laser curLaser;
    static DetonatingCell detList;
    public static boolean isScroll;
    public static Laser[] lasers;
    public static int lasersQty;
    public static int levelPixelH;
    public static int levelPixelW;
    public static int startCellI;
    public static int startCellJ;
    public static int startCellX;
    public static int startCellY;

    static {
        Level = 1;
        DestroySourceCannon = false;
        Retrace = true;
        DrawState = 1;
        WALL_ARRAY = new int[]{1, 17, 19, 14, 16, 1, 7, 11, 18, 10, 6, 12, 5, 9, 8, 13};
        lasers = null;
    }

    public static void Draw() {
        if (DrawState == 1) {
            int endJ;
            Game.Gfx.translate(-Game.Screen_X, -Game.Screen_Y);
            Game.Gfx.drawImage(Ground, startCellX, startCellY, 20);
            int endI = GroundI + ScreenTileW + 1;
            if (endI > W) {
                endI = W;
            }
            if ((endJ = GroundJ + ScreenTileH + 1) > H) {
                endJ = H;
            }
            Cell cell = null;
            Cell[] cellsRow = null;
            int i = GroundI;
            while (i < endI) {
                cellsRow = Cells[i];
                int j = GroundJ;
                while (j < endJ) {
                    cell = cellsRow[j];
                    if (cell.Ani != null) {
                        cell.Draw();
                    }
                    ++j;
                }
                ++i;
            }
            i = Cannons.length;
            while (i != 0) {
                if (lasers[--i] == null) continue;
                Game.Gfx.setColor(CannonsColor[i], 89, 255 - CannonsColor[i]);
                lasers[i].draw();
            }
            Kent.Draw();
            Game.Gfx.translate(-Game.Gfx.getTranslateX(), -Game.Gfx.getTranslateY());
        } else if (DrawState == 4) {
            int x = (Game.Screen_W >> 1) - 33;
            if (StartTime != 0L) {
                long LevelTime = System.currentTimeMillis() - StartTime;
                boolean NewRecord = LevelManager.setBestTime(LevelTime, Level);
                int LevelMin = (int)LevelTime / 60000;
                int LevelSec = (int)(LevelTime % 60000L) / 1000;
                StringBuffer s = new StringBuffer();
                s.append(Game.BEST_TIME);
                s.append(' ');
                LevelMin = (int)(LevelTime / 60000L);
                LevelSec = (int)(LevelTime % 60000L / 1000L);
                if (LevelMin < 10) {
                    s.append('0');
                }
                s.append(Integer.toString(LevelMin));
                s.append(':');
                if (LevelSec < 10) {
                    s.append('0');
                }
                s.append(Integer.toString(LevelSec));
                Game.Gfx.setColor(0xFFFFFF);
                Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
                Game.Menu.Draw(Game.Screen_W - Game.Menu.w >> 1, 0);
                Game.Gfx.setColor(0);
                Game.Gfx.setFont(Font.getFont((int)64, (int)0, (int)8));
                Game.Gfx.drawString(Game.LEVEL + " " + (Level + 1) + " " + Game.COMPLETED, Game.Screen_W >> 1, 45, 1 | 0x10);
                if (LevelMin > 0) {
                    Game.Gfx.drawString(LevelMin + " " + Game.MIN + " " + LevelSec + " " + Game.SEC, x + 16, 73, 4 | 0x10);
                } else {
                    Game.Gfx.drawString(LevelSec + " " + Game.SEC, x + 16, 73, 4 | 0x10);
                }
                Game.Gfx.drawString(Kent.TurnCounter + " " + Game.TURNS, x + 16, 103, 4 | 0x10);
                StartTime = 0L;
                if (NewRecord) {
                    Game.Gfx.setColor(0xFF0000);
                    Game.Gfx.setFont(Font.getFont((int)64, (int)1, (int)8));
                    Game.Gfx.drawString(Game.NEW_BEST_TIME, Game.Screen_W >> 1, 130, 1 | 0x10);
                    Game.Gfx.setColor(0);
                    Game.Gfx.setFont(Font.getFont((int)64, (int)0, (int)8));
                } else {
                    long time = LevelManager.setLevelTime[Level];
                    s = new StringBuffer();
                    s.append(Game.BEST_TIME);
                    s.append(' ');
                    LevelMin = (int)(time / 60000L);
                    LevelSec = (int)(time % 60000L / 1000L);
                    if (LevelMin < 10) {
                        s.append('0');
                    }
                    s.append(Integer.toString(LevelMin));
                    s.append(':');
                    if (LevelSec < 10) {
                        s.append('0');
                    }
                    s.append(Integer.toString(LevelSec));
                    Game.Gfx.drawString(s.toString(), Game.Screen_W >> 1, 130, 1 | 0x10);
                }
            }
            Clock.Draw(x, 70);
            Turns.Draw(x, 100);
            if (World.Clock.Frame == 0) {
                Game.Gfx.setFont(Font.getFont((int)64, (int)0, (int)8));
                Game.Gfx.setColor(0);
                Game.Gfx.drawString(Game.PRESS_ANY_KEY, Game.Screen_W >> 1, Game.Screen_H - 1, 1 | 0x20);
            } else if (World.Clock.Frame == 4) {
                Game.Gfx.setFont(Font.getFont((int)64, (int)0, (int)8));
                Game.Gfx.setColor(0xFFFFFF);
                Game.Gfx.drawString(Game.PRESS_ANY_KEY, Game.Screen_W >> 1, Game.Screen_H - 1, 1 | 0x20);
            }
        } else if (DrawState == 5) {
            Game.Gfx.setColor(0xFFFFFF);
            Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
            Game.Gfx.setColor(0);
            Game.Gfx.drawString(Game.LOADING, Game.Screen_W >> 1, Game.Screen_H >> 1, 1 | 0x10);
        } else if (DrawState == 6) {
            Game.Gfx.setColor(0xFFFFFF);
            Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
            Animation finalSplash = new Animation("win");
            finalSplash.Draw(Game.Screen_W - finalSplash.w >> 1, Game.Screen_H - finalSplash.h >> 1);
            finalSplash = null;
            System.gc();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void DrawWalls() {
        if (World.startCellI == World.GroundI && World.startCellJ == World.GroundJ) {
            return;
        }
        save = true;
        if (World.GroundI < 0 || World.GroundJ < 0) {
            save = false;
        }
        g = World.Ground.getGraphics();
        di = World.GroundI - World.startCellI;
        dj = World.GroundJ - World.startCellJ;
        World.GroundI = World.startCellI;
        World.GroundJ = World.startCellJ;
        x = 0;
        y = 0;
        endI = World.GroundI + World.ScreenTileW + 1;
        if (endI > World.W) {
            endI = World.W;
        }
        if ((endJ = World.GroundJ + World.ScreenTileH + 1) > World.H) {
            endJ = World.H;
        }
        cell = null;
        cellsRow = null;
        i = World.GroundI;
        while (i < endI) {
            y = 0;
            cellsRow = World.Cells[i];
            j = World.GroundJ;
            while (j < endJ) {
                cell = cellsRow[j];
                ani = cell.Ani;
                frame = cell.f;
                if (cell.type != 1 && cell.type != 3) {
                    frame = 0;
                }
                if (!save) ** GOTO lbl-1000
                it = di + i;
                jt = dj + j;
                if (it < 0 || jt < 0 || it >= World.W || jt >= World.H) ** GOTO lbl-1000
                t1 = World.Cells[it][jt];
                oldframe = t1.f;
                if (t1.type != 1 && t1.type != 3) {
                    oldframe = 0;
                }
                if (frame == oldframe && (cell.type != 2 && t1.type != 2 || cell.type == 2 && t1.Ani == ani)) {
                    y += 12;
                } else lbl-1000:
                // 3 sources

                {
                    Cell.CurTiles.Frame = frame;
                    Cell.CurTiles.Draw(g, x, y);
                    cell.drawOnBack();
                    y += 12;
                }
                ++j;
            }
            x += 12;
            ++i;
        }
    }

    public static void Init() {
        Kent.Init();
        Cell.InitTiles();
        Clock = new Animation("clock", 8);
        Turns = new Animation(Kent.aniRight);
        ScreenTileW = Game.Screen_W / 12 + 1;
        ScreenTileH = Game.Screen_H / 12 + 1;
        CenterX = Game.Screen_W >> 1;
        CenterY = Game.Screen_H >> 1;
    }

    public static void Load(int Num) {
        Cells = null;
        Cannons = null;
        CannonsJ = null;
        CannonsI = null;
        CannonsDeltaColor = null;
        CannonsColor = null;
        lasers = null;
        detList = null;
        System.gc();
        if (Num == LevelManager.setLevelQty[LevelManager.currentSet]) {
            Game.Key = -1;
            Game.Stop();
            Game.Play(2);
            DrawState = (byte)6;
            Game.Draw();
            while (Game.Key == -1) {
            }
            Game.MenuState = 0;
            Game.Redraw = true;
            Game.GameState = 2;
            Game.MenuText = Game.MainMenuText;
            Game.Key = -1;
        } else {
            int j;
            int i;
            DrawState = (byte)5;
            Game.Draw();
            Game.Stop();
            Game.Play(2);
            DrawState = (byte)5;
            int CannonsQty = 0;
            System.gc();
            InputStream is = null;
            try {
                is = LevelManager.getLevel(Num);
                if (is != null) {
                    W = is.read();
                    H = is.read();
                    Cell.setCurTiles(is.read());
                    int di = 0;
                    int dj = 0;
                    int realW = W;
                    int realH = H;
                    if (W < ScreenTileW) {
                        W = ScreenTileW;
                        di = W - realW >> 1;
                    }
                    if (H < ScreenTileH) {
                        H = ScreenTileH;
                        dj = H - realH >> 1;
                    }
                    Cells = new Cell[W][H];
                    levelPixelW = W * 12;
                    levelPixelH = H * 12;
                    int b = 0;
                    boolean oneMoreTile = false;
                    i = 0;
                    while (i < W) {
                        j = 0;
                        while (j < H) {
                            if (i < di || j < dj || i >= di + realW || j >= dj + realH) {
                                World.Cells[i][j] = new Cell(0, i, j);
                            } else {
                                byte data = 0;
                                if (!oneMoreTile) {
                                    b = is.read();
                                    if (b < 0) {
                                        b += 256;
                                    }
                                    data = (byte)((b & 0xF0) >> 4);
                                    oneMoreTile = true;
                                } else {
                                    data = (byte)(b & 0xF);
                                    oneMoreTile = false;
                                }
                                if (data == 11) {
                                    Kent.i = i;
                                    Kent.j = j;
                                    Kent.x = i * 12;
                                    Kent.y = j * 12;
                                    data = 0;
                                }
                                World.Cells[i][j] = new Cell(data, i, j);
                                if (World.Cells[i][j].type == 5) {
                                    ++CannonsQty;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    is.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Cannons = new Cell[CannonsQty];
            CannonsI = new short[CannonsQty];
            CannonsJ = new short[CannonsQty];
            CannonsColor = new int[CannonsQty];
            CannonsDeltaColor = new int[CannonsQty];
            lasers = new Laser[CannonsQty];
            int i1 = 0;
            Random r = new Random();
            Random TileRandom = new Random(1456017315L);
            i = W;
            while (i != 0) {
                Cell[] cellsRow = Cells[--i];
                j = H;
                while (j != 0) {
                    int t;
                    Cell cell = cellsRow[--j];
                    if (cell.type == 5) {
                        World.Cannons[i1] = cell;
                        t = r.nextInt() % 255;
                        if (t < 0) {
                            t = -t;
                        }
                        World.CannonsColor[i1] = t;
                        t = r.nextInt() % 5;
                        if (t < 0) {
                            t = -t;
                        }
                        World.CannonsDeltaColor[i1] = ++t;
                        World.CannonsI[i1] = (short)i;
                        World.CannonsJ[i1] = (short)j;
                        ++i1;
                        continue;
                    }
                    if (cell.type != 1) continue;
                    t = WALL_ARRAY[(World.isWall(i - 1, j) << 0) + (World.isWall(i, j - 1) << 1) + (World.isWall(i + 1, j) << 2) + (World.isWall(i, j + 1) << 3)];
                    if (t == 1) {
                        t = TileRandom.nextInt() % 3;
                        if (t < 0) {
                            t = -t;
                        }
                        ++t;
                    }
                    cell.f = (byte)t;
                }
            }
            Level = Num;
            GroundJ = -1;
            GroundI = -1;
            startCellJ = 0;
            startCellI = 0;
            startCellX = 0;
            startCellY = 0;
            World.updateStartCell();
            Kent.DeathProgress = 0;
            Kent.MovingTo = 0;
            Kent.aniCurrent = Kent.aniMain;
            Kent.StopCounter = 0;
            Kent.TurnCounter = 0;
            World.TraceAll();
            DrawState = 1;
            Game.Key = -1;
            System.gc();
            StartTime = System.currentTimeMillis();
        }
    }

    public static void NextLevel() {
        Game.Stop();
        Game.Play(3);
        Game.Key = -1;
        while (Game.Key == -1) {
            DrawState = (byte)4;
            Game.Draw();
            try {
                Thread.sleep(30L);
            }
            catch (Exception ex) {
            }
        }
        World.Load(Level + 1);
        Game.Key = -1;
    }

    public static void Process() {
        int i;
        boolean screenRelocated = false;
        if ((Game.LastKey == 49 || Game.LastKey == 51) && Game.Screen_Y > 0) {
            if ((Game.Screen_Y -= 4) < 0) {
                Game.Screen_Y = 0;
            }
            screenRelocated = true;
        }
        if ((Game.LastKey == 49 || Game.LastKey == 55) && Game.Screen_X > 0) {
            if ((Game.Screen_X -= 4) < 0) {
                Game.Screen_X = 0;
            }
            screenRelocated = true;
        }
        if ((Game.LastKey == 55 || Game.LastKey == 57) && Game.Screen_Y + Game.Screen_H < (H << 3) + (H << 2) - 1) {
            if ((Game.Screen_Y += 4) + Game.Screen_H >= (H << 3) + (H << 2)) {
                Game.Screen_Y = (H << 3) + (H << 2) - Game.Screen_H - 1;
            }
            screenRelocated = true;
        }
        if ((Game.LastKey == 51 || Game.LastKey == 57) && Game.Screen_X + Game.Screen_W < (W << 3) + (W << 2) - 1) {
            if ((Game.Screen_X += 4) + Game.Screen_W >= (W << 3) + (W << 2)) {
                Game.Screen_X = (W << 3) + (W << 2) - Game.Screen_W - 1;
            }
            screenRelocated = true;
        }
        if (screenRelocated) {
            isScroll = true;
            World.updateStartCell();
        }
        DetonatingCell detCell = detList;
        Cell cell = null;
        while (detCell != null) {
            cell = detCell.cell;
            if (detCell.counter != 0) {
                --detCell.counter;
                if (cell.type == 0) {
                    if (detCell.counter == 0) {
                        cell.Ani = null;
                    } else if (detCell.counter > 10) {
                        Game.Play(4);
                    }
                }
                if (cell.type == 5) {
                    cell.f ^= 8;
                    if (detCell.counter > 18) {
                        Game.Play(5);
                    } else if (detCell.counter == 0) {
                        detCell.cell.f &= 0xFFFFFFF3;
                        cell.type = 0;
                        cell.Detonate(detCell.i, detCell.j);
                        Retrace = true;
                    }
                }
                if (detCell.counter == 0 && cell.type == 6) {
                    i = detCell.i;
                    int j = detCell.j;
                    Cell.boom(i - 1, j);
                    Cell.boom(i + 1, j);
                    Cell.boom(i, j - 1);
                    Cell.boom(i, j + 1);
                    detCell.cell.f &= 0xFFFFFFF3;
                    cell.type = 0;
                    cell.Detonate(i, j);
                    Retrace = true;
                }
            }
            if (detCell.counter == 0) {
                detCell.cell.f &= 0xFFFFFFF3;
                if (detCell.next != null) {
                    detCell.next.prev = detCell.prev;
                }
                if (detCell.prev != null) {
                    detCell.prev.next = detCell.next;
                }
                if (detCell == detList) {
                    detList = detCell.next;
                }
            }
            detCell = detCell.next;
        }
        i = Cannons.length;
        while (i != 0) {
            int tempColor;
            if ((tempColor = CannonsColor[--i] + CannonsDeltaColor[i]) > 0 && tempColor < 255) {
                World.CannonsColor[i] = tempColor;
                continue;
            }
            World.CannonsDeltaColor[i] = -CannonsDeltaColor[i];
        }
        Kent.Process();
        if (Retrace) {
            World.TraceAll();
        }
        DrawState = 1;
    }

    public static void TraceAll() {
        int j;
        DrawState = 1;
        int i = W;
        while (i != 0) {
            Cell[] cellsRow = Cells[--i];
            j = H;
            while (j != 0) {
                Cell t = cellsRow[--j];
                if (t.type != 0 && t.type != 4) continue;
                t.f &= 0xFFFFFFFD;
            }
        }
        Retrace = false;
        int k = Cannons.length;
        while (k != 0) {
            if (World.Cannons[--k].type != 5 || Kent.movingCell == Cannons[k]) {
                World.lasers[k] = null;
                continue;
            }
            DestroySourceCannon = false;
            i = CannonsI[k];
            j = CannonsJ[k];
            int t = World.Cannons[k].f & 3;
            int x = 0;
            int y = 0;
            if (t == 0) {
                y = 1;
            } else if (t == 1) {
                x = 1;
            } else if (t == 2) {
                y = -1;
            } else if (t == 3) {
                x = -1;
            }
            World.lasers[k] = curLaser = World.getNextLaser(World.Cannons[k].x, World.Cannons[k].y, x, y, -1);
            World.TraceRay(i + x, j + y, x, y);
            if (!DestroySourceCannon) continue;
            Cells[i][j].Detonate(i, j);
        }
    }

    public static void TraceRay(int i, int j, int x, int y) {
        if (i < 0 || j < 0 || i >= W || j >= H) {
            return;
        }
        int b = World.Cells[i][j].type;
        if (b == 0 && Kent.i == i && Kent.j == j && Kent.DeathProgress == 0) {
            Kent.Kill();
        } else {
            if (b == 0) {
                World.Cells[i][j].f |= 2;
                World.curLaser.x2 += (x << 3) + (x << 2);
                World.curLaser.y2 += (y << 3) + (y << 2);
                World.TraceRay(i + x, j + y, x, y);
                return;
            }
            if (b == 4) {
                Cell cell = Cells[i][j];
                if (cell == Kent.movingCell) {
                    return;
                }
                cell.f |= 2;
                if (y == -1) {
                    World.curLaser.y2 -= 6;
                } else if (x == 1 && (cell.f & 1) == 0) {
                    World.curLaser.x2 += 6;
                } else if (x == -1 && (cell.f & 1) == 1) {
                    World.curLaser.x2 -= 6;
                }
                int t = x;
                if ((cell.f & 1) == 1) {
                    x = -y;
                    y = -t;
                } else {
                    x = y;
                    y = t;
                }
                curLaser = World.curLaser.nextLaser = World.getNextLaser(cell.x, cell.y, x, y, cell.f & 1);
                World.TraceRay(i + x, j + y, x, y);
            } else if (b == 5) {
                int t = World.Cells[i][j].f & 3;
                int x1 = 0;
                int y1 = 0;
                if (t == 0) {
                    y1 = -1;
                } else if (t == 1) {
                    x1 = -1;
                } else if (t == 2) {
                    y1 = 1;
                } else if (t == 3) {
                    x1 = 1;
                }
                if (x1 == x && y1 == y) {
                    DestroySourceCannon = true;
                }
                Cells[i][j].Detonate(i, j);
            } else if (b == 6) {
                Cells[i][j].Detonate(i, j);
            }
        }
    }

    public static Laser getNextLaser(int x, int y, int dx, int dy, int mirrorOrient) {
        Laser laser = new Laser(x += 6 + (dx << 2) + (dx << 1), y += 6 + (dy << 2) + (dy << 1));
        if (mirrorOrient != -1) {
            if (dy == 1) {
                laser.y1 -= 6;
            } else if (dx == 1 && mirrorOrient == 1) {
                laser.x1 -= 6;
            } else if (dx == -1 && mirrorOrient == 0) {
                laser.x1 += 6;
            }
        }
        return laser;
    }

    public static int isWall(int i, int j) {
        if (i < 0 || j < 0 || i >= W || j >= H || World.Cells[i][j].type != 1 && World.Cells[i][j].type != 3) {
            return 0;
        }
        return 1;
    }

    public static void updateStartCell() {
        if (!isScroll) {
            Game.Screen_X = Kent.x - CenterX;
            Game.Screen_Y = Kent.y - CenterY;
            if (Game.Screen_X < 0) {
                Game.Screen_X = 0;
            }
            if (Game.Screen_Y < 0) {
                Game.Screen_Y = 0;
            }
            if (Game.Screen_X + Game.Screen_W > levelPixelW) {
                Game.Screen_X = levelPixelW - Game.Screen_W;
            }
            if (Game.Screen_Y + Game.Screen_H > levelPixelH) {
                Game.Screen_Y = levelPixelH - Game.Screen_H;
            }
        }
        while (Game.Screen_X < startCellX) {
            startCellX -= 12;
            --startCellI;
        }
        while (Game.Screen_X > startCellX + 12) {
            startCellX += 12;
            ++startCellI;
        }
        while (Game.Screen_Y < startCellY) {
            startCellY -= 12;
            --startCellJ;
        }
        while (Game.Screen_Y > startCellY + 12) {
            startCellY += 12;
            ++startCellJ;
        }
        World.DrawWalls();
    }
}

