/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.midlet.MIDlet;

public final class SoundManager
implements PlayerListener {
    private Player LastSound;
    public Player[] Players;
    public static boolean SoundIsOn = false;
    public static boolean VibraIsOn = false;
    public int loopCount = 1;
    private static Canvas myCanvas;
    private static MIDlet myMidlet;
    public int playerIndex = -1;
    public static long[][] soundLength;

    public SoundManager(MIDlet myMidlet, Canvas myCanvas, String[] soundNames, long[][] soundLength) {
        SoundManager.myMidlet = myMidlet;
        SoundManager.myCanvas = myCanvas;
        SoundManager.soundLength = soundLength;
        this.Players = new Player[soundNames.length];
        int i = 0;
        while (i < soundNames.length) {
            this.Players[i] = this.createPlayer(soundNames[i]);
            ++i;
        }
    }

    public Player createPlayer(String fileName) {
        Player newPlayer = null;
        int i = 0;
        String[] soundTypes = new String[]{"audio/midi", "audio/amr", "audio/x-wav", "audio/mmf"};
        String[] fileExtensions = new String[]{".mid", ".amr", ".wav", ".mmf"};
        while (newPlayer == null && i < soundTypes.length) {
            try {
                newPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(fileName + fileExtensions[i]), (String)soundTypes[i]);
                newPlayer.realize();
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        if (newPlayer == null) {
            System.out.println("Not found: " + fileName);
        }
        return newPlayer;
    }

    public void destroy() {
        this.stop();
        this.Players = null;
    }

    public boolean isPlayed() {
        if (this.LastSound != null) {
            if (this.loopCount == -1) {
                return true;
            }
            if (this.LastSound.getState() == 400) {
                return true;
            }
        }
        return false;
    }

    private boolean play() {
        if (this.LastSound != null) {
            if (this.LastSound.getState() == 400) {
                return false;
            }
        }
        int realPlayerIndex = 0;
        while (this.playerIndex >= soundLength[realPlayerIndex].length) {
            this.playerIndex -= soundLength[realPlayerIndex].length;
            ++realPlayerIndex;
        }
        if (this.LastSound != this.Players[realPlayerIndex]) {
            this.stop();
            this.LastSound = this.Players[realPlayerIndex];
            try {
                this.LastSound.prefetch();
            }
            catch (Exception ex1) {
            }
        }
        try {
            this.LastSound.setMediaTime(soundLength[realPlayerIndex][this.playerIndex]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        StopTimeControl pControl = (StopTimeControl)this.LastSound.getControl("StopTimeControl");
        if (pControl != null && this.playerIndex + 1 < soundLength[realPlayerIndex].length) {
            pControl.setStopTime(soundLength[realPlayerIndex][this.playerIndex + 1] + 1000L);
        }
        try {
            try {
                if (this.loopCount == -1 || this.loopCount > 1) {
                    this.LastSound.addPlayerListener((PlayerListener)this);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.LastSound.start();
        }
        catch (Exception e) {
            this.stop();
            return false;
        }
        return true;
    }

    public void play(int index, int new_loopCount) {
        if (!SoundIsOn) {
            return;
        }
        this.loopCount = new_loopCount;
        this.playerIndex = index;
        this.play();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if ((event.equals("endOfMedia") || event.equals("stopped") || event.equals("stoppedAtTime")) && (this.loopCount == -1 || --this.loopCount > 0)) {
            try {
                this.play();
            }
            catch (Exception e) {
            }
        }
    }

    public void setPriority(String priority) {
    }

    public void stop() {
        if (this.LastSound != null) {
            this.loopCount = 1;
            this.LastSound.removePlayerListener((PlayerListener)this);
            if (this.LastSound.getState() == 400) {
                try {
                    this.LastSound.stop();
                }
                catch (Exception e) {
                }
            }
            this.LastSound.deallocate();
            this.LastSound = null;
        }
    }

    public static void vibrate(int duration_in_ms) {
        if (VibraIsOn) {
            try {
                Display.getDisplay((MIDlet)myMidlet).vibrate(duration_in_ms);
            }
            catch (Exception ex) {
            }
        }
    }
}

