/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Base;
import com.twistfuture.Game.GameManager;
import com.twistfuture.Game.LevelCanvas;
import com.twistfuture.app.GeneralFunction;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Symbol {
    private Image tempImgae;
    private int x;
    private int y;
    private int endX;
    private int endY;
    private int width;
    private int height;
    private final int index;
    private int pX;
    private int pY;
    private boolean isDragged;
    private int rotationCounter;
    private int count;
    private final CallBack callBack;
    private boolean isSetted;
    private int[][] data;
    private int initialX;
    private int initialY;

    public Symbol(int path, int index, int[][] data, CallBack callBack) {
        this.data = data;
        this.index = index;
        this.callBack = callBack;
        this.tempImgae = GeneralFunction.createImage("maincanvas/levels/" + LevelCanvas.mCurrentLevel + "/" + path + ".png");
        this.setDimensions();
    }

    public void paint(Graphics g) {
        g.drawImage(this.tempImgae, this.x, this.y, 0);
    }

    protected int pointerPressed(int x1, int y1) {
        if (x1 > this.x && x1 < this.endX && y1 > this.y && y1 < this.endY) {
            this.initialX = this.x;
            this.initialY = this.y;
            this.pX = x1;
            this.pY = y1;
            this.isDragged = false;
            return this.index;
        }
        return -1;
    }

    public void release() {
        if (this.isSetted) {
            this.isSetted = false;
            this.x -= 10;
            this.y -= 10;
            this.callBack.releaseSymbol(this, this.initialX, this.initialY);
        }
    }

    protected void pointerReleased(int x1, int y1) {
        if (!this.isDragged && x1 > this.x && x1 < this.endX && y1 > this.y && y1 < this.endY) {
            if (this.x > Base.x && this.x < Base.endX && this.y > Base.y && this.y < Base.endY) {
                return;
            }
            this.rotate();
        }
        if (this.x > Base.x && this.x < Base.endX && this.y > Base.y && this.y < Base.endY) {
            this.isSetted = true;
            this.callBack.setSymbol(this, this.x, this.y);
        }
    }

    protected void pointerDragged(int x1, int y1) {
        int diffX = x1 - this.pX;
        int diffY = y1 - this.pY;
        if (Math.abs(diffX) > 0 && Math.abs(diffY) > 0) {
            this.isDragged = true;
            int nextX = this.x + diffX;
            int nextY = this.y + diffY;
            if (nextX < 2) {
                nextX = 5;
            } else if (nextX > 320) {
                nextX = 317;
            }
            if (nextY < 2) {
                nextY = 5;
            } else if (nextY > 235) {
                nextY = 232;
            }
            this.x = nextX;
            this.y = nextY;
            this.endX = this.x + this.width;
            this.endY = this.y + this.height;
            this.pX = x1;
            this.pY = y1;
        }
    }

    private void rotate() {
        ++this.rotationCounter;
        if (this.rotationCounter == 4) {
            this.rotationCounter = 0;
        }
        this.tempImgae = Image.createImage((Image)this.tempImgae, (int)0, (int)0, (int)this.width, (int)this.height, (int)5);
        this.width = this.tempImgae.getWidth();
        this.height = this.tempImgae.getHeight();
        GameManager.SOUND_MANGER.playSound("twist");
        this.rotatematrix();
        this.setDimensions();
    }

    private void setDimensions() {
        this.width = this.tempImgae.getWidth();
        this.height = this.tempImgae.getHeight();
        if (this.count == 0) {
            ++this.count;
            if (this.index < 3) {
                this.x = 15;
                this.y = 10 + 60 * this.index;
            } else if (this.index < 6) {
                this.x = 315 - this.width;
                this.y = 10 + 65 * (this.index % 3);
            } else {
                this.x = 175 - this.width / 2;
                this.y = 190;
            }
        }
        this.endX = this.x + this.width;
        this.endY = this.y + this.height;
    }

    private void rotatematrix() {
        int n = this.data[0].length;
        int m = this.data.length;
        int[][] tempdata = new int[n][m];
        int l = m - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                tempdata[i][l - j] = this.data[j][i];
            }
        }
        this.data = tempdata;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getRow() {
        return this.data.length;
    }

    public int getColumn() {
        return this.data[0].length;
    }

    public int getData(int row, int column) {
        return this.data[row][column];
    }

    public boolean isIsSetted() {
        return this.isSetted;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public static interface CallBack {
        public void setSymbol(Symbol var1, int var2, int var3);

        public void releaseSymbol(Symbol var1, int var2, int var3);
    }
}

