/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Base;
import com.twistfuture.Game.Data;
import com.twistfuture.Game.LevelCanvas;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.Game.Symbol;
import com.twistfuture.utility.SoundManger;
import javax.microedition.lcdui.Graphics;

public class GameManager
implements Symbol.CallBack {
    private final Base base;
    private final Symbol[] symbol;
    private final int[] noOfSymbols = new int[]{1, 2, 4, 3, 3, 2, 4, 5, 4, 4, 5, 3, 7, 7, 6, 7, 5, 5, 5, 7};
    private final int noOfSymbol;
    public static boolean levelCompleted;
    public static final int fieldX = 2;
    public static final int fieldY = 2;
    public static final int FieldEndX = 350;
    public static final int FieldEndY = 235;
    private final int[][][] currentLevelData;
    public static SoundManger SOUND_MANGER;
    private int currentSymbol = -1;

    public GameManager() {
        this.base = new Base();
        this.noOfSymbol = this.noOfSymbols[LevelCanvas.mCurrentLevel];
        this.symbol = new Symbol[this.noOfSymbol];
        this.currentLevelData = Data.level_data[LevelCanvas.mCurrentLevel];
        for (int i = 0; i < this.noOfSymbol; ++i) {
            this.symbol[i] = new Symbol(i + 1, i, this.currentLevelData[i], this);
        }
    }

    protected void paint(Graphics g) {
        this.base.paint(g);
        for (int i = 0; i < this.noOfSymbol; ++i) {
            if (this.noOfSymbol == this.currentSymbol) continue;
            this.symbol[i].paint(g);
        }
        if (this.currentSymbol != -1) {
            this.symbol[this.currentSymbol].paint(g);
        }
    }

    protected void pointerPressed(int x, int y) {
        for (int i = this.noOfSymbol - 1; i >= 0; --i) {
            this.currentSymbol = this.symbol[i].pointerPressed(x, y);
            if (this.currentSymbol <= -1) continue;
            return;
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.currentSymbol > -1) {
            if (!this.symbol[this.currentSymbol].isIsSetted()) {
                this.symbol[this.currentSymbol].pointerReleased(x, y);
            } else {
                this.symbol[this.currentSymbol].release();
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.currentSymbol > -1) {
            this.symbol[this.currentSymbol].pointerDragged(x, y);
        }
    }

    public void setSymbol(Symbol sym, int x, int y) {
        int j;
        int i;
        int tempX = x - this.base.getX();
        int tempY = y - this.base.getY();
        int column = tempX / 25;
        int row = tempY / 25;
        if (row >= 0 && column >= 0) {
            for (i = 0; i < sym.getRow(); ++i) {
                for (j = 0; j < sym.getColumn(); ++j) {
                    if (this.base.getData(row + i, column + j) != 0 || this.base.getData(row + i, column + j) == sym.getData(i, j)) continue;
                    return;
                }
            }
        }
        for (i = 0; i < sym.getRow(); ++i) {
            for (j = 0; j < sym.getColumn(); ++j) {
                if (sym.getData(i, j) == 0) continue;
                this.base.setData(i + row, j + column);
            }
        }
        SOUND_MANGER.playSound("fix");
        sym.setX(this.base.getPositiones(row, column).getX());
        sym.setY(this.base.getPositiones(row, column).getY());
        for (i = 0; i < this.base.data.length; ++i) {
            for (j = 0; j < this.base.data[0].length; ++j) {
                int k = this.base.data[i][j];
                if (k == 0) continue;
                return;
            }
        }
        MainCanvas.threadStatus = false;
    }

    public void releaseSymbol(Symbol sym, int x, int y) {
        for (int i = 0; i < this.symbol.length; ++i) {
            if (i == this.currentSymbol || x >= this.symbol[i].getX() + 25 || x + 25 <= this.symbol[i].getX() || y >= this.symbol[i].getY() + 25 || y + 25 <= this.symbol[i].getY()) continue;
            return;
        }
        int tempX = x - this.base.getX();
        int tempY = y - this.base.getY();
        int column = tempX / 25;
        int row = tempY / 25;
        if (sym.getRow() + row > this.base.data.length || sym.getColumn() + column > this.base.data[0].length) {
            return;
        }
        for (int i = 0; i < sym.getRow(); ++i) {
            for (int j = 0; j < sym.getColumn(); ++j) {
                if (sym.getData(i, j) == 0) continue;
                this.base.data[i + row][j + column] = Data.level_base_data[LevelCanvas.mCurrentLevel][i + row][j + column];
            }
        }
    }

    static {
        SOUND_MANGER = new SoundManger();
    }
}

