/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import javax.microedition.lcdui.Image;

public class RotateImage {
    public static Image rotateImage(Image image, float angle) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int[] imageData = new int[imageWidth * imageHeight];
        image.getRGB(imageData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int[] dstData = new int[imageWidth * imageHeight];
        double rads = (double)angle * Math.PI / 180.0;
        float sa = (float)Math.sin(rads);
        float ca = (float)Math.cos(rads);
        int isa = (int)(256.0f * sa);
        int ica = (int)(256.0f * ca);
        int my = -(imageHeight >> 1);
        for (int i = 0; i < imageHeight; ++i) {
            int wpos = i * imageWidth;
            int xacc = my * isa - (imageWidth >> 1) * ica + (imageWidth >> 1 << 8);
            int yacc = my * ica + (imageWidth >> 1) * isa + (imageHeight >> 1 << 8);
            for (int j = 0; j < imageWidth; ++j) {
                int imagex = xacc >> 8;
                int imagey = yacc >> 8;
                if (imagex < 0) {
                    imagex = 0;
                }
                if (imagey < 0) {
                    imagey = 0;
                }
                if (imagex > imageWidth - 1) {
                    imagex = imageWidth - 1;
                }
                if (imagey > imageHeight - 1) {
                    imagey = imageHeight - 1;
                }
                dstData[wpos++] = imageData[imagex + imagey * imageWidth];
                xacc += ica;
                yacc -= isa;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)imageWidth, (int)imageHeight, (boolean)true);
    }
}

