/*
 * Decompiled with CFR 0.152.
 */
package buzzcity;

import buzzcity.java.mobile.BCAdsClientBanner;
import buzzcity.java.mobile.Banner;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Buzzcity {
    private BCAdsClientBanner mClientBannerUp;
    private BCAdsClientBanner mClientBannerDown;
    private Banner mBannerUp;
    private Banner mBannerDown;
    public static Image mAdUpImage;
    public static Image mAdDownImage;
    private int mDrawUpX;
    private int mDrawUpY;
    private int mDrawDX;
    private int mDrawDY;
    private int mUPWidth;
    private int mUPHeight;
    private int mDWidth;
    private int mDHeight;
    private Thread mAdThread;
    private boolean mAdThreadStatus;
    private boolean mUpAdStatus;
    private boolean mDownAdStatus;
    private String BUZZ_CITY_APP_ID;
    private int mBuzID;
    public static MIDlet midlet;
    public static Callback mCallBack;
    private int mScreenWidth;
    private int mScreenHeight;
    private int mode;
    public static final int MODE_PORTRAIT = 1;
    public static final int MODE_LANDSCAPE = 2;

    public Buzzcity(MIDlet midlet, int screenWidth, int screenHeight, int mode) {
        Buzzcity.midlet = midlet;
        this.mode = mode;
        String fileName = midlet.getAppProperty("BUZZ_CITY_APP_ID");
        this.BUZZ_CITY_APP_ID = " " + fileName + ".txt";
        System.out.println("ad " + this.BUZZ_CITY_APP_ID);
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
        try {
            HttpConnection connection = (HttpConnection)Connector.open((String)this.BUZZ_CITY_APP_ID);
            InputStream mInputStream = connection.openInputStream();
            byte[] b = new byte[5];
            mInputStream.read(b);
            this.mBuzID = Integer.parseInt(new String(b).trim());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.mClientBannerUp = new BCAdsClientBanner(this.mBuzID, 4, midlet);
        this.mClientBannerDown = new BCAdsClientBanner(this.mBuzID, 4, midlet);
        this.mDrawDY = -4000;
        this.mDrawDX = -4000;
        this.mDrawUpY = -4000;
        this.mDrawUpX = -4000;
    }

    private void startAdThread() {
        this.mAdThread = new Thread(new Runnable(){

            public void run() {
                while (Buzzcity.this.mAdThreadStatus) {
                    if (Buzzcity.this.mUpAdStatus && Buzzcity.this.mClientBannerUp != null) {
                        try {
                            Buzzcity.this.mBannerUp = Buzzcity.this.mClientBannerUp.getBanner();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (Buzzcity.this.mBannerUp != null) {
                            try {
                                mAdUpImage = (Image)Buzzcity.this.mBannerUp.getItem();
                                mAdUpImage = Buzzcity.this.scaleImage(mAdUpImage, Buzzcity.this.mUPWidth, Buzzcity.this.mUPHeight);
                                if (Buzzcity.this.mode == 2) {
                                    mAdUpImage = Image.createImage((Image)mAdUpImage, (int)0, (int)0, (int)mAdUpImage.getWidth(), (int)mAdUpImage.getHeight(), (int)5);
                                    Buzzcity.this.mDrawUpX = Buzzcity.this.mScreenWidth - mAdUpImage.getWidth();
                                    Buzzcity.this.mDrawUpY = (Buzzcity.this.mScreenHeight - mAdUpImage.getHeight()) / 2;
                                }
                                mCallBack.callRepaint(Buzzcity.this.mDrawUpX, Buzzcity.this.mDrawUpY, mAdUpImage.getWidth(), mAdUpImage.getHeight());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (Buzzcity.this.mDownAdStatus && Buzzcity.this.mClientBannerDown != null) {
                        try {
                            Buzzcity.this.mBannerDown = Buzzcity.this.mClientBannerDown.getBanner();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (Buzzcity.this.mBannerDown != null) {
                            try {
                                mAdDownImage = (Image)Buzzcity.this.mBannerDown.getItem();
                                mAdDownImage = Buzzcity.this.scaleImage(mAdDownImage, Buzzcity.this.mDWidth, Buzzcity.this.mDHeight);
                                Buzzcity.this.mDrawDY = Buzzcity.this.mScreenHeight - mAdDownImage.getHeight();
                                if (Buzzcity.this.mode == 2) {
                                    mAdDownImage = Image.createImage((Image)mAdDownImage, (int)0, (int)0, (int)mAdDownImage.getWidth(), (int)mAdDownImage.getHeight(), (int)5);
                                    Buzzcity.this.mDrawDX = 0;
                                    Buzzcity.this.mDrawDY = (Buzzcity.this.mScreenHeight - mAdDownImage.getHeight()) / 2;
                                }
                                mCallBack.callRepaint(Buzzcity.this.mDrawDX, Buzzcity.this.mDrawDY, mAdDownImage.getWidth(), mAdDownImage.getHeight());
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.mAdThread.start();
    }

    public void unregisterAd() {
        this.mDrawUpY = -2000;
        this.mDrawUpX = -2000;
        this.mDrawDY = -2000;
        this.mDrawDX = -2000;
        this.mAdThreadStatus = false;
        this.mDownAdStatus = false;
        this.mUpAdStatus = false;
        mCallBack = null;
        try {
            this.mAdThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintAd(Graphics g) {
        if (mAdUpImage != null) {
            g.drawImage(mAdUpImage, this.mDrawUpX, this.mDrawUpY, 0);
        }
        if (mAdDownImage != null) {
            g.drawImage(mAdDownImage, this.mDrawDX, this.mDrawDY, 0);
        }
    }

    public void registerForUP(Callback callback) {
        if (!this.mUpAdStatus) {
            this.mUpAdStatus = true;
            mCallBack = callback;
            this.mDrawUpX = 0;
            this.mDrawUpY = 0;
            this.mUPWidth = this.mScreenWidth > this.mScreenHeight ? this.mScreenHeight : this.mScreenWidth;
            this.mUPHeight = this.mScreenHeight * 10 / 100;
            this.mAdThreadStatus = true;
            if (this.mAdThread != null) {
                if (!this.mAdThread.isAlive()) {
                    this.startAdThread();
                }
            } else {
                this.startAdThread();
            }
        }
    }

    public void registerForDown(Callback callback) {
        this.mDownAdStatus = true;
        mCallBack = callback;
        this.mDrawDX = 0;
        this.mDrawDY = 0;
        this.mDWidth = this.mScreenWidth > this.mScreenHeight ? this.mScreenHeight : this.mScreenWidth;
        this.mDHeight = this.mScreenHeight * 10 / 100;
        if (mAdDownImage != null) {
            this.mDrawDY = this.mode == 2 ? (this.mScreenHeight - mAdDownImage.getHeight()) / 2 : this.mScreenHeight - mAdDownImage.getHeight();
        }
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void registerForUP(int initialX, int initialY, int width, int height, Callback callback) {
        this.mUpAdStatus = true;
        mCallBack = callback;
        this.mDrawUpX = initialX;
        this.mDrawUpY = initialY;
        this.mUPWidth = width;
        this.mUPHeight = height;
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void registerForDown(int initialX, int initialY, int width, int height, Callback callback) {
        mCallBack = callback;
        this.mDrawDX = initialX;
        this.mDrawDY = initialY;
        this.mDWidth = width;
        this.mDHeight = height;
        this.mDownAdStatus = true;
        this.mAdThreadStatus = true;
        if (this.mAdThread != null) {
            if (!this.mAdThread.isAlive()) {
                this.startAdThread();
            }
        } else {
            this.startAdThread();
        }
    }

    public void adClicked(int x, int y) {
        if (mAdUpImage != null && x >= this.mDrawUpX && x <= this.mDrawUpX + mAdUpImage.getWidth() && y >= this.mDrawUpY && y <= this.mDrawUpY + mAdUpImage.getHeight()) {
            this.adUpClicked();
        }
        if (mAdDownImage != null && x >= this.mDrawDX && x <= this.mDrawDX + mAdDownImage.getWidth() && y >= this.mDrawDY && y <= this.mDrawDY + mAdDownImage.getHeight()) {
            this.adDownClicked();
        }
    }

    public void adUpClicked() {
        this.mClientBannerUp.clickAd();
    }

    public void adDownClicked() {
        this.mClientBannerDown.clickAd();
    }

    public void unregisterUp() {
        this.mDrawUpY = -2000;
        this.mDrawUpX = -2000;
        this.mUpAdStatus = false;
    }

    public void unregisterDown() {
        this.mDrawDY = -2000;
        this.mDrawDX = -2000;
        this.mDownAdStatus = false;
    }

    public Image scaleImage(Image src, int width, int height) {
        int scanline = src.getWidth();
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
        int[] buf2 = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = y * srch / height * scanline;
            for (int x = 0; x < width; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcw / width];
            }
        }
        Image img = Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
        return img;
    }

    public void drawAdUpRect(Graphics g) {
        int color = g.getColor();
        g.setColor(0xFF0000);
        g.drawRect(this.mDrawUpX, this.mDrawUpY, this.mUPWidth + 5, this.mUPHeight + 5);
        g.setColor(color);
    }

    public void drawAdDownRect(Graphics g) {
        int color = g.getColor();
        g.setColor(0xFF0000);
        g.drawRect(this.mDrawDX, this.mDrawDY, this.mDWidth, this.mDHeight);
        g.setColor(color);
    }

    public static interface Callback {
        public void callRepaint(int var1, int var2, int var3, int var4);
    }
}

