/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import com.spice.twozerofoureight.gamescreen.Config;
import com.spice.twozerofoureight.gamescreen.GameBoard;
import com.spice.twozerofoureight.gamescreen.GameOverScreen;
import com.spice.twozerofoureight.gamescreen.HomeScreen;
import com.spice.twozerofoureight.gamescreen.MainMidlet;
import com.spice.twozerofoureight.gamescreen.RMSData;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import vInAppAdEngine.VservAd;
import vInAppAdEngine.VservAdListener;
import vInAppAdEngine.VservManager;

public class GameScreen
extends GameCanvas
implements CommandListener,
VservAdListener {
    static MainMidlet midlet;
    private long lastTimeMoved = 0L;
    private static final int delayBetweenMoves = 100;
    private GameBoard board = new GameBoard();
    private int numMoves = 1;
    private Command backCommand;
    private VservManager vservManager;
    private VservAd vservAd;
    Image imageAd;
    String textAd;
    Alert alert;
    int startxpoint;
    int startyPoint;

    public GameScreen(int[] cellValues, MainMidlet midlet) {
        super(false);
        this.setFullScreenMode(true);
        GameScreen.midlet = midlet;
        if (cellValues == null) {
            this.board.initializeGame();
        } else {
            int i = 0;
            int row = 0;
            while (row < this.board.arr.length) {
                int column = 0;
                while (column < this.board.arr[row].length) {
                    this.board.arr[row][column].setNumber(cellValues[i]);
                    ++i;
                    ++column;
                }
                ++row;
            }
            this.board.score = (int)RMSData.getGridScore();
        }
        ++Config.gameCount;
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.initlize();
    }

    public void paint(Graphics g) {
        g.setColor(10324859);
        g.fillRect(0, 0, Config.DISPLAY_WIDTH, Config.DISPLAY_HEIGHT);
        this.board.drawGameBoard(g);
        if (this.imageAd != null) {
            g.drawImage(this.imageAd, (Config.DISPLAY_WIDTH - this.imageAd.getWidth()) / 2, 0, 0);
        }
        if (this.textAd != null) {
            g.drawString(this.textAd, (Config.DISPLAY_WIDTH - g.getFont().stringWidth(this.textAd)) / 2, 0, 0);
        }
        g.drawImage(Config.getImage("back.png"), Config.DISPLAY_WIDTH - Config.getImage("back.png").getWidth(), Config.DISPLAY_HEIGHT - Config.getImage("back.png").getHeight(), 0);
    }

    private boolean isWithInBoundsOfAdManager(int curX, int curY) {
        return curY <= 55;
    }

    protected void pointerPressed(int x, int y) {
        this.startxpoint = x;
        this.startyPoint = y;
    }

    protected void pointerReleased(int x, int y) {
        if (x > Config.DISPLAY_WIDTH - Config.getImage("back.png").getWidth() && x < Config.DISPLAY_WIDTH && y > Config.DISPLAY_HEIGHT - Config.getImage("back.png").getHeight()) {
            this.board.saveCurrentstate();
            RMSData.setGridScore(this.board.getScore());
            GameScreen.midlet.display.setCurrent((Displayable)new HomeScreen(midlet));
        }
        int xdiff = x - this.startxpoint;
        int ydiff = y - this.startyPoint;
        if (Math.abs(xdiff) > Math.abs(ydiff)) {
            if (xdiff > 0) {
                if (xdiff >= 30) {
                    this.moveBoardInDirection(1, 0);
                }
            } else if (xdiff <= -30) {
                this.moveBoardInDirection(-1, 0);
            }
        } else if (ydiff > 0) {
            if (ydiff >= 30) {
                this.moveBoardInDirection(0, 1);
            }
        } else if (ydiff <= -30) {
            this.moveBoardInDirection(0, -1);
        }
        if (x > 0 && x < Config.DISPLAY_WIDTH && y > 0 && y < 55 && this.vservAd.hasAction) {
            this.vservAd.handleAdAction();
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.moveBoardInDirection(0, -1);
                break;
            }
            case 6: {
                this.moveBoardInDirection(0, 1);
                break;
            }
            case 2: {
                this.moveBoardInDirection(-1, 0);
                break;
            }
            case 5: {
                this.moveBoardInDirection(1, 0);
            }
        }
    }

    private void moveBoardInDirection(int dx, int dy) {
        if (System.currentTimeMillis() - this.lastTimeMoved <= 100L) {
            return;
        }
        this.lastTimeMoved = System.currentTimeMillis();
        boolean isBoardShifted = false;
        if (dx < 0) {
            isBoardShifted = this.board.shiftGameBoardLeft();
        } else if (dx > 0) {
            isBoardShifted = this.board.shiftGameBoardRight();
        } else if (dy < 0) {
            isBoardShifted = this.board.shiftGameBoardUp();
        } else if (dy > 0) {
            isBoardShifted = this.board.shiftGameBoardDown();
        }
        if (isBoardShifted) {
            this.board.setNumberInEmptyField();
            ++this.numMoves;
            if (this.numMoves % 5 == 0) {
                this.requestNewAds();
            }
        }
        if (this.board.isGameOver()) {
            if (this.board.isGameWon()) {
                GameScreen.midlet.display.setCurrent((Displayable)new GameOverScreen(midlet, this.board.getScore(), true));
            } else {
                GameScreen.midlet.display.setCurrent((Displayable)new GameOverScreen(midlet, this.board.getScore(), false));
            }
        }
        this.repaint();
    }

    public void commandAction(Command c, Displayable d) {
        System.out.println("GameScreen.commandAction().................command type: " + c.getCommandType());
        if (c == this.backCommand) {
            this.board.saveCurrentstate();
            RMSData.setGridScore(this.board.getScore());
            GameScreen.midlet.display.setCurrent((Displayable)new HomeScreen(midlet));
        }
    }

    public void vservAdReceived(Object obj) {
        if (((VservAd)obj).getAdType().equals("image")) {
            this.imageAd = (Image)((VservAd)obj).getAd();
            System.out.println("image");
            this.repaint();
        } else if (((VservAd)obj).getAdType().equals("text")) {
            this.textAd = (String)((VservAd)obj).getAd();
            System.out.println("text");
            this.repaint();
        }
    }

    public void vservAdFailed(Object arg0) {
        System.out.println("not received");
    }

    private void initlize() {
        Hashtable<String, String> vservConfigTable = new Hashtable<String, String>();
        vservConfigTable.put("appId", "11c6d347");
        this.vservManager = new VservManager(midlet, vservConfigTable);
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    private void requestNewAds() {
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    protected void showNotify() {
        Tracker tracker = Tracker.getInstance(midlet, "UA-48934997-6");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    protected void hideNotify() {
        System.out.println("hide notify called");
        Tracker tracker = Tracker.getInstance(midlet, "UA-48934997-6");
        tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.board.getScore())));
    }
}

