/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.spice.twozerofoureight.gamescreen.GameBoard;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class NumberField {
    private int number;
    private static Font font = Font.getFont((int)0, (int)0, (int)16);
    private static Font font2 = Font.getFont((int)0, (int)0, (int)0);
    private static Font font3 = Font.getFont((int)0, (int)0, (int)0);
    private static Font font4 = Font.getFont((int)0, (int)0, (int)8);

    public boolean isEmpty() {
        return this.number == 0;
    }

    public void setEmpty() {
        this.number = 0;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    protected void paint(Graphics graphics, int xpos, int ypos) {
        int color = graphics.getColor();
        Font fnt = graphics.getFont();
        graphics.setFont(this.getFont());
        graphics.setColor(this.getColorCode());
        graphics.fillRoundRect(xpos, ypos, GameBoard.CELL_WIDTH, GameBoard.CELL_HEIGHT, GameBoard.CELL_WIDTH * 20 / 100, GameBoard.CELL_HEIGHT * 20 / 100);
        if (!this.isEmpty()) {
            graphics.setColor(0);
            graphics.drawString("" + this.number, xpos + (GameBoard.CELL_WIDTH - graphics.getFont().stringWidth("" + this.number)) / 2, ypos + (GameBoard.CELL_HEIGHT - graphics.getFont().getHeight()) / 2, 0);
        }
        graphics.setColor(color);
        graphics.setFont(fnt);
    }

    private int getColorCode() {
        switch (this.number) {
            case 0: {
                return 12364185;
            }
            case 2: {
                return 15656154;
            }
            case 4: {
                return 16507054;
            }
            case 8: 
            case 512: {
                return 15905145;
            }
            case 16: {
                return 16094563;
            }
            case 32: {
                return 16153695;
            }
            case 64: 
            case 1024: {
                return 16145979;
            }
            case 128: {
                return 15584353;
            }
            case 256: 
            case 2048: {
                return 15583312;
            }
        }
        return -1;
    }

    public boolean isNumber2048Achieved() {
        return this.number == 2048;
    }

    private Font getFont() {
        switch (this.number) {
            case 2: 
            case 4: 
            case 8: {
                return font;
            }
            case 16: 
            case 32: 
            case 64: {
                return font2;
            }
            case 128: 
            case 256: 
            case 512: {
                return font3;
            }
        }
        return font4;
    }
}

