/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jellyworld.animationlistener;

import in.spice.jellyworld.animationlistener.Animation;
import in.spice.jellyworld.animationlistener.AnimationCompleteCallBack;
import in.spice.jellyworld.common.JewelConstants;
import in.spice.jellyworld.objects.Coord;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BlastAnimtion
extends Animation {
    private int rowNum;
    private int colNum;
    private int paintCount;
    private int currentFrame;
    private AnimationCompleteCallBack callback;
    private boolean isAnimationComplete;
    private int totalCols;
    private int totalRows;
    private Coord[] arr;

    public BlastAnimtion(int rowNum, int colNum, int totalRows, int totalCols, AnimationCompleteCallBack callback) {
        this.rowNum = rowNum;
        this.colNum = colNum;
        this.callback = callback;
        this.totalRows = totalRows;
        this.totalCols = totalCols;
        this.calculateArray();
    }

    public Coord getAnimStartCoord() {
        return new Coord(this.colNum, this.rowNum);
    }

    private void calculateArray() {
        boolean isPreviousRow;
        Vector<Coord> vec = new Vector<Coord>();
        vec.addElement(new Coord(this.colNum, this.rowNum));
        boolean isNextRow = this.rowNum + 1 < this.totalRows;
        boolean isNextCol = this.colNum + 1 < this.totalCols;
        boolean isPreviousCol = this.colNum - 1 >= 0;
        boolean bl = isPreviousRow = this.rowNum - 1 >= 0;
        if (isPreviousRow && isPreviousCol) {
            vec.addElement(new Coord(this.colNum - 1, this.rowNum - 1));
        }
        if (isPreviousRow) {
            vec.addElement(new Coord(this.colNum, this.rowNum - 1));
        }
        if (isNextRow) {
            vec.addElement(new Coord(this.colNum, this.rowNum + 1));
        }
        if (isNextRow && isNextCol) {
            vec.addElement(new Coord(this.colNum + 1, this.rowNum + 1));
        }
        if (isPreviousCol) {
            vec.addElement(new Coord(this.colNum - 1, this.rowNum));
        }
        if (isNextCol) {
            vec.addElement(new Coord(this.colNum + 1, this.rowNum));
        }
        if (isPreviousCol && isNextRow) {
            vec.addElement(new Coord(this.colNum - 1, this.rowNum + 1));
        }
        if (isPreviousRow && isNextCol) {
            vec.addElement(new Coord(this.colNum + 1, this.rowNum - 1));
        }
        this.arr = new Coord[vec.size()];
        vec.copyInto(this.arr);
    }

    public void drawAnimation(Graphics graphics, int xoffset, int yoffset) {
        ++this.paintCount;
        if (this.paintCount % 3 == 0) {
            ++this.currentFrame;
            if (this.currentFrame >= JewelConstants.blastImages.length) {
                this.currentFrame = 0;
                this.callback.isAnimationComplete(this);
                this.isAnimationComplete = true;
            }
        }
        if (!this.isAnimationComplete) {
            int i = 0;
            while (i < this.arr.length) {
                Coord coord = this.arr[i];
                Image bitmap = JewelConstants.blastImages[this.currentFrame];
                graphics.drawImage(bitmap, xoffset + coord.x * JewelConstants.GEM_WIDTH, yoffset + coord.y * JewelConstants.GEM_HEIGHT, 0);
                ++i;
            }
        } else {
            this.callback.isAnimationComplete(this);
        }
    }

    public boolean isAnimationComplete() {
        return this.isAnimationComplete;
    }

    public Coord[] getCoord() {
        return this.arr;
    }
}

