/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import com.inode.utils.SSFunctions;
import javax.microedition.lcdui.Graphics;

public class MenuBonus {
    public GameEngine ge;
    public static final int STATE_NONE = 0;
    public static final int STATE_MENU_FIXED = 1;
    public static final int STATE_TRANSITION_IN = 2;
    public static final int STATE_TRANSITION_OUT = 3;
    public static final int STATE_SHOW_PICTURE_1 = 4;
    public static final int STATE_SHOW_PICTURE_2 = 5;
    public static final int STATE_SHOW_PICTURE_3 = 6;
    public int menuState = 1;
    public static final int STATE_ITEM_OFF = 1;
    public static final int STATE_ITEM_ON = 0;
    public static final int LEVEL_TOTAL_NUMBER = 8;
    public static final int BLOCK_SPACE_HORIZONTAL = 8;
    public static final int BLOCK_SPACE_VERTICAL = 8;
    public static final int BLOCK_SIZE = 26;
    public int menuFrames = 0;
    public long nowTime = System.currentTimeMillis();
    public int itemSelected = 0;
    public long[] itemAnimateTime = null;
    public int[] itemPosXfixed = null;
    public int[] itemPosYfixed = null;
    public int[] itemPosX = null;
    public int[] itemPosY = null;
    public int[] itemPosXfinal = null;
    public int[] itemPosYfinal = null;
    public boolean[] itemBounce = null;
    public static final int LEVEL_ICON_SIZE = 20;
    public StringBuffer levelInfo = new StringBuffer();

    public MenuBonus(GameEngine _ge) {
        this.ge = _ge;
        System.out.println("MenuBonus()");
        this.ge.auxString = "MenuBonus()";
        this.ge.countProgress();
        this.itemAnimateTime = new long[6];
        this.itemPosXfixed = new int[6];
        this.itemPosYfixed = new int[6];
        this.itemPosX = new int[6];
        this.itemPosY = new int[6];
        this.itemPosXfinal = new int[6];
        this.itemPosYfinal = new int[6];
        this.itemPosXfixed[5] = 0;
        this.itemPosYfixed[5] = 0;
        int itemsHeight = 180;
        for (int i = 0; i <= 4; ++i) {
            this.itemPosXfixed[i] = 20;
            this.itemPosYfixed[i] = 60 + i * 28;
        }
    }

    public void runTransitionIn() {
        int i;
        System.out.println("MenuBonus:runTransitionIn()");
        this.menuFrames = 0;
        this.menuState = 2;
        for (i = 0; i <= 5; ++i) {
            this.itemPosX[i] = this.itemPosXfixed[i];
            this.itemPosXfinal[i] = this.itemPosXfixed[i];
            this.itemPosY[i] = this.itemPosYfixed[i];
            this.itemPosYfinal[i] = this.itemPosYfixed[i];
        }
        this.itemPosY[5] = -31;
        for (i = 0; i <= 4; ++i) {
            this.itemPosY[i] = 320;
            this.itemPosYfinal[i] = this.itemPosYfixed[i];
        }
        this.ge.robot.speak(SSFunctions.replace(this.ge.lang[34], "%%CUBES%%", Integer.toString(this.ge.configPictocubes)));
    }

    public void runTransitionOut() {
        System.out.println("MenuBonus:runTransitionOut()");
        this.menuFrames = 0;
        this.menuState = 3;
        this.itemPosYfinal[5] = -31;
        for (int i = 0; i <= 4; ++i) {
            this.itemPosYfinal[i] = 320;
        }
    }

    public int setItemSelected(int _item) {
        if (_item < 0) {
            _item = 4;
        }
        if (_item >= 5) {
            _item = 0;
        }
        this.itemAnimateTime[this.itemSelected] = System.currentTimeMillis();
        this.itemAnimateTime[_item] = System.currentTimeMillis();
        this.itemSelected = _item;
        return _item;
    }

    public void paint(Graphics _g) {
        switch (this.menuState) {
            case 1: {
                this.paintFixed(_g);
                break;
            }
            case 2: 
            case 3: {
                this.paintTransition(_g);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.paintPicture(_g);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        _g.setColor(0xFF0000);
        this.nowTime = System.currentTimeMillis();
        int diffY = this.itemPosYfinal[5] - this.itemPosY[5];
        if (diffY != 0) {
            int step = Math.max(2, Math.abs(diffY / 3));
            if (Math.abs(diffY) < step) {
                this.itemPosY[5] = this.itemPosYfinal[5];
            } else if (diffY > 0) {
                this.itemPosY[5] = this.itemPosY[5] + step;
            } else if (diffY < 0) {
                this.itemPosY[5] = this.itemPosY[5] - step;
            }
        }
        this.ge.gc.resetClip(_g);
        _g.drawImage(this.ge.gc.resImages[25], this.itemPosX[5], this.itemPosY[5], 20);
        for (int i = 0; i < 5; ++i) {
            _g.setClip(0, 0, 240, 320);
            if (this.ge.configPictocubes >= this.ge.gbPictocubesCost[i]) {
                if (this.itemSelected == i) {
                    this.ge.gc.resAnimations[3].drawAnimation(_g, 0, this.nowTime - this.itemAnimateTime[i], this.itemPosX[i], this.itemPosY[i], false);
                    GameCanvas cfr_ignored_0 = this.ge.gc;
                    GameCanvas.resFonts[2].setCurrentPalette(1);
                } else {
                    this.ge.gc.resAnimations[3].drawAnimation(_g, 1, this.nowTime - this.itemAnimateTime[i], this.itemPosX[i], this.itemPosY[i], false);
                    GameCanvas cfr_ignored_1 = this.ge.gc;
                    GameCanvas.resFonts[2].setCurrentPalette(0);
                }
                this.ge.gc.resAnimations[8].drawAnimation(_g, 0, System.currentTimeMillis(), this.itemPosX[i] + 200 - 13, this.itemPosY[i] + 26 - this.ge.menu.itemTextOffsetY, true);
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.gbPictocubesCost[i] + "X").toCharArray(), this.itemPosX[i] + 200 - 30, this.itemPosY[i] + this.ge.menu.itemTextOffsetY, 24);
                GameCanvas cfr_ignored_3 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.gbMenuOptions[i].toCharArray(), this.itemPosX[i] + this.ge.menu.itemTextOffsetX, this.itemPosY[i] + this.ge.menu.itemTextOffsetY, 20);
                continue;
            }
            if (this.itemSelected == i) {
                this.ge.gc.resAnimations[3].drawAnimation(_g, 0, this.nowTime - this.itemAnimateTime[i], this.itemPosX[i], this.itemPosY[i], false);
                GameCanvas cfr_ignored_4 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(1);
            } else {
                this.ge.gc.resAnimations[3].drawAnimation(_g, 1, this.nowTime - this.itemAnimateTime[i], this.itemPosX[i], this.itemPosY[i], false);
                GameCanvas cfr_ignored_5 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
            }
            _g.drawImage(this.ge.gc.resImages[27], this.itemPosX[i] + this.ge.menu.itemTextOffsetX, this.itemPosY[i] + 13, 6);
            GameCanvas cfr_ignored_6 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[35].toCharArray(), this.itemPosX[i] + 20 + this.ge.menu.itemTextOffsetX, this.itemPosY[i] + this.ge.menu.itemTextOffsetY, 20);
            _g.setClip(0, 0, 240, 320);
            _g.drawImage(this.ge.gc.resImages[22], this.itemPosX[i] + 200 - 13, this.itemPosY[i] + 13, 3);
            GameCanvas cfr_ignored_7 = this.ge.gc;
            GameCanvas.resFonts[2].drawString(_g, (this.ge.gbPictocubesCost[i] + "X").toCharArray(), this.itemPosX[i] + 200 - 30, this.itemPosY[i] + this.ge.menu.itemTextOffsetY, 24);
        }
        if (this.menuState == 1) {
            // empty if block
        }
    }

    private void paintTransition(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        for (int i = 0; i < this.itemPosY.length; ++i) {
            diffX = this.itemPosXfinal[i] - this.itemPosX[i];
            if (diffX != 0) {
                isComplete = false;
                step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.ge.menu.speedX));
                if (Math.abs(diffX) < step) {
                    this.itemPosX[i] = this.itemPosXfinal[i];
                } else if (diffX > 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] + step;
                    if (this.itemPosX[i] < 240) {
                        isOnScreen = true;
                    }
                } else if (diffX < 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] - step;
                    if (this.itemPosX[i] > -200) {
                        isOnScreen = true;
                    }
                }
            }
            if ((diffY = this.itemPosYfinal[i] - this.itemPosY[i]) == 0) continue;
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[i] = this.itemPosYfinal[i];
                continue;
            }
            if (diffY > 0) {
                int n = i;
                this.itemPosY[n] = this.itemPosY[n] + step;
                if (this.itemPosY[i] >= 320) continue;
                isOnScreen = true;
                continue;
            }
            if (diffY >= 0) continue;
            int n = i;
            this.itemPosY[n] = this.itemPosY[n] - step;
            if (this.itemPosY[i] <= -26) continue;
            isOnScreen = true;
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 1;
        }
    }

    public void paintPicture(Graphics _g) {
        if (this.menuState == 4) {
            this.ge.gc.resLoad(28, 1);
            _g.drawImage(this.ge.gc.resImages[28], 0, 0, 20);
        } else if (this.menuState == 5) {
            this.ge.gc.resLoad(29, 1);
            _g.drawImage(this.ge.gc.resImages[29], 0, 0, 20);
        } else if (this.menuState == 6) {
            this.ge.gc.resLoad(30, 1);
            _g.drawImage(this.ge.gc.resImages[30], 0, 0, 20);
        }
    }
}

