/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import javax.microedition.lcdui.Graphics;

public class MenuProgress {
    public GameEngine ge;
    public static final int STATE_MENU_FIXED = 0;
    public static final int STATE_TRANSITION_IN = 1;
    public static final int STATE_TRANSITION_OUT = 2;
    public int menuState = 0;
    public static final int STATE_ITEM_OFF = 0;
    public static final int STATE_ITEM_ON = 1;
    public int menuFrames = 0;
    public long nowTime = System.currentTimeMillis();
    public long[] itemAnimateTime = null;
    public int[] itemPosXfixed = null;
    public int[] itemPosYfixed = null;
    public int[] itemPosX = null;
    public int[] itemPosY = null;
    public int[] itemPosXfinal = null;
    public int[] itemPosYfinal = null;
    public int textWidthFixed = 0;
    public int textHeightFixed = 0;
    public int textWidth = 0;
    public int textHeight = 0;
    public int textWidthFinal = 0;
    public int textHeightFinal = 0;
    public String textParagraph = null;

    public MenuProgress(GameEngine _ge) {
        this.ge = _ge;
        System.out.println("MenuProgress()");
        this.ge.auxString = "MenuProgress()";
        this.ge.countProgress();
        this.itemAnimateTime = new long[2];
        this.itemPosXfixed = new int[2];
        this.itemPosYfixed = new int[2];
        this.itemPosX = new int[2];
        this.itemPosY = new int[2];
        this.itemPosXfinal = new int[2];
        this.itemPosYfinal = new int[2];
        this.itemPosXfixed[0] = 20;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        this.itemPosYfixed[0] = 160 - 9 * GameCanvas.resFonts[1].getFontHeight();
        this.itemPosXfixed[1] = this.itemPosXfixed[0];
        this.itemPosYfixed[1] = this.itemPosYfixed[0] + this.textHeightFixed + 2;
    }

    public void runTransitionIn() {
        System.out.println("MenuProgress:runTransitionIn()");
        this.menuFrames = 0;
        this.menuState = 1;
        this.textWidth = 0;
        this.textWidthFinal = this.textWidthFixed;
        this.textHeight = 0;
        this.textHeightFinal = this.textHeightFixed;
        this.itemPosX[0] = 120;
        this.itemPosXfinal[0] = this.itemPosXfixed[0];
        this.itemPosY[0] = 160;
        this.itemPosYfinal[0] = this.itemPosYfixed[0];
        this.itemPosX[1] = this.itemPosXfixed[1];
        this.itemPosXfinal[1] = this.itemPosXfixed[1];
        this.itemPosY[1] = 320;
        this.itemPosYfinal[1] = this.itemPosYfixed[1];
    }

    public void runTransitionOut() {
        System.out.println("MenuProgress:runTransitionOut()");
        this.menuState = 2;
        this.textHeightFinal = 0;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        this.itemPosYfinal[0] = -20 * GameCanvas.resFonts[1].getFontHeight();
        this.itemPosXfinal[1] = 240;
        this.itemPosYfinal[1] = 320;
    }

    public void setText(String text) {
        this.textParagraph = text;
    }

    public void paint(Graphics _g) {
        switch (this.menuState) {
            case 0: {
                this.paintFixed(_g);
                break;
            }
            case 1: 
            case 2: {
                this.paintTransition(_g);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        this.ge.gc.resetClip(_g);
        this.nowTime = System.currentTimeMillis();
        this.ge.gc.paintBackground(_g);
        GameCanvas cfr_ignored_0 = this.ge.gc;
        int frameWidth = Math.min(20 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.menuFrames);
        GameCanvas cfr_ignored_1 = this.ge.gc;
        int frameHeight = Math.min(16 * GameCanvas.resFonts[1].getFontHeight(), 20 * this.menuFrames);
        int pixelX = 120;
        GameCanvas cfr_ignored_2 = this.ge.gc;
        int pixelY = (320 - frameHeight) / 2 - 2 * GameCanvas.resFonts[0].getFontHeight();
        this.ge.gc.paintItem(_g, this.itemPosX[0], this.itemPosY[0], frameWidth, frameHeight);
        if (this.menuState == 0) {
            if (this.menuFrames > 20) {
                GameCanvas cfr_ignored_3 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, this.ge.lang[87].toCharArray(), pixelX, pixelY, 17);
            }
            if (this.menuFrames > 25) {
                GameCanvas cfr_ignored_4 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[1].getFontHeight();
                GameCanvas cfr_ignored_5 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_6 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[88].toCharArray(), pixelX - frameWidth / 2 + 10, pixelY, 6);
                GameCanvas cfr_ignored_7 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_8 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (100 * (this.ge.configLevelsClassic + 4 * this.ge.configLevelsQuest + this.ge.gbMenuUnBlocked) / 155 + "% " + this.ge.lang[89]).toCharArray(), pixelX + frameWidth / 2 - 10, pixelY, 10);
            }
            if (this.menuFrames > 30) {
                GameCanvas cfr_ignored_9 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_10 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_11 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[90].toCharArray(), pixelX - frameWidth / 2 + 10, pixelY, 6);
                GameCanvas cfr_ignored_12 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_13 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, Integer.toString(this.ge.configTotalPoints).toCharArray(), pixelX + frameWidth / 2 - 10, pixelY, 10);
            }
            if (this.menuFrames > 35) {
                GameCanvas cfr_ignored_14 = this.ge.gc;
                _g.setClip(pixelX - frameWidth / 3, pixelY += 2 * GameCanvas.resFonts[2].getFontHeight(), 2 * frameWidth / 3, pixelY + 3);
                _g.setColor(15376436);
                _g.drawLine(pixelX - frameWidth / 3, pixelY, pixelX + frameWidth / 3, pixelY);
                _g.setColor(16442030);
                _g.drawLine(pixelX - frameWidth / 3, pixelY + 1, pixelX + frameWidth / 3, pixelY + 1);
            }
            if (this.menuFrames > 40) {
                GameCanvas cfr_ignored_15 = this.ge.gc;
                pixelY += 2 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_16 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_17 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[91].toCharArray(), pixelX, pixelY, 3);
            }
            if (this.menuFrames > 45) {
                GameCanvas cfr_ignored_18 = this.ge.gc;
                _g.setClip(pixelX - frameWidth / 3, pixelY += GameCanvas.resFonts[2].getFontHeight(), 2 * frameWidth / 3, pixelY + 3);
                _g.setColor(15376436);
                _g.drawLine(pixelX - frameWidth / 3, pixelY, pixelX + frameWidth / 3, pixelY);
                _g.setColor(16442030);
                _g.drawLine(pixelX - frameWidth / 3, pixelY + 1, pixelX + frameWidth / 3, pixelY + 1);
            }
            if (this.menuFrames > 50) {
                GameCanvas cfr_ignored_19 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_20 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_21 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[20].toCharArray(), pixelX - frameWidth / 2 + 10, pixelY, 6);
                GameCanvas cfr_ignored_22 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_23 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.configLevelsClassic + " / " + 90).toCharArray(), pixelX + frameWidth / 2 - 10, pixelY, 10);
            }
            if (this.menuFrames > 55) {
                GameCanvas cfr_ignored_24 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_25 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_26 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[22].toCharArray(), pixelX - frameWidth / 2 + 10, pixelY, 6);
                GameCanvas cfr_ignored_27 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_28 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (4 * this.ge.configLevelsQuest + " / " + 60).toCharArray(), pixelX + frameWidth / 2 - 10, pixelY, 10);
            }
            if (this.menuFrames > 60) {
                GameCanvas cfr_ignored_29 = this.ge.gc;
                _g.setClip(pixelX - frameWidth / 3, pixelY += 2 * GameCanvas.resFonts[2].getFontHeight(), 2 * frameWidth / 3, pixelY + 3);
                _g.setColor(15376436);
                _g.drawLine(pixelX - frameWidth / 3, pixelY, pixelX + frameWidth / 3, pixelY);
                _g.setColor(16442030);
                _g.drawLine(pixelX - frameWidth / 3, pixelY + 1, pixelX + frameWidth / 3, pixelY + 1);
            }
            if (this.menuFrames > 65) {
                GameCanvas cfr_ignored_30 = this.ge.gc;
                pixelY += 2 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_31 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(3);
                GameCanvas cfr_ignored_32 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[94].toCharArray(), pixelX, pixelY, 3);
            }
            if (this.menuFrames > 70) {
                GameCanvas cfr_ignored_33 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_34 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_35 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.configPictocubes + " " + this.ge.lang[92]).toCharArray(), pixelX, pixelY, 3);
            }
            if (this.menuFrames > 75) {
                GameCanvas cfr_ignored_36 = this.ge.gc;
                pixelY += 3 * GameCanvas.resFonts[2].getFontHeight() / 2;
                GameCanvas cfr_ignored_37 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_38 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, (this.ge.gbMenuUnBlocked + "/5 " + this.ge.lang[93]).toCharArray(), pixelX, pixelY, 3);
            }
        }
    }

    private void paintTransition(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        int diffW = 0;
        int diffH = 0;
        diffX = this.itemPosXfinal[0] - this.itemPosX[0];
        if (diffX != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.ge.menu.speedX));
            if (Math.abs(diffX) < step) {
                this.itemPosX[0] = this.itemPosXfinal[0];
            } else if (diffX > 0) {
                this.itemPosX[0] = this.itemPosX[0] + step;
                if (this.itemPosX[0] < 240) {
                    isOnScreen = true;
                }
            } else if (diffX < 0) {
                this.itemPosX[0] = this.itemPosX[0] - step;
                if (this.itemPosX[0] > -200) {
                    isOnScreen = true;
                }
            }
        }
        if ((diffY = this.itemPosYfinal[0] - this.itemPosY[0]) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[0] = this.itemPosYfinal[0];
            } else if (diffY > 0) {
                this.itemPosY[0] = this.itemPosY[0] + step;
                if (this.itemPosY[0] < 320) {
                    isOnScreen = true;
                }
            } else if (diffY < 0) {
                this.itemPosY[0] = this.itemPosY[0] - step;
                if (this.itemPosY[0] > -26) {
                    isOnScreen = true;
                }
            }
        }
        if ((diffW = this.textWidthFinal - this.textWidth) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffW / this.ge.menu.speedX));
            if (Math.abs(diffW) < step) {
                this.textWidth = this.textWidthFinal;
            } else if (diffW > 0) {
                this.textWidth += step;
            } else if (diffW < 0) {
                this.textWidth -= step;
            }
        }
        if ((diffH = this.textHeightFinal - this.textHeight) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffH / this.ge.menu.speedY));
            if (Math.abs(diffH) < step) {
                this.textHeight = this.textHeightFinal;
            } else if (diffH > 0) {
                this.textHeight += step;
            } else if (diffH < 0) {
                this.textHeight -= step;
            }
        }
        if ((diffY = this.itemPosYfinal[1] - this.itemPosY[1]) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[1] = this.itemPosYfinal[1];
            } else if (diffY > 0) {
                this.itemPosY[1] = this.itemPosY[1] + step;
                if (this.itemPosY[1] < 320) {
                    isOnScreen = true;
                }
            } else if (diffY < 0) {
                this.itemPosY[1] = this.itemPosY[1] - step;
                if (this.itemPosY[1] > -26) {
                    isOnScreen = true;
                }
            }
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 0;
        }
    }
}

