/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import com.inode.utils.SSFunctions;
import javax.microedition.lcdui.Graphics;

public class MenuQuest {
    public GameEngine ge;
    public static final int STATE_MENU_FIXED = 0;
    public static final int STATE_CHANGING_LEVEL = 1;
    public static final int STATE_TRANSITION_IN = 2;
    public static final int STATE_TRANSITION_OUT = 3;
    public int menuState = 0;
    public static final int STATE_ITEM_OFF = 1;
    public static final int STATE_ITEM_ON = 0;
    public static final int LEVEL_TOTAL_NUMBER = 8;
    public static final int BLOCK_SPACE_HORIZONTAL = 8;
    public static final int BLOCK_SPACE_VERTICAL = 8;
    public static final int BLOCK_SIZE = 26;
    public int menuFrames = 0;
    public long nowTime = System.currentTimeMillis();
    public int itemSelected = 0;
    public long[] itemAnimateTime = null;
    public int[] itemPosXfixed = null;
    public int[] itemPosYfixed = null;
    public int[] itemPosX = null;
    public int[] itemPosY = null;
    public int[] itemPosXfinal = null;
    public int[] itemPosYfinal = null;
    public boolean[] itemBounce = null;
    public int levelSelectedCol = 2;
    public int levelSelectedRow = 5;
    public int[] levelIcons = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    public static final int LEVEL_ICON_SIZE = 20;
    public StringBuffer levelInfo = new StringBuffer();

    public MenuQuest(GameEngine _ge) {
        this.ge = _ge;
        System.out.println("MenuQuest()");
        this.ge.auxString = "MenuQuest()";
        this.ge.loadGame("Game_Quest");
        this.itemAnimateTime = new long[7];
        this.itemPosXfixed = new int[7];
        this.itemPosYfixed = new int[7];
        this.itemPosX = new int[7];
        this.itemPosY = new int[7];
        this.itemPosXfinal = new int[7];
        this.itemPosYfinal = new int[7];
        this.itemPosXfixed[0] = 0;
        this.itemPosYfixed[0] = 0;
        this.itemPosXfixed[1] = 115;
        this.itemPosYfixed[1] = 79;
        this.itemPosXfixed[2] = 98;
        this.itemPosYfixed[2] = this.itemPosYfixed[1] + 26 + 8;
        this.itemPosXfixed[3] = 81;
        this.itemPosYfixed[3] = this.itemPosYfixed[2] + 26 + 8;
        this.itemPosXfixed[4] = 64;
        this.itemPosYfixed[4] = this.itemPosYfixed[3] + 26 + 8;
        this.itemPosXfixed[5] = 47;
        this.itemPosYfixed[5] = this.itemPosYfixed[4] + 26 + 8;
        this.itemPosXfixed[6] = 0;
        this.itemPosYfixed[6] = 260;
    }

    public void unload() {
        this.itemAnimateTime = null;
        this.itemPosXfixed = null;
        this.itemPosYfixed = null;
        this.itemPosX = null;
        this.itemPosY = null;
        this.itemPosXfinal = null;
        this.itemPosYfinal = null;
        this.itemBounce = null;
        this.levelIcons = null;
        this.levelInfo = null;
    }

    public void runTransitionIn() {
        System.out.println("MenuQuest:runTransitionIn()");
        this.menuFrames = 0;
        this.menuState = 2;
        for (int i = 0; i <= 6; ++i) {
            this.itemPosX[i] = this.itemPosXfixed[i];
            this.itemPosXfinal[i] = this.itemPosXfixed[i];
            this.itemPosY[i] = this.itemPosYfixed[i];
            this.itemPosYfinal[i] = this.itemPosYfixed[i];
        }
        this.itemPosY[0] = -31;
        this.itemPosY[1] = -520;
        this.itemPosY[2] = -390;
        this.itemPosY[3] = -260;
        this.itemPosY[4] = -130;
        this.itemPosY[5] = -26;
        this.itemPosY[6] = 320;
    }

    public void runTransitionOut() {
        System.out.println("MenuClassic:runTransitionOut()");
        this.menuFrames = 0;
        this.menuState = 3;
        this.itemPosYfinal[0] = -31;
        this.itemPosXfinal[1] = 240;
        this.itemPosXfinal[2] = -240;
        this.itemPosXfinal[3] = 240;
        this.itemPosXfinal[4] = -240;
        this.itemPosXfinal[5] = 240;
        this.itemPosYfinal[6] = 320;
    }

    public void setItemSelected(int _row, int _col) {
        int levelSelectedRowOld = this.levelSelectedRow;
        int levelSelectedColOld = this.levelSelectedCol;
        this.levelSelectedRow = Math.max(1, Math.min(_row, 5));
        if (this.levelSelectedRow < levelSelectedRowOld) {
            _col = Math.min(_col, this.levelSelectedRow - 1);
        }
        this.levelSelectedCol = Math.max(0, Math.min(_col, this.levelSelectedRow - 1));
        if (this.ge.gqLevelState[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)] == 0) {
            this.levelSelectedRow = levelSelectedRowOld;
            this.levelSelectedCol = levelSelectedColOld;
        }
        this.ge.gqLevelRow = this.levelSelectedRow;
        this.ge.gqLevelCol = this.levelSelectedCol;
    }

    public static int getIndex(int _row, int _col) {
        int index = 0;
        switch (_row) {
            case 0: 
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 3;
                break;
            }
            case 4: {
                index = 6;
                break;
            }
            case 5: {
                index = 10;
            }
        }
        return index + Math.min(_col, _row - 1);
    }

    public void paint(Graphics _g) {
        switch (this.menuState) {
            case 0: {
                this.paintFixed(_g);
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.paintTransition(_g);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        int i;
        this.ge.gc.resetClip(_g);
        _g.setColor(0xFF0000);
        boolean item_on_off = true;
        this.nowTime = System.currentTimeMillis();
        _g.drawImage(this.ge.gc.resImages[14], this.itemPosX[0], this.itemPosY[0], 20);
        for (i = 1; i <= 5; ++i) {
            block14: for (int j = 0; j < i; ++j) {
                this.ge.gc.resetClip(_g);
                switch (this.ge.gqLevelState[MenuQuest.getIndex(i, j)]) {
                    case 0: {
                        _g.drawImage(this.ge.gc.resImages[16], this.itemPosX[i] + j * 34, this.itemPosY[i], 20);
                        break;
                    }
                    case 1: {
                        _g.drawImage(this.ge.gc.resImages[17], this.itemPosX[i] + j * 34, this.itemPosY[i], 20);
                        break;
                    }
                    case 2: {
                        _g.drawImage(this.ge.gc.resImages[15], this.itemPosX[i] + j * 34, this.itemPosY[i], 20);
                        _g.setClip(this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2, 20, 20);
                        _g.drawImage(this.ge.gc.resImages[19], this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2 - 20 * this.levelIcons[MenuQuest.getIndex(i, j)], 20);
                    }
                }
                if (this.levelSelectedRow != i || this.levelSelectedCol != j) continue;
                this.ge.gc.resetClip(_g);
                _g.drawImage(this.ge.gc.resImages[18], this.itemPosX[i] + j * 34, this.itemPosY[i], 20);
                switch (this.ge.gqLevelState[MenuQuest.getIndex(i, j)]) {
                    case 1: {
                        _g.setClip(this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2, 20, 20);
                        _g.drawImage(this.ge.gc.resImages[19], this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2 - 300, 20);
                        continue block14;
                    }
                    case 2: {
                        _g.setClip(this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2, 20, 20);
                        _g.drawImage(this.ge.gc.resImages[19], this.itemPosX[i] + j * 34 + 2, this.itemPosY[i] + 2 - 20 * this.levelIcons[MenuQuest.getIndex(i, j)], 20);
                    }
                }
            }
        }
        this.ge.gc.paintImageTiled(_g, this.ge.gc.resImages[21], this.itemPosX[6], this.itemPosY[6], this.ge.robot.paperWfixed, this.ge.robot.paperHfixed);
        if (this.menuState == 0 || this.menuState == 1) {
            this.ge.gc.resetClip(_g);
            GameCanvas cfr_ignored_0 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[30].toCharArray(), 120, this.itemPosY[0] + this.ge.gc.resImages[14].getHeight() + 16, 17);
            for (i = 1; i <= 5; ++i) {
                GameCanvas cfr_ignored_1 = this.ge.gc;
                GameCanvas.resFonts[2].setCurrentPalette(0);
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas cfr_ignored_3 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, this.ge.lang[83].toCharArray(), GameCanvas.resFonts[2].getLineWidth(this.ge.lang[83].toCharArray()) / 2 + 8, this.itemPosY[i], 17);
                GameCanvas cfr_ignored_4 = this.ge.gc;
                GameCanvas cfr_ignored_5 = this.ge.gc;
                GameCanvas cfr_ignored_6 = this.ge.gc;
                GameCanvas.resFonts[1].drawString(_g, Integer.toString(6 - i).toCharArray(), GameCanvas.resFonts[2].getLineWidth(this.ge.lang[83].toCharArray()) / 2 + 8, 2 + this.itemPosY[i] + GameCanvas.resFonts[2].getFontHeight(), 17);
            }
            GameCanvas cfr_ignored_7 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[5].toCharArray(), 2, 318, 68, 120);
            GameCanvas cfr_ignored_8 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.ge.lang[28].toCharArray(), 238, 318, 72);
            this.levelInfo.setLength(0);
            this.levelInfo.append(this.ge.gqLevelDescription[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)]);
            GameCanvas cfr_ignored_9 = this.ge.gc;
            int posY = this.itemPosYfixed[6] + GameCanvas.resFonts[1].getFontHeight();
            _g.setClip(28, posY - 2, 26, 26);
            _g.drawImage(this.ge.gc.resImages[15], 28, posY - 2, 20);
            switch (this.ge.gqLevelState[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)]) {
                case 2: {
                    _g.setClip(30, posY, 20, 20);
                    _g.drawImage(this.ge.gc.resImages[19], 30, posY - 20 * this.levelIcons[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)], 20);
                    this.ge.gc.resetClip(_g);
                    GameCanvas cfr_ignored_10 = this.ge.gc;
                    GameCanvas cfr_ignored_11 = this.ge.gc;
                    this.ge.gc.resAnimations[8].drawAnimation(_g, 0, System.currentTimeMillis(), Math.max(60 + GameCanvas.resFonts[1].getLineWidth(this.levelInfo.toString().toCharArray()) + 10, 200), posY + 2 * GameCanvas.resFonts[1].getFontHeight(), true);
                    break;
                }
                case 1: {
                    _g.setClip(30, posY, 20, 20);
                    _g.drawImage(this.ge.gc.resImages[19], 30, posY - 300, 20);
                    this.ge.gc.resetClip(_g);
                    GameCanvas cfr_ignored_12 = this.ge.gc;
                    _g.drawImage(this.ge.gc.resImages[22], Math.max(60 + GameCanvas.resFonts[1].getLineWidth(this.levelInfo.toString().toCharArray()) + 10, 200), posY + 2, 17);
                }
            }
            GameCanvas cfr_ignored_13 = this.ge.gc;
            GameCanvas.resFonts[1].drawString(_g, this.levelInfo.toString().toCharArray(), 60, posY, 20);
            GameCanvas cfr_ignored_14 = this.ge.gc;
            GameCanvas cfr_ignored_15 = this.ge.gc;
            posY += GameCanvas.resFonts[1].getFontHeight() + GameCanvas.resFonts[2].getLineSpacing();
            GameCanvas cfr_ignored_16 = this.ge.gc;
            GameCanvas.resFonts[2].setCurrentPalette(1);
            GameCanvas cfr_ignored_17 = this.ge.gc;
            GameCanvas.resFonts[2].drawString(_g, (this.ge.lang[97] + ": ").toCharArray(), 60, posY, 20);
            GameCanvas cfr_ignored_18 = this.ge.gc;
            GameCanvas.resFonts[2].setCurrentPalette(0);
            if (this.ge.gqHighScoresTime[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)] > 0L) {
                GameCanvas cfr_ignored_19 = this.ge.gc;
                GameCanvas cfr_ignored_20 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, SSFunctions.getTimeText(this.ge.gqHighScoresTime[MenuQuest.getIndex(this.levelSelectedRow, this.levelSelectedCol)]).toString().toCharArray(), 60 + GameCanvas.resFonts[2].getLineWidth("BEST TIME - ".toCharArray()), posY, 20);
            } else {
                GameCanvas cfr_ignored_21 = this.ge.gc;
                GameCanvas cfr_ignored_22 = this.ge.gc;
                GameCanvas.resFonts[2].drawString(_g, "--:--".toCharArray(), 60 + GameCanvas.resFonts[2].getLineWidth("BEST TIME - ".toCharArray()), posY, 20);
            }
        }
    }

    private void paintTransition(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        for (int i = 0; i < this.itemPosY.length; ++i) {
            diffX = this.itemPosXfinal[i] - this.itemPosX[i];
            if (diffX != 0) {
                isComplete = false;
                step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.ge.menu.speedX));
                if (Math.abs(diffX) < step) {
                    this.itemPosX[i] = this.itemPosXfinal[i];
                } else if (diffX > 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] + step;
                    if (this.itemPosX[i] < 240) {
                        isOnScreen = true;
                    }
                } else if (diffX < 0) {
                    int n = i;
                    this.itemPosX[n] = this.itemPosX[n] - step;
                    if (this.itemPosX[i] > -200) {
                        isOnScreen = true;
                    }
                }
            }
            if ((diffY = this.itemPosYfinal[i] - this.itemPosY[i]) == 0) continue;
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[i] = this.itemPosYfinal[i];
                continue;
            }
            if (diffY > 0) {
                int n = i;
                this.itemPosY[n] = this.itemPosY[n] + step;
                if (this.itemPosY[i] >= 320) continue;
                isOnScreen = true;
                continue;
            }
            if (diffY >= 0) continue;
            int n = i;
            this.itemPosY[n] = this.itemPosY[n] - step;
            if (this.itemPosY[i] <= -26) continue;
            isOnScreen = true;
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 0;
        }
    }
}

