/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameEngine;
import com.inode.utils.SSFont;
import javax.microedition.lcdui.Graphics;

public class MenuManager {
    public GameEngine ge;
    public static final int STATE_NONE = 0;
    public static final int STATE_MENU_FIXED = 1;
    public static final int STATE_MENU_TRANSITION = 2;
    public int state = 1;
    public int[] stateList = null;
    public int stateIndexCurrent = 0;
    public int stateIndexAdd = 0;
    public static final int STATE_ITEM_OFF = 1;
    public static final int STATE_ITEM_ON = 0;
    public static final int TRANSITION_NONE = 0;
    public static final int TRANSITION_SLIDE_IN_FROM_UP = 100;
    public static final int TRANSITION_SLIDE_IN_FROM_DOWN = 200;
    public static final int TRANSITION_SLIDE_IN_FROM_LEFT = 300;
    public static final int TRANSITION_SLIDE_IN_FROM_RIGHT = 400;
    public static final int TRANSITION_SLIDE_OUT_TO_UP = 500;
    public static final int TRANSITION_SLIDE_OUT_TO_DOWN = 600;
    public static final int TRANSITION_SLIDE_OUT_TO_LEFT = 700;
    public static final int TRANSITION_SLIDE_OUT_TO_RIGHT = 800;
    public static final int TRANSITION_SLIDE_IN_ZIGZAG = 900;
    public static final int TRANSITION_SLIDE_OUT_ZIGZAG = 1000;
    public static final int CFG_SPEED_X = 0;
    public static final int CFG_SPEED_Y = 1;
    public static final int CFG_MIN_STEP = 2;
    public static final int CFG_ACCORDION = 3;
    public static final int CFG_BOUNCE = 4;
    public static final int CFG_BOUNCE_AMOUNT_X = 5;
    public static final int CFG_BOUNCE_AMOUNT_Y = 6;
    public int speedX = 3;
    public int speedY = 3;
    public int minStep = 2;
    public int accordion = 2;
    public boolean bounce = true;
    public int bounceAmountX = 20;
    public int bounceAmountY = 15;
    public long nowTime = System.currentTimeMillis();
    public boolean debug = false;
    public int menuFrames = 0;
    public int menuState = 0;
    public int menuTransition = 0;
    public int menuActive = 0;
    public String[][] menuOptions = null;
    public int[] itemSelected = null;
    public long[][] itemAnimateTime = null;
    public int[][] itemPosXfixed = null;
    public int[][] itemPosYfixed = null;
    public int[][] itemPosX = null;
    public int[][] itemPosY = null;
    public int[][] itemPosXfinal = null;
    public int[][] itemPosYfinal = null;
    public int itemTextOffsetX = 0;
    public int itemTextOffsetY = 0;
    public boolean[][] itemBounce = null;
    public int titleX = 0;
    public int titleY = 0;
    public int titleXfinal = 0;
    public int titleYfinal = 0;
    public int[][] itemImage = null;
    public SSFont menuFont = null;
    public int[] transitionsStack = null;
    public int transitionActive = 0;
    public int step = 1;
    public int diffX = 0;
    public int diffY = 0;

    public MenuManager(GameEngine _ge, int _menus) {
        this.ge = _ge;
        System.out.println("MenuManager()");
        this.ge.auxString = "MenuManager()";
        this.stateClear();
        this.menuOptions = new String[_menus][];
        this.itemSelected = new int[_menus];
        this.itemAnimateTime = new long[_menus][];
        this.itemImage = new int[_menus][];
        this.itemPosXfixed = new int[_menus][];
        this.itemPosYfixed = new int[_menus][];
        this.itemPosX = new int[_menus][];
        this.itemPosY = new int[_menus][];
        this.itemPosXfinal = new int[_menus][];
        this.itemPosYfinal = new int[_menus][];
        this.itemBounce = new boolean[_menus][];
        this.titleIn();
    }

    public void unload() {
        int i;
        for (i = 0; i < this.menuOptions.length; ++i) {
            for (int j = 0; j < this.menuOptions[i].length; ++j) {
                this.menuOptions[i][j] = null;
            }
        }
        this.menuOptions = null;
        this.itemSelected = null;
        for (i = 0; i < this.itemAnimateTime.length; ++i) {
            this.itemImage[i] = null;
            this.itemAnimateTime[i] = null;
            this.itemPosXfixed[i] = null;
            this.itemPosYfixed[i] = null;
            this.itemPosX[i] = null;
            this.itemPosY[i] = null;
            this.itemPosXfinal[i] = null;
            this.itemPosYfinal[i] = null;
            this.itemBounce[i] = null;
        }
        this.itemImage = null;
        this.itemAnimateTime = null;
        this.itemPosXfixed = null;
        this.itemPosYfixed = null;
        this.itemPosX = null;
        this.itemPosY = null;
        this.itemPosXfinal = null;
        this.itemPosYfinal = null;
        this.itemBounce = null;
        this.menuFont = null;
        this.transitionsStack = null;
    }

    private void stateClear() {
        this.stateList = new int[8];
        this.stateIndexCurrent = 0;
        this.stateIndexAdd = 0;
    }

    private void stateAdd(int _state) {
        this.stateIndexAdd = (this.stateIndexAdd + 1) % this.stateList.length;
        this.stateList[this.stateIndexAdd] = _state;
    }

    private int stateNext() {
        if (this.stateList[(this.stateIndexCurrent + 1) % this.stateList.length] == 0) {
            return 0;
        }
        this.stateIndexCurrent = (this.stateIndexCurrent + 1) % this.stateList.length;
        this.state = this.getState();
        return this.state;
    }

    private int getState() {
        return this.stateList[this.stateIndexCurrent];
    }

    public boolean setMenu(int _menuNumber, String[] _options) {
        if (_menuNumber < 0) {
            return false;
        }
        if (_menuNumber >= this.menuOptions.length) {
            return false;
        }
        this.menuOptions[_menuNumber] = _options;
        this.itemAnimateTime[_menuNumber] = new long[_options.length];
        this.itemImage[_menuNumber] = new int[_options.length];
        this.itemPosXfixed[_menuNumber] = new int[_options.length];
        this.itemPosYfixed[_menuNumber] = new int[_options.length];
        this.itemPosX[_menuNumber] = new int[_options.length];
        this.itemPosY[_menuNumber] = new int[_options.length];
        this.itemPosXfinal[_menuNumber] = new int[_options.length];
        this.itemPosYfinal[_menuNumber] = new int[_options.length];
        this.itemBounce[_menuNumber] = new boolean[_options.length];
        return true;
    }

    public void setConfig(int _variable, int _value) {
        switch (_variable) {
            case 0: {
                this.speedX = _value;
                break;
            }
            case 1: {
                this.speedY = _value;
                break;
            }
            case 2: {
                this.minStep = _value;
                break;
            }
            case 3: {
                this.accordion = _value;
                break;
            }
            case 5: {
                this.bounceAmountX = _value;
                break;
            }
            case 6: {
                this.bounceAmountY = _value;
            }
        }
    }

    public void setConfig(int _variable, boolean _value) {
        switch (_variable) {
            case 4: {
                this.bounce = _value;
            }
        }
    }

    public void setFont(SSFont _font) {
        this.menuFont = _font;
        this.itemTextOffsetX = 100;
        this.itemTextOffsetY = (26 - this.menuFont.getFontHeight()) / 2;
    }

    public void setFont(SSFont _font, int _textOffsetX, int _textOffsetY) {
        this.setFont(_font);
        this.itemTextOffsetX = _textOffsetX;
        this.itemTextOffsetY = _textOffsetY;
    }

    public void setItemPos(int _menuNumber) {
        int itemsHeight = this.menuOptions[_menuNumber].length * 36;
        for (int i = 0; i < this.menuOptions[_menuNumber].length; ++i) {
            this.itemPosXfixed[_menuNumber][i] = 20;
            this.itemPosYfixed[_menuNumber][i] = i * 182 / 5 + (320 - itemsHeight) / 2;
        }
    }

    public void setItemPos(int _menuNumber, int _posY, int _separationY) {
        int itemsHeight = this.menuOptions[_menuNumber].length * 36;
        for (int i = 0; i < this.menuOptions[_menuNumber].length; ++i) {
            this.itemPosXfixed[_menuNumber][i] = 20;
            this.itemPosYfixed[_menuNumber][i] = _posY + i * (26 + _separationY);
        }
    }

    public void setItemPos(int _menuNumber, int _itemNumber, int _posX, int _posY) {
        this.itemPosXfixed[_menuNumber][_itemNumber] = _posX;
        this.itemPosYfixed[_menuNumber][_itemNumber] = _posY;
    }

    public int setItemSelected(int _menuNumber, int _item) {
        if (_menuNumber < 0) {
            return -1;
        }
        if (_menuNumber >= this.menuOptions.length) {
            return -1;
        }
        if (_item < 0) {
            _item = this.menuOptions[_menuNumber].length - 1;
        }
        if (_item >= this.menuOptions[_menuNumber].length) {
            _item = 0;
        }
        this.itemAnimateTime[_menuNumber][this.itemSelected[_menuNumber]] = System.currentTimeMillis();
        this.itemAnimateTime[_menuNumber][_item] = System.currentTimeMillis();
        this.itemSelected[_menuNumber] = _item;
        return _item;
    }

    public void setItemString(int _menuNumber, int _item, String _option) {
        this.menuOptions[_menuNumber][_item] = _option;
    }

    public boolean setMenuActive(int _menuNumber) {
        if (_menuNumber < 0) {
            return false;
        }
        if (_menuNumber >= this.menuOptions.length) {
            return false;
        }
        this.menuActive = _menuNumber;
        return true;
    }

    public int getMenuState() {
        return this.menuState;
    }

    public int getMenuActive() {
        return this.menuActive;
    }

    public void titleOut() {
        this.titleX = 120;
        this.titleXfinal = 120;
        this.titleY = 16;
        this.titleYfinal = -36;
    }

    public void titleIn() {
        this.titleX = 120;
        this.titleXfinal = 120;
        this.titleY = -36;
        this.titleYfinal = 16;
    }

    public void makeTransition(int _menuNumber, int _transition) {
        this.stateAdd(_menuNumber + _transition);
    }

    public boolean runTransition() {
        int whatToDo = this.stateNext();
        if (whatToDo > 99) {
            this.menuFrames = 0;
            this.menuState = 2;
            this.menuActive = whatToDo % 100;
            this.menuTransition = whatToDo - this.menuActive;
        } else if (whatToDo > 0) {
            this.menuFrames = 0;
            this.menuState = 1;
            this.menuActive = whatToDo % 100;
            this.menuTransition = 0;
        } else {
            this.stateClear();
            this.menuFrames = 0;
            this.menuState = 1;
            this.menuTransition = 0;
            return false;
        }
        switch (this.menuTransition) {
            case 100: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = this.bounce;
                    this.itemPosY[this.menuActive][i] = -26;
                    this.itemPosYfinal[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
                    if (!this.itemBounce[this.menuActive][i]) continue;
                    int[] nArray = this.itemPosYfinal[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] + 260 / this.bounceAmountY;
                }
                break;
            }
            case 200: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = this.bounce;
                    this.itemPosY[this.menuActive][i] = 320;
                    this.itemPosYfinal[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
                    if (!this.itemBounce[this.menuActive][i]) continue;
                    int[] nArray = this.itemPosYfinal[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] - 260 / this.bounceAmountY;
                }
                break;
            }
            case 500: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = false;
                    this.itemPosY[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
                    this.itemPosYfinal[this.menuActive][i] = -26;
                }
                break;
            }
            case 600: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = false;
                    this.itemPosY[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
                    this.itemPosYfinal[this.menuActive][i] = 320;
                }
                break;
            }
            case 300: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = this.bounce;
                    this.itemPosX[this.menuActive][i] = -200;
                    this.itemPosXfinal[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    if (!this.itemBounce[this.menuActive][i]) continue;
                    int[] nArray = this.itemPosXfinal[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] + 400 / this.bounceAmountX;
                }
                break;
            }
            case 400: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = this.bounce;
                    this.itemPosX[this.menuActive][i] = 240;
                    this.itemPosXfinal[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    if (!this.itemBounce[this.menuActive][i]) continue;
                    int[] nArray = this.itemPosXfinal[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] - 400 / this.bounceAmountX;
                }
                break;
            }
            case 700: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = false;
                    this.itemPosX[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    this.itemPosXfinal[this.menuActive][i] = -200;
                }
                break;
            }
            case 800: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = false;
                    this.itemPosX[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    this.itemPosXfinal[this.menuActive][i] = 240;
                }
                break;
            }
            case 900: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = this.bounce;
                    this.itemPosXfinal[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    if (i % 2 == 0) {
                        this.itemPosX[this.menuActive][i] = -200;
                        if (!this.itemBounce[this.menuActive][i]) continue;
                        int[] nArray = this.itemPosXfinal[this.menuActive];
                        int n = i;
                        nArray[n] = nArray[n] + 400 / this.bounceAmountX;
                        continue;
                    }
                    this.itemPosX[this.menuActive][i] = 240;
                    if (!this.itemBounce[this.menuActive][i]) continue;
                    int[] nArray = this.itemPosXfinal[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] - 400 / this.bounceAmountX;
                }
                break;
            }
            case 1000: {
                for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
                    this.itemBounce[this.menuActive][i] = false;
                    this.itemPosX[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                    this.itemPosXfinal[this.menuActive][i] = i % 2 == 0 ? -200 : 240;
                }
                break;
            }
        }
        return true;
    }

    public void paint(Graphics _g) {
        block0 : switch (this.menuState) {
            case 1: {
                this.paintFixed(_g);
                break;
            }
            case 2: {
                switch (this.menuTransition) {
                    case 100: 
                    case 200: 
                    case 500: 
                    case 600: {
                        this.paintTransitionSlideVertical(_g);
                        break block0;
                    }
                    case 300: 
                    case 400: 
                    case 700: 
                    case 800: 
                    case 900: 
                    case 1000: {
                        this.paintTransitionSlideHorizontal(_g);
                    }
                }
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        _g.setColor(0xFF0000);
        int item_on_off = 1;
        this.nowTime = System.currentTimeMillis();
        int diffY = this.titleYfinal - this.titleY;
        if (diffY != 0) {
            int step = Math.max(2, Math.abs(diffY / 3));
            if (Math.abs(diffY) < step) {
                this.titleY = this.titleYfinal;
            } else if (diffY > 0) {
                this.titleY += step;
            } else if (diffY < 0) {
                this.titleY -= step;
            }
        }
        this.ge.gc.resetClip(_g);
        _g.drawImage(this.ge.gc.resImages[3], this.titleX, this.titleY, 17);
        for (int i = 0; i < this.menuOptions[this.menuActive].length; ++i) {
            _g.setClip(0, 0, 240, 320);
            item_on_off = 1;
            if (this.itemSelected[this.menuActive] == i) {
                item_on_off = 0;
            }
            this.ge.gc.resAnimations[3].drawAnimation(_g, item_on_off, this.nowTime - this.itemAnimateTime[this.menuActive][i], this.itemPosX[this.menuActive][i], this.itemPosY[this.menuActive][i], false);
            this.menuFont.drawString(_g, this.menuOptions[this.menuActive][i].toCharArray(), this.itemPosX[this.menuActive][i] + this.itemTextOffsetX, this.itemPosY[this.menuActive][i] + this.itemTextOffsetY, 20, 200 - this.itemTextOffsetX / 2);
        }
    }

    private void paintTransitionSlideVertical(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int i = 0;
        for (int ini = 0; ini < this.menuOptions[this.menuActive].length && this.menuFrames >= this.accordion * ini; ++ini) {
            switch (this.menuTransition) {
                case 100: 
                case 600: {
                    i = this.menuOptions[this.menuActive].length - 1 - ini;
                    break;
                }
                default: {
                    i = ini;
                }
            }
            this.diffY = this.itemPosYfinal[this.menuActive][i] - this.itemPosY[this.menuActive][i];
            if (this.diffY != 0) {
                isComplete = false;
                this.step = Math.max(this.minStep, Math.abs(this.diffY / this.speedY));
                this.itemPosX[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
                if (Math.abs(this.diffY) < this.step) {
                    this.itemPosY[this.menuActive][i] = this.itemPosYfinal[this.menuActive][i];
                    continue;
                }
                if (this.diffY > 0) {
                    int[] nArray = this.itemPosY[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] + this.step;
                    if (this.itemPosY[this.menuActive][i] >= 320) continue;
                    isOnScreen = true;
                    continue;
                }
                if (this.diffY >= 0) continue;
                int[] nArray = this.itemPosY[this.menuActive];
                int n = i;
                nArray[n] = nArray[n] - this.step;
                if (this.itemPosY[this.menuActive][i] <= -26) continue;
                isOnScreen = true;
                continue;
            }
            if (!this.itemBounce[this.menuActive][i]) continue;
            isComplete = false;
            this.itemBounce[this.menuActive][i] = false;
            this.itemPosYfinal[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.runTransition();
        }
    }

    private void paintTransitionSlideHorizontal(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int i = 0;
        for (int ini = 0; ini < this.menuOptions[this.menuActive].length && this.menuFrames >= this.accordion * ini; ++ini) {
            i = ini;
            this.diffX = this.itemPosXfinal[this.menuActive][i] - this.itemPosX[this.menuActive][i];
            if (this.diffX != 0) {
                isComplete = false;
                this.step = Math.max(this.minStep, Math.abs(this.diffX / this.speedX));
                this.itemPosY[this.menuActive][i] = this.itemPosYfixed[this.menuActive][i];
                if (Math.abs(this.diffX) < this.step) {
                    this.itemPosX[this.menuActive][i] = this.itemPosXfinal[this.menuActive][i];
                    continue;
                }
                if (this.diffX > 0) {
                    int[] nArray = this.itemPosX[this.menuActive];
                    int n = i;
                    nArray[n] = nArray[n] + this.step;
                    if (this.itemPosX[this.menuActive][i] >= 240) continue;
                    isOnScreen = true;
                    continue;
                }
                if (this.diffX >= 0) continue;
                int[] nArray = this.itemPosX[this.menuActive];
                int n = i;
                nArray[n] = nArray[n] - this.step;
                if (this.itemPosX[this.menuActive][i] <= -200) continue;
                isOnScreen = true;
                continue;
            }
            if (!this.itemBounce[this.menuActive][i]) continue;
            isComplete = false;
            this.itemBounce[this.menuActive][i] = false;
            this.itemPosXfinal[this.menuActive][i] = this.itemPosXfixed[this.menuActive][i];
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.runTransition();
        }
    }
}

