/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.graphics.Missile;
import com.rocktasticgames.diamonds.graphics.Particle;
import com.rocktasticgames.diamonds.graphics.Tile;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.main.MainCanvas;
import com.rocktasticgames.diamonds.models.GameModel;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.List;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.utils.XMath;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class GameView
extends View {
    private static final int MAX_TOUCHES = 2;
    public static final int TOUCH_ON_FACTOR = 12;
    public static final int TOUCH_OFF_FACTOR = 800;
    private GameModel model;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement pause;
    private AnimatedElement progbar_empty;
    private AnimatedElement scorecard;
    private AnimatedElement scorecard2;
    private Image progbar_full;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private int tile_row = -1;
    private int tile_col = -1;
    private String bg_image = "bg12";
    private AnimatedElement pause_bg;
    private AnimatedElement pause_play;
    private AnimatedElement pause_restart;
    private AnimatedElement pause_menu;
    private AnimatedElement pause_sound;
    private AnimatedElement pause_yes;
    private AnimatedElement pause_no;
    private AnimatedElement focus = null;
    private long pause_time;
    private boolean restart_confirm = false;
    private boolean quit_confirm = false;
    private AnimatedElement utility;
    private boolean utility_selected = false;
    private int utility_row;
    private int utility_col;
    private AnimatedElement overpanel;
    private boolean on_dialog = false;
    private boolean dialog_tapped = false;
    private boolean destroyed = false;
    private Image bgbmp;
    private int focus_i = -1;
    private int focus_j = -1;
    private boolean is_down = false;

    public GameView(MainActivity mainActivity, GameModel gameModel) {
        super(mainActivity);
        int n;
        this.activity = mainActivity;
        this.model = gameModel;
        this.bg_image = Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10];
        try {
            this.bgbmp = Image.createImage((String)("/" + this.bg_image + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10]);
        this.activity.getAssetLoader().load("parchmentmid", 1);
        this.activity.getAssetLoader().load("gridboundary_bot", 1);
        this.activity.getAssetLoader().load("gridboundary_top", 1);
        for (n = 0; n < Params.PARTICLE_CHAIN.length; ++n) {
            this.activity.getAssetLoader().load(Params.PARTICLE_CHAIN[n], 1);
        }
        for (n = 0; n < Params.PARTICLE_CRATE.length; ++n) {
            this.activity.getAssetLoader().load(Params.CRATE_INGAME[this.model.getLevel() / 40], 1);
        }
        for (n = 0; n < Params.PARTICLE_GEM.length; ++n) {
            this.activity.getAssetLoader().load(Params.PARTICLE_GEM[n], 1);
        }
        for (n = 0; n < Params.PARTICLE_ICE.length; ++n) {
            this.activity.getAssetLoader().load(Params.PARTICLE_ICE[n], 1);
        }
        for (n = 0; n < Params.PARTICLE_TILE.length; ++n) {
            this.activity.getAssetLoader().load(Params.PARTICLE_TILE[n], 1);
        }
        this.activity.getAssetLoader().load("effect_fadedcircle_white", 1);
        if (this.model.isMoveLimited()) {
            this.activity.getAssetLoader().load("timecounter_midmoves_full", 1);
        } else {
            this.activity.getAssetLoader().load("timecounter_midtime_full", 1);
        }
        if (this.model.getUtilityType() != -1) {
            this.activity.getAssetLoader().load(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][1], 1);
            this.activity.getAssetLoader().load(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][2], 1);
            this.activity.getAssetLoader().load(Params.UTILITY_INGAME[this.model.getUtilityType()], 1);
        }
        if (this.model.winCondition() == 4) {
            this.activity.getAssetLoader().load(Params.CRATE_INGAME[this.model.getLevel() / 40], 1);
        } else if (this.model.winCondition() == 2) {
            this.activity.getAssetLoader().load("basetile", 1);
        } else if (this.model.winCondition() == 3) {
            this.activity.getAssetLoader().load(Params.GEM_IMG[this.model.victoryGem1()], 1);
        }
        this.on_dialog = this.activity.checkMessage(this.model.getLevel() + 1, 2);
    }

    public boolean isDown() {
        return this.is_down;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.model.isPaused()) {
            if (this.restart_confirm || this.quit_confirm) {
                if (animatedElement == this.pause_yes && n == 5) {
                    return this.pause_no;
                }
                if (animatedElement != this.pause_no || n != 2) return animatedElement;
                return this.pause_yes;
            }
            if (animatedElement == null) {
                return this.pause_play;
            }
            if (n == 6) {
                if (animatedElement != this.pause_sound) return animatedElement;
                return this.pause_menu;
            }
            if (n == 1) {
                return this.pause_sound;
            }
            if (n == 5) {
                if (animatedElement == this.pause_play || animatedElement == this.pause_restart) {
                    return this.pause_restart;
                }
                if (animatedElement != this.pause_menu) return this.pause_sound;
                return this.pause_play;
            }
            if (n == 2) {
                if (animatedElement == this.pause_play || animatedElement == this.pause_menu) {
                    return this.pause_menu;
                }
                if (animatedElement != this.pause_restart) return this.pause_sound;
                return this.pause_play;
            }
        } else if (animatedElement == this.pause) {
            if (n == 2 && this.utility != null && this.model.getUtilityCharge() > 0.999f) {
                return this.utility;
            }
            if (n != 1) return this.pause;
            this.focus_i = 8;
            this.focus_j = 7;
        } else if (animatedElement == this.utility) {
            if (n == 5) {
                return this.pause;
            }
            if (n != 1) return this.utility;
            this.focus_i = 8;
            this.focus_j = 0;
        } else if (this.is_down) {
            if (n == 1) {
                this.model.swapVertical(this.focus_i, this.focus_i - 1, this.focus_j);
            } else if (n == 6) {
                this.model.swapVertical(this.focus_i, this.focus_i + 1, this.focus_j);
            } else if (n == 2) {
                this.model.swapHorizontal(this.focus_i, this.focus_j, this.focus_j - 1);
            } else if (n == 5) {
                this.model.swapHorizontal(this.focus_i, this.focus_j, this.focus_j + 1);
            }
            this.is_down = false;
            return animatedElement;
        }
        if (this.focus_i == -1) return animatedElement;
        Tile[][] tileArray = this.model.getGems();
        if (n == 1) {
            for (int i = this.focus_i - 1; i >= 0; --i) {
                for (int j = 0; j <= i; ++j) {
                    if (this.focus_j + j < tileArray[i].length && tileArray[i][this.focus_j + j] != null && !tileArray[i][this.focus_j + j].isLocked()) {
                        return this.setTarget(tileArray, i, this.focus_j + j);
                    }
                    if (this.focus_j - j < 0 || tileArray[i][this.focus_j - j] == null || tileArray[i][this.focus_j - j].isLocked()) continue;
                    return this.setTarget(tileArray, i, this.focus_j - j);
                }
            }
            return animatedElement;
        }
        if (n == 6) {
            for (int i = this.focus_i + 1; i < tileArray.length; ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (this.focus_j + j < tileArray[i].length && tileArray[i][this.focus_j + j] != null && !tileArray[i][this.focus_j + j].isLocked()) {
                        return this.setTarget(tileArray, i, this.focus_j + j);
                    }
                    if (this.focus_j - j < 0 || tileArray[i][this.focus_j - j] == null || tileArray[i][this.focus_j - j].isLocked()) continue;
                    return this.setTarget(tileArray, i, this.focus_j - j);
                }
            }
            if (this.utility == null || !(this.model.getUtilityCharge() > 0.999f)) return this.pause;
            return this.utility;
        }
        if (n == 5) {
            for (int i = this.focus_j + 1; i < tileArray[0].length; ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (this.focus_i + j < tileArray.length && tileArray[this.focus_i + j][i] != null && !tileArray[this.focus_i + j][i].isLocked()) {
                        return this.setTarget(tileArray, this.focus_i + j, i);
                    }
                    if (this.focus_i - j < 0 || tileArray[this.focus_i - j][i] == null || tileArray[this.focus_i - j][i].isLocked()) continue;
                    return this.setTarget(tileArray, this.focus_i - j, i);
                }
            }
            return animatedElement;
        }
        if (n != 2) return animatedElement;
        for (int i = this.focus_j - 1; i >= 0; --i) {
            for (int j = 0; j <= i; ++j) {
                if (this.focus_i + j < tileArray.length && tileArray[this.focus_i + j][i] != null && !tileArray[this.focus_i + j][i].isLocked()) {
                    return this.setTarget(tileArray, this.focus_i + j, i);
                }
                if (this.focus_i - j < 0 || tileArray[this.focus_i - j][i] == null || tileArray[this.focus_i - j][i].isLocked()) continue;
                return this.setTarget(tileArray, this.focus_i - j, i);
            }
        }
        return animatedElement;
    }

    public AnimatedElement setTarget(Tile[][] tileArray, int n, int n2) {
        Tile tile = tileArray[n][n2];
        this.focus_i = n;
        this.focus_j = n2;
        return new AnimatedElement(tile.getDestX() / (float)this.activity.getCanvas().getWidth() + 0.5f, tile.getDestY() / (float)this.activity.getCanvas().getHeight() + 0.5f, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight(), 0, 0L);
    }

    public void destroy() {
        int n;
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.model.destroy();
        if (this.pause != null) {
            this.pause.unload();
            this.progbar_empty.unload();
            this.scorecard.unload();
            if (this.scorecard2 != null) {
                this.scorecard2.unload();
            }
            if (this.utility != null) {
                this.utility.unload();
            }
        }
        if (this.pause_bg != null) {
            this.pause_bg.unload();
            this.pause_play.unload();
            this.pause_menu.unload();
            this.pause_restart.unload();
            this.pause_sound.unload();
            this.pause_yes.unload();
            this.pause_no.unload();
        }
        this.activity.getAssetLoader().unload("gridboundary_bot");
        this.activity.getAssetLoader().unload("gridboundary_top");
        this.activity.getAssetLoader().unload("parchmentmid");
        for (n = 0; n < Params.PARTICLE_CHAIN.length; ++n) {
            this.activity.getAssetLoader().unload(Params.PARTICLE_CHAIN[n]);
        }
        for (n = 0; n < Params.PARTICLE_CRATE.length; ++n) {
            this.activity.getAssetLoader().unload(Params.CRATE_INGAME[this.model.getLevel() / 40]);
        }
        for (n = 0; n < Params.PARTICLE_GEM.length; ++n) {
            this.activity.getAssetLoader().unload(Params.PARTICLE_GEM[n]);
        }
        for (n = 0; n < Params.PARTICLE_ICE.length; ++n) {
            this.activity.getAssetLoader().unload(Params.PARTICLE_ICE[n]);
        }
        for (n = 0; n < Params.PARTICLE_TILE.length; ++n) {
            this.activity.getAssetLoader().unload(Params.PARTICLE_TILE[n]);
        }
        if (this.model.isMoveLimited()) {
            this.activity.getAssetLoader().unload("timecounter_midmoves_full");
        } else {
            this.activity.getAssetLoader().unload("timecounter_midtime_full");
        }
        this.activity.getAssetLoader().unload("effect_fadedcircle_white");
        if (this.model.getUtilityType() != -1) {
            this.activity.getAssetLoader().unload(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][1]);
            this.activity.getAssetLoader().unload(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][2]);
            this.activity.getAssetLoader().unload(Params.UTILITY_INGAME[this.model.getUtilityType()]);
        }
        if (this.model.winCondition() == 4) {
            this.activity.getAssetLoader().unload(Params.CRATE_INGAME[this.model.getLevel() / 40]);
        } else if (this.model.winCondition() == 2) {
            this.activity.getAssetLoader().unload("basetile");
        } else if (this.model.winCondition() == 3) {
            this.activity.getAssetLoader().unload(Params.GEM_IMG[this.model.victoryGem1()]);
        }
        if (this.overpanel != null) {
            this.overpanel.unload();
        }
    }

    public boolean onBack() {
        if (this.on_dialog) {
            this.on_dialog = this.activity.progressDialog();
            return true;
        }
        this.model.togglePause();
        return true;
    }

    public void onHide() {
        for (int i = 0; i < this.touch_ptr.length; ++i) {
            this.swipe_active[i] = false;
            this.touch_ptr[i] = -1;
        }
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.pause = new AnimatedElement(this.activity.getAssetLoader(), "button_pause", 0.9305556f, 1.0f - 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
        this.progbar_empty = new AnimatedElement(this.activity.getAssetLoader(), "timecounter_empty", 0.5f, 1.0f - 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
        if (this.model.isDoubleMatchWin()) {
            this.scorecard = new AnimatedElement(this.activity.getAssetLoader(), "scorecard", 0.25f, 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
            this.scorecard2 = new AnimatedElement(this.activity.getAssetLoader(), "scorecard", 0.75f, 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
        } else {
            this.scorecard = new AnimatedElement(this.activity.getAssetLoader(), "scorecard_wide", 0.5f, 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
        }
        if (this.model.getUtilityType() != -1) {
            this.utility = new AnimatedElement(this.activity.getAssetLoader(), Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][0], 0.07f, 1.0f - 0.112847224f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, -100000L);
        }
        Tile[][] tileArray = this.model.getGems();
        int n = -1;
        int n2 = -1;
        int n3 = tileArray.length * 2;
        for (int i = 0; i < tileArray.length; ++i) {
            for (int j = 0; j < tileArray.length; ++j) {
                int n4 = Math.abs(i - tileArray.length / 2) + Math.abs(j - tileArray.length / 2);
                if (n4 >= n3 || tileArray[i][j] == null || tileArray[i][j].isLocked()) continue;
                n = i;
                n2 = j;
                n3 = n4;
            }
        }
        this.focus_i = n;
        this.focus_j = n2;
        this.activity.getCanvas().setFocus(new AnimatedElement(tileArray[n][n2].getDestX() / (float)graphicsContainer.getWidth() + 0.5f, tileArray[n][n2].getDestY() / (float)graphicsContainer.getHeight() + 0.5f, graphicsContainer.getWidth(), graphicsContainer.getHeight(), 0, 0L));
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        String string;
        List list;
        int n;
        int n2;
        graphicsContainer.setColor(-1);
        this.model.refresh(this.time);
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        int n3 = this.activity.getPaint();
        this.time = this.model.getTime();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (this.bgbmp != null) {
            graphicsContainer.save();
            graphicsContainer.translate(graphicsContainer.getWidth() / 2, graphicsContainer.getHeight() / 2);
            graphicsContainer.drawImage(this.bgbmp, 0, 0, 3);
            graphicsContainer.restore();
        }
        if (!this.loaded) {
            if (this.activity.getAssetLoader().isCurrent()) {
                this.loaded = true;
                this.model.start();
            } else {
                Image image = this.activity.getAssetLoader().get("gridboundary_top");
                Image image2 = this.activity.getAssetLoader().get("gridboundary_bot");
                if (image != null && image2 != null) {
                    graphicsContainer.save();
                    graphicsContainer.translate((float)(graphicsContainer.getWidth() / 2) / this.scale, (float)(graphicsContainer.getHeight() / 2) / this.scale - (float)image.getHeight() / MainCanvas.getGraphics().getVScale() * 0.3f);
                    graphicsContainer.drawImage(image, (float)(-image.getWidth() / 2), (float)(-image.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                    graphicsContainer.restore();
                    graphicsContainer.save();
                    graphicsContainer.translate((float)(graphicsContainer.getWidth() / 2) / this.scale, (float)(graphicsContainer.getHeight() / 2) / this.scale + (float)image2.getHeight() / MainCanvas.getGraphics().getVScale() * 0.25f);
                    graphicsContainer.drawImage(image2, (float)(-image2.getWidth() / 2), (float)(-image2.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                    graphicsContainer.restore();
                }
                if (this.bgbmp == null) {
                    graphicsContainer.setColor(-1);
                    graphicsContainer.drawPaint(n3);
                }
                graphicsContainer.restore();
                this.postInvalidateDelayed(50L);
                return;
            }
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.translate(graphicsContainer.getWidth() / 2, graphicsContainer.getHeight() / 2);
        graphicsContainer.scale(this.scale, this.scale);
        Tile[][] tileArray = this.model.getBases();
        Tile[][] tileArray2 = this.model.getTiles();
        Tile[][] tileArray3 = this.model.getGems();
        List list2 = this.model.getTileParticles();
        List list3 = this.model.getGemParticles();
        List list4 = this.model.getMissiles();
        Image image = this.activity.getAssetLoader().get("parchmentmid");
        if (image != null && this.model.getTopBound() != this.model.getBotBound()) {
            float f = 1.12f;
            graphicsContainer.drawImage(image, (float)(-image.getWidth() / 2), (this.model.getTopBound() + this.model.getBotBound()) * f / 2.0f - (float)image.getHeight() / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
        }
        for (n2 = 0; n2 < tileArray.length; ++n2) {
            for (n = 0; n < tileArray[n2].length; ++n) {
                if (tileArray[n2][n] == null || tileArray2[n2][n] != null && (tileArray2[n2][n] == null || tileArray2[n2][n].getTimeStamp() == 0L)) continue;
                tileArray[n2][n].render(graphicsContainer, n3, this.time, this.model);
            }
        }
        for (n2 = 0; n2 < tileArray.length; ++n2) {
            for (n = 0; n < tileArray[n2].length; ++n) {
                if (tileArray2[n2][n] == null) continue;
                tileArray2[n2][n].render(graphicsContainer, n3, this.time, this.model);
            }
        }
        for (n2 = 0; n2 < tileArray.length; ++n2) {
            for (n = 0; n < tileArray[n2].length; ++n) {
                if (tileArray3[n2][n] == null) continue;
                tileArray3[n2][n].render(graphicsContainer, n3, this.time, this.model);
            }
        }
        if (!this.model.isPaused()) {
            for (n2 = 0; n2 < this.model.getDeadGems().size(); ++n2) {
                Tile tile = (Tile)this.model.getDeadGems().get(n2);
                if (tile.getTimeStamp() > this.time) {
                    tile.render(graphicsContainer, n3);
                } else if (!tile.isIndirectMatch() && tile.getTimeStamp() + 300L > this.time) {
                    tile.renderScaled(graphicsContainer, n3, XMath.pow((float)(300L + tile.getTimeStamp() - this.time) / 300.0f, 1));
                } else if (tile.isIndirectMatch() && tile.getTimeStamp() + 600L > this.time) {
                    tile.renderScaled(graphicsContainer, n3, XMath.pow((float)(600L + tile.getTimeStamp() - this.time) / 600.0f, 1) * (1.0f + 3.0f * (float)(this.time - tile.getTimeStamp()) / 600.0f));
                } else {
                    ((Tile)this.model.getDeadGems().remove(n2)).unload();
                    --n2;
                }
                if (this.time <= tile.getTimeStamp() || this.time >= tile.getTimeStamp() + 500L || (list = this.activity.getAssetLoader().get("effect_fadedcircle_white")) == null) continue;
                float f = (float)(500L - 2L * Math.abs(this.time - tile.getTimeStamp() - 250L)) / 500.0f;
                graphicsContainer.save();
                graphicsContainer.translate(tile.getPosition(), tile.getHeight());
                graphicsContainer.scale(f, f);
                graphicsContainer.drawImage((Image)list, (float)(-list.getWidth() / 2), (float)(-list.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                graphicsContainer.restore();
            }
        }
        Image image3 = this.activity.getAssetLoader().get("gridboundary_top");
        Image image4 = this.activity.getAssetLoader().get("gridboundary_bot");
        if (image3 != null && image4 != null) {
            graphicsContainer.save();
            graphicsContainer.translate(0.0f, this.model.getTopBound() - (float)image3.getHeight() / MainCanvas.getGraphics().getVScale() * 0.32f);
            graphicsContainer.scale(1.0f, 1.0f);
            graphicsContainer.drawImage(image3, (float)(-image3.getWidth() / 2), (float)(-image3.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(0.0f, this.model.getBotBound() + (float)image4.getHeight() / MainCanvas.getGraphics().getVScale() * 0.3f);
            graphicsContainer.scale(1.0f, 1.0f);
            graphicsContainer.drawImage(image4, (float)(-image4.getWidth() / 2), (float)(-image4.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
            graphicsContainer.restore();
        }
        if (!this.model.isPaused()) {
            int n4;
            for (n4 = 0; n4 < list2.size(); ++n4) {
                if (((Particle)list2.get(n4)).isDoneAnimating(this.time)) {
                    ((Particle)list2.remove(n4)).unload();
                    --n4;
                    continue;
                }
                ((Particle)list2.get(n4)).render(graphicsContainer, n3, this.time);
            }
            for (n4 = 0; n4 < list4.size(); ++n4) {
                if (((Missile)list4.get(n4)).isDoneAnimating(this.time)) {
                    ((Missile)list4.remove(n4)).unload();
                    --n4;
                    continue;
                }
                ((Missile)list4.get(n4)).render(graphicsContainer, n3, this.time);
            }
            for (n4 = 0; n4 < list3.size(); ++n4) {
                if (((Particle)list3.get(n4)).isDoneAnimating(this.time)) {
                    ((Particle)list3.remove(n4)).unload();
                    --n4;
                    continue;
                }
                ((Particle)list3.get(n4)).render(graphicsContainer, n3, this.time);
            }
            if (this.model.getUtilityProgress() < 1.0f && this.utility != null) {
                Image image5 = this.activity.getAssetLoader().get(Params.UTILITY_INGAME[this.model.getUtilityType()]);
                graphicsContainer.save();
                graphicsContainer.translate(((float)this.utility_col - 3.5f) * 27.083334f, ((float)this.utility_row - 3.5f) * 27.083334f);
                if (this.model.getUtilityType() == 1) {
                    graphicsContainer.translate(13.541667f, 0.0f);
                    graphicsContainer.rotate((1.0f - this.model.getUtilityProgress()) * 45.0f);
                } else {
                    graphicsContainer.translate(0.0f, (this.model.getUtilityProgress() - 1.0f) * 3.0f * 27.083334f);
                }
                graphicsContainer.scale(1.0f, 1.0f);
                if (image5 != null) {
                    graphicsContainer.drawImage(image5, (float)(-image5.getWidth() / 2), (float)(-image5.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                }
                graphicsContainer.restore();
            }
            list = this.model.getPointMarkers();
            for (int i = 0; i < list.size(); ++i) {
                int[] nArray = (int[])list.get(i);
                if (this.time > (long)nArray[2] + 1000L) {
                    list.remove(i);
                    --i;
                    continue;
                }
                if (this.time <= (long)nArray[2]) continue;
                string = "" + nArray[3];
                this.activity.getTitan().setSize(16.0f);
                graphicsContainer.save();
                graphicsContainer.translate((float)(nArray[0] - this.activity.getTitan().measure(string) / 2), (long)(nArray[1] - 8) - 50L * (this.time - (long)nArray[2]) / 1000L);
                float f = 1.0f;
                if (this.time > (long)nArray[2] + 1000L - 300L) {
                    f = (float)((long)nArray[2] + 1000L - this.time) / 300.0f;
                } else if (this.time < (long)nArray[2] + 200L) {
                    f = (float)(this.time - (long)nArray[2]) / 200.0f;
                }
                this.activity.getTitan().renderString(graphicsContainer, n3, string);
                graphicsContainer.restore();
            }
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        boolean bl = false;
        for (int i = 0; i < this.pause_tapped.length; ++i) {
            boolean bl2 = this.pause_tapped[i];
            if (!bl2) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.pause.setColorFilter(Params.filter_dark);
        }
        this.pause.render(graphicsContainer, n3, this.time);
        if (bl) {
            this.pause.setColorFilter(null);
        }
        this.progbar_empty.render(graphicsContainer, n3, this.time);
        if (this.model.isMoveLimited()) {
            this.progbar_full = this.activity.getAssetLoader().get("timecounter_midmoves_full");
            if (this.progbar_full != null && this.progbar_empty.isLoaded()) {
                graphicsContainer.save();
                graphicsContainer.translate(this.progbar_empty.getX(this.time), this.progbar_empty.getY(this.time));
                graphicsContainer.drawImage(this.progbar_full, (float)(-this.progbar_full.getWidth() / 2), (float)(-this.progbar_full.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                graphicsContainer.restore();
                graphicsContainer.save();
                graphicsContainer.translate(this.progbar_empty.getX(this.time) - (float)(this.activity.getTitan().measure("" + this.model.movesRemaining()) / 2), this.progbar_empty.getY(this.time) - this.activity.getTitan().getSize(graphicsContainer) / 2.0f);
                this.activity.getTitan().renderString(graphicsContainer, n3, "" + this.model.movesRemaining());
                graphicsContainer.restore();
            }
        } else {
            this.progbar_full = this.activity.getAssetLoader().get("timecounter_midtime_full");
            if (this.progbar_full != null && this.progbar_empty.isLoaded()) {
                graphicsContainer.setColor(-65281);
                graphicsContainer.fillRect(this.progbar_empty.getX(this.time) - (float)(1 * this.progbar_full.getWidth()) * 0.43f, this.progbar_empty.getY(this.time) - (float)(1 * this.progbar_full.getHeight()) / MainCanvas.getGraphics().getVScale() * 0.3f, (float)(1 * this.progbar_full.getWidth()) * this.model.timeRemaining() * 0.86f, (float)(1 * this.progbar_full.getHeight()) / MainCanvas.getGraphics().getVScale() * 0.6f);
            }
        }
        graphicsContainer.setColor(-1);
        if (this.utility != null) {
            this.utility.render(graphicsContainer, n3, this.time);
            graphicsContainer.save();
            graphicsContainer.translate(this.utility.getX(this.time), this.utility.getY(this.time));
            graphicsContainer.scale(1.0f, 1.0f);
            float f = this.model.getUtilityCharge();
            Image image6 = this.activity.getAssetLoader().get(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][1]);
            string = this.activity.getAssetLoader().get(Params.UTILITY_IMGS[this.model.getUtilityType()][this.model.getLevel() / 40][2]);
            if (this.utility_selected) {
                if (string != null) {
                    graphicsContainer.drawImage((Image)string, (float)(-string.getWidth() / 2), (float)(-string.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                }
            } else if (f > 0.0f && f == 1.0f && string != null) {
                int n5 = (int)XMath.abs(255.0f - 0.42f * (float)this.time / 2.0f % 511.0f);
                graphicsContainer.drawImage((Image)string, (float)(-string.getWidth() / 2), (float)(-string.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
            }
            graphicsContainer.restore();
        }
        if (this.scorecard.isLoaded()) {
            this.activity.getTitan().setSize((float)this.scorecard.getHeight() * 0.4f);
            this.scorecard.render(graphicsContainer, n3, this.time);
            Image image7 = null;
            if (this.model.winCondition() == 4) {
                image7 = this.activity.getAssetLoader().get(Params.CRATE_INGAME[this.model.getLevel() / 40]);
            } else if (this.model.winCondition() == 2) {
                image7 = this.activity.getAssetLoader().get("basetile");
            } else if (this.model.winCondition() == 3) {
                image7 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem1()]);
            }
            graphicsContainer.save();
            graphicsContainer.translate(this.scorecard.getX(this.time), this.scorecard.getY(this.time));
            if (image7 != null) {
                graphicsContainer.save();
                graphicsContainer.translate((float)(-this.scorecard.getHeight()) * 1.3f + (float)(image7.getWidth() * 1 / 2), 0.0f);
                graphicsContainer.scale(1.0f, 1.0f);
                graphicsContainer.drawImage(image7, (float)(-image7.getWidth() / 2), (float)(-image7.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                graphicsContainer.restore();
                graphicsContainer.translate((float)this.scorecard.getHeight() * 1.15f, 0.0f);
            } else {
                graphicsContainer.translate(this.activity.getTitan().measure(this.model.gemProg1()) / 2, 0);
            }
            graphicsContainer.translate((float)(-this.activity.getTitan().measure(this.model.gemProg1())), -this.activity.getTitan().getSize(graphicsContainer) / 2.0f);
            this.activity.getTitan().renderString(graphicsContainer, n3, this.model.gemProg1());
            graphicsContainer.restore();
            if (this.scorecard2 != null) {
                this.scorecard2.render(graphicsContainer, n3, this.time);
                Image image8 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem2()]);
                graphicsContainer.save();
                graphicsContainer.translate(this.scorecard2.getX(this.time), this.scorecard2.getY(this.time));
                if (image8 != null) {
                    graphicsContainer.save();
                    graphicsContainer.translate((float)(-this.scorecard2.getHeight()) * 1.3f + (float)(image8.getWidth() * 1 / 2), 0.0f);
                    graphicsContainer.scale(1.0f, 1.0f);
                    graphicsContainer.drawImage(image8, (float)(-image8.getWidth() / 2), (float)(-image8.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n3);
                    graphicsContainer.restore();
                    graphicsContainer.translate((float)this.scorecard2.getHeight() * 1.15f, 0.0f);
                }
                graphicsContainer.translate((float)(-this.activity.getTitan().measure(this.model.gemProg2())), -this.activity.getTitan().getSize(graphicsContainer) / 2.0f);
                this.activity.getTitan().renderString(graphicsContainer, n3, this.model.gemProg2());
                graphicsContainer.restore();
            }
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        if (this.model.getWinTime(this.time) > 0L) {
            if (this.overpanel == null) {
                this.overpanel = new AnimatedElement(this.activity.getAssetLoader(), "congratulations_canvas", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 0, 1000L);
            }
            if (this.model.getWinTime(this.time) > 2002L && !this.overpanel.isAnimatingOut()) {
                this.overpanel.animateThrough(2002L);
            }
            if (this.overpanel.isLoaded() && this.overpanel.getAnimation() == 0) {
                this.overpanel.animate(6, this.model.getWinTime(this.time));
                this.activity.getSounds().playEffect("welldone");
            }
            this.overpanel.render(graphicsContainer, n3, this.model.getWinTime(this.time));
            if (this.overpanel.isLoaded()) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize(this.overpanel.getHeight() / 8);
                graphicsContainer.translate(this.overpanel.getX(this.model.getWinTime(this.time)) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_WELL_DONE[this.activity.getLanguage()]) / 2), this.overpanel.getY(this.model.getWinTime(this.time)) + (float)(this.overpanel.getHeight() * 3 / 14) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                graphicsContainer.setColor(-1);
                this.activity.getCartoon().renderString(graphicsContainer, n3, C2MValues.TEXT_WELL_DONE[this.activity.getLanguage()]);
                graphicsContainer.restore();
            }
        } else if (this.model.getLoseTime(this.time) > 0L) {
            if (this.overpanel == null) {
                this.overpanel = new AnimatedElement(this.activity.getAssetLoader(), "outofmoves_canvas", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 0, 1000L);
            }
            if (this.model.getLoseTime(this.time) > 2002L && !this.overpanel.isAnimatingOut()) {
                this.overpanel.animateThrough(2002L);
            }
            if (this.overpanel.isLoaded() && this.overpanel.getAnimation() == 0) {
                this.overpanel.animate(5, this.model.getLoseTime(this.time));
                this.activity.getSounds().playEffect("outofmoves");
            }
            this.overpanel.render(graphicsContainer, n3, this.model.getLoseTime(this.time));
            if (this.overpanel.isLoaded()) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize(this.overpanel.getHeight() / 8);
                graphicsContainer.setColor(-1);
                if (this.model.isMoveLimited()) {
                    graphicsContainer.translate(this.overpanel.getX(this.model.getLoseTime(this.time)) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_OUT_OF_MOVES[this.activity.getLanguage()]) / 2), this.overpanel.getY(this.model.getLoseTime(this.time)) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                    this.activity.getCartoon().renderString(graphicsContainer, n3, C2MValues.TEXT_OUT_OF_MOVES[this.activity.getLanguage()]);
                } else {
                    graphicsContainer.translate(this.overpanel.getX(this.model.getLoseTime(this.time)) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_OUT_OF_TIME[this.activity.getLanguage()]) / 2), this.overpanel.getY(this.model.getLoseTime(this.time)) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                    this.activity.getCartoon().renderString(graphicsContainer, n3, C2MValues.TEXT_OUT_OF_TIME[this.activity.getLanguage()]);
                }
                graphicsContainer.restore();
            }
        }
        if (this.on_dialog) {
            if (this.time > 0L) {
                this.model.pause();
                this.activity.renderDialog(graphicsContainer, n3, this.scale, this.dialog_tapped);
            }
        } else if (this.model.isPaused()) {
            if (this.pause_bg == null) {
                float f = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
                this.pause_time = System.currentTimeMillis();
                this.pause_bg = new AnimatedElement(this.activity.getAssetLoader(), "pause_canvas", 0.5f, 1.0f - 0.20833333f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_play = new AnimatedElement(this.activity.getAssetLoader(), "button_272_play", 0.5f, 1.0f - 0.15625f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_menu = new AnimatedElement(this.activity.getAssetLoader(), "button_backtohome", 0.3f, 1.0f - 0.15625f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_restart = new AnimatedElement(this.activity.getAssetLoader(), "button_restart", 0.7f, 1.0f - 0.15625f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity.getAssetLoader(), "toggleon_sound", 0.3f, 1.0f - 0.28645834f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L) : new AnimatedElement(this.activity.getAssetLoader(), "toggleoff_sound", 0.3f, 1.0f - 0.28645834f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_yes = new AnimatedElement(this.activity.getAssetLoader(), "button_ok", 0.38f, 1.0f - 0.15625f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 3, 0L);
                this.pause_no = new AnimatedElement(this.activity.getAssetLoader(), "button_no", 0.62f, 1.0f - 0.15625f * f, (float)graphicsContainer.getWidth() / this.scale, (float)graphicsContainer.getHeight() / this.scale, 4, 0L);
                this.activity.getCanvas().setFocus(this.pause_play);
            }
            long l = System.currentTimeMillis() - this.pause_time;
            this.pause_bg.render(graphicsContainer, n3, l);
            if (this.restart_confirm || this.quit_confirm) {
                if (this.focus == this.pause_yes) {
                    this.pause_yes.setColorFilter(Params.filter_dark);
                }
                this.pause_yes.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_yes) {
                    this.pause_yes.setColorFilter(null);
                }
                if (this.focus == this.pause_no) {
                    this.pause_no.setColorFilter(Params.filter_dark);
                }
                this.pause_no.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_no) {
                    this.pause_no.setColorFilter(null);
                }
                string = this.restart_confirm ? C2MValues.TEXT_RESTART_INGAME[this.activity.getLanguage()] : C2MValues.TEXT_QUIT_INGAME[this.activity.getLanguage()];
                if (this.pause_bg.isLoaded()) {
                    this.activity.getCartoon().setSize((float)this.pause_bg.getHeight() * 0.14f);
                    graphicsContainer.save();
                    graphicsContainer.setColor(-1);
                    graphicsContainer.translate(this.pause_bg.getX(l) - (float)(this.activity.getCartoon().measure(string) / 2), this.pause_bg.getY(l) - (float)(this.pause_bg.getHeight() / 5) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                    this.activity.getCartoon().renderString(graphicsContainer, n3, string);
                    graphicsContainer.restore();
                }
            } else {
                if (this.focus == this.pause_play) {
                    this.pause_play.setColorFilter(Params.filter_dark);
                }
                this.pause_play.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_play) {
                    this.pause_play.setColorFilter(null);
                }
                if (this.focus == this.pause_menu) {
                    this.pause_menu.setColorFilter(Params.filter_dark);
                }
                this.pause_menu.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_menu) {
                    this.pause_menu.setColorFilter(null);
                }
                if (this.focus == this.pause_restart) {
                    this.pause_restart.setColorFilter(Params.filter_dark);
                }
                this.pause_restart.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_restart) {
                    this.pause_restart.setColorFilter(null);
                }
                if (this.focus == this.pause_sound) {
                    this.pause_sound.setColorFilter(Params.filter_dark);
                }
                this.pause_sound.render(graphicsContainer, n3, l);
                if (this.focus == this.pause_sound) {
                    this.pause_sound.setColorFilter(null);
                }
            }
        } else if (this.pause_bg != null) {
            this.pause_bg.unload();
            this.pause_play.unload();
            this.pause_menu.unload();
            this.pause_restart.unload();
            this.pause_sound.unload();
            this.pause_yes.unload();
            this.pause_no.unload();
            this.pause_bg = null;
            this.pause_play = null;
            this.pause_menu = null;
            this.pause_restart = null;
            this.pause_sound = null;
            this.pause_yes = null;
            this.pause_no = null;
            this.activity.getCanvas().setFocus(this.pause);
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = this.model.getTime();
        this.postInvalidateDelayed(Math.max(5L, 20L - this.time + this.last_time));
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
    }

    public void lsk() {
        if (this.model.getUtilityCharge() == 1.0f) {
            this.utility_selected = !this.utility_selected;
        }
    }

    public void rsk() {
        this.model.pause();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.model == null) {
            return false;
        }
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        boolean bl = false;
        int n = 0;
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        this.on_dialog = false;
                        this.model.start();
                    }
                    this.dialog_tapped = false;
                } else if (this.utility != null && this.focus == this.utility) {
                    if (this.model.getUtilityCharge() == 1.0f) {
                        this.utility_selected = !this.utility_selected;
                    }
                    this.focus = null;
                } else if (this.pause_play != null && this.focus == this.pause_play) {
                    this.model.start();
                    this.focus = null;
                } else if (this.pause_menu != null && this.focus == this.pause_menu) {
                    this.quit_confirm = true;
                    this.pause_yes.animate(3, System.currentTimeMillis() - this.pause_time);
                    this.pause_no.animate(4, System.currentTimeMillis() - this.pause_time);
                    this.activity.getCanvas().setFocus(this.pause_no);
                    this.focus = null;
                } else if (this.pause_restart != null && this.focus == this.pause_restart) {
                    this.restart_confirm = true;
                    this.pause_yes.animate(3, System.currentTimeMillis() - this.pause_time);
                    this.pause_no.animate(4, System.currentTimeMillis() - this.pause_time);
                    this.activity.getCanvas().setFocus(this.pause_no);
                    this.focus = null;
                } else if (this.pause_yes != null && this.focus == this.pause_yes) {
                    if (this.quit_confirm) {
                        this.activity.startMap(this.model.getLevel() / 70);
                    } else if (this.restart_confirm) {
                        this.activity.startPregame(this.model.getLevel());
                    }
                    this.focus = null;
                } else if (this.pause_no != null && this.focus == this.pause_no) {
                    this.quit_confirm = false;
                    this.restart_confirm = false;
                    this.focus = null;
                } else if (this.pause_sound != null && this.focus == this.pause_sound) {
                    boolean bl2 = this.activity.getSharedPref().getBoolean("sound_on", true);
                    this.activity.getPrefEditor().putBoolean("sound_on", !bl2);
                    this.activity.getPrefEditor().putBoolean("music_on", !bl2);
                    this.activity.getPrefEditor().commit();
                    if (bl2) {
                        this.pause_sound.setPNG("toggleoff_sound");
                        this.activity.getMusic().stopMusic();
                    } else {
                        this.pause_sound.setPNG("toggleon_sound");
                        this.activity.getMusic().startMusic();
                    }
                    this.focus = null;
                } else if (this.pause_tapped[0]) {
                    this.model.togglePause();
                    this.pause_tapped[n] = false;
                } else if (this.swipe_active[n]) {
                    if (XMath.abs(f - this.mousex[n]) + XMath.abs(f2 - this.mousey[n]) > (float)(this.activity.getCanvas().getWidth() / 800)) {
                        if (XMath.abs(f - this.mousex[n]) > XMath.abs(f2 - this.mousey[n])) {
                            if (f > this.mousex[n]) {
                                this.model.swapHorizontal(this.tile_row, this.tile_col, this.tile_col + 1);
                            } else {
                                this.model.swapHorizontal(this.tile_row, this.tile_col, this.tile_col - 1);
                            }
                        } else if (f2 > this.mousey[n]) {
                            this.model.swapVertical(this.tile_row, this.tile_row + 1, this.tile_col);
                        } else {
                            this.model.swapVertical(this.tile_row, this.tile_row - 1, this.tile_col);
                        }
                    }
                    this.is_down = true;
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                this.tile_row = -1;
                this.tile_col = -1;
                if (this.on_dialog) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.model.isPaused()) {
                    if (this.restart_confirm || this.quit_confirm) {
                        if (this.pause_yes != null && this.pause_yes.isLoaded() && this.pause_yes.inRange(f / this.scale, f2 / this.scale)) {
                            this.focus = this.pause_yes;
                            this.activity.getMusic().playEffect("standard_click");
                        } else if (this.pause_no != null && this.pause_no.isLoaded() && this.pause_no.inRange(f / this.scale, f2 / this.scale)) {
                            this.focus = this.pause_no;
                            this.activity.getMusic().playEffect("standard_click");
                        }
                    } else if (this.pause_play != null && this.pause_play.isLoaded() && this.pause_play.inRange(f / this.scale, f2 / this.scale)) {
                        this.focus = this.pause_play;
                        this.activity.getMusic().playEffect("standard_click");
                    } else if (this.pause_menu != null && this.pause_menu.isLoaded() && this.pause_menu.inRange(f / this.scale, f2 / this.scale)) {
                        this.focus = this.pause_menu;
                        this.activity.getMusic().playEffect("standard_click");
                    } else if (this.pause_restart != null && this.pause_restart.isLoaded() && this.pause_restart.inRange(f / this.scale, f2 / this.scale)) {
                        this.focus = this.pause_restart;
                        this.activity.getMusic().playEffect("standard_click");
                    } else if (this.pause_sound != null && this.pause_sound.isLoaded() && this.pause_sound.inRange(f / this.scale, f2 / this.scale)) {
                        this.focus = this.pause_sound;
                        this.activity.getMusic().playEffect("standard_click");
                    }
                } else if (this.pause.isLoaded() && this.pause.inRange(f / this.scale, f2 / this.scale)) {
                    this.pause_tapped[n] = true;
                    this.activity.getMusic().playEffect("standard_click");
                } else if (!this.model.isPaused()) {
                    block5: for (int i = 0; i < this.model.getGems().length; ++i) {
                        for (int j = 0; j < this.model.getGems()[i].length; ++j) {
                            if (this.model.getGems()[i][j] == null || !this.model.getGems()[i][j].inRange((f - (float)(this.activity.getCanvas().getWidth() / 2)) / this.scale, (f2 - (float)(this.activity.getCanvas().getHeight() / 2)) / this.scale)) continue;
                            this.tile_row = i;
                            this.tile_col = j;
                            continue block5;
                        }
                    }
                    if (this.tile_row >= 0) {
                        if (this.utility_selected) {
                            if (this.model.activateUtility(this.tile_row, this.tile_col)) {
                                this.utility_row = this.tile_row;
                                this.utility_col = this.tile_col;
                                this.utility_selected = false;
                            }
                        } else {
                            this.swipe_time = this.last_time;
                            this.swipe_active[n] = true;
                            this.mousex[n] = f;
                            this.mousey[n] = f2;
                        }
                    } else if (this.model.getUtilityCharge() == 1.0f && this.utility.inRange(f / this.scale, f2 / this.scale)) {
                        this.focus = this.utility;
                    }
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.utility != null && this.focus == this.utility && !this.utility.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_play != null && this.focus == this.pause_play && !this.pause_play.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_menu != null && this.focus == this.pause_menu && !this.pause_menu.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_restart != null && this.focus == this.pause_restart && !this.pause_restart.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_sound != null && this.focus == this.pause_sound && !this.pause_sound.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_yes != null && this.focus == this.pause_yes && !this.pause_yes.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_no != null && this.focus == this.pause_no && !this.pause_no.inRange(f / this.scale, f2 / this.scale)) {
                    this.focus = null;
                } else if (this.pause_tapped[n] && !this.pause.inRange(f / this.scale, f2 / this.scale)) {
                    this.pause_tapped[n] = false;
                } else if (this.swipe_active[n] && XMath.abs(f - this.mousex[n]) + XMath.abs(f2 - this.mousey[n]) > (float)(this.activity.getCanvas().getWidth() / 12)) {
                    if (XMath.abs(f - this.mousex[n]) > XMath.abs(f2 - this.mousey[n])) {
                        if (f > this.mousex[n]) {
                            this.model.swapHorizontal(this.tile_row, this.tile_col, this.tile_col + 1);
                        } else {
                            this.model.swapHorizontal(this.tile_row, this.tile_col, this.tile_col - 1);
                        }
                    } else if (f2 > this.mousey[n]) {
                        this.model.swapVertical(this.tile_row, this.tile_row + 1, this.tile_col);
                    } else {
                        this.model.swapVertical(this.tile_row, this.tile_row - 1, this.tile_col);
                    }
                    this.swipe_active[n] = false;
                }
                return true;
            }
        }
        return true;
    }
}

