/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Dot {
    public int _iActualColor = 0;
    public static final int _COLOR_RED = 0;
    public static final int _COLOR_YELLOW = 1;
    public static final int _COLOR_GREEN = 2;
    public static final int _COLOR_BLUE = 3;
    public static final int _TOTAL_COLOR = 4;
    private boolean _bMove = false;
    private Rectangle _dotRect;
    private Sprite _dot = Resources.resSprs[1];
    int _iTmpNumber = 0;
    private int _iPositionX = 0;
    private int _iPositionY = 0;
    private int _iSteps = 64;
    private int _iActualStep = 0;
    private int _iShiftY = 0;
    private int _iOffsetY = 0;
    private int _iFinalY = 0;

    public Dot(int _x, int _y, int _finalY) {
        this._iPositionX = _x - (this._dot.getWidth() >> 1);
        this._iPositionY = _y;
        this._iFinalY = _finalY + (this._dot.getWidth() << 1);
        this.init();
        this.calculateVar();
    }

    private void init() {
        this._dot = Resources.resSprs[1];
        this._dotRect = new Rectangle(this._iPositionX, this._iPositionY, this._dot.getWidth(), this._dot.getHeight());
    }

    private void calculateVar() {
        this._iShiftY = (Math.abs(this._iPositionY) + this._iFinalY) / this._iSteps;
        this._iOffsetY = (Math.abs(this._iPositionY) + this._iFinalY) % this._iSteps;
    }

    public void start() {
        this.reset();
    }

    public void reset() {
        this._iTmpNumber = Math.abs(RandomNum.getRandomInt(100, 0));
        this._iActualColor = this._iTmpNumber < 20 ? 0 : (this._iTmpNumber < 40 ? 1 : (this._iTmpNumber < 60 ? 2 : (this._iTmpNumber < 80 ? 3 : Math.abs(RandomNum.getRandomInt(3, 0)))));
        this._dotRect.x = this._iPositionX;
        this._dotRect.y = this._iPositionY;
        this._iActualStep = 0;
    }

    public void update() {
        this.updatePosition();
    }

    private void updatePosition() {
        if (this._iActualStep < this._iSteps) {
            this._dotRect.y += this._iShiftY;
            ++this._iActualStep;
        } else if (this._iOffsetY > 0) {
            this._dotRect.y += this._iOffsetY;
        }
    }

    public void paint(Graphics g) {
        this._dot.setPosition(this._dotRect.x, this._dotRect.y);
        this._dot.setFrame(this.getSpriteFrame());
        this._dot.paint(g);
    }

    private int getSpriteFrame() {
        switch (this._iActualColor) {
            case 3: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public boolean isMoving() {
        return this._bMove;
    }

    public Sprite getSprite() {
        return this._dot;
    }

    public int getActualColor() {
        return this._iActualColor;
    }

    public int getActualYPosition() {
        return this._dotRect.y;
    }

    public int getActualBotomPosition() {
        return this._dotRect.y + this._dotRect.height;
    }

    public String getColorName() {
        switch (this._iActualColor) {
            case 3: {
                return "BLUE";
            }
            case 2: {
                return "GREEN";
            }
            case 0: {
                return "RED";
            }
            case 1: {
                return "YELLOW";
            }
        }
        return "NaN";
    }
}

