/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicTetris
extends GameLogic {
    protected int[][] figures;
    private final int[][] _figures = new int[][]{{5533, 35243}, {30382, 39615, 27373, 22955}, {17821, 27288, 23006, 51354}, {22170}, {18589, 35158}, {31662, 22187}, {27326, 39659, 27054, 27051}};
    protected final int SCORE_UP_MIN;
    protected final int SCORE_UP_INC;
    protected int FIGURE_COUNT;
    protected final int FIGURE_POS_H;
    protected int FIGURE_H;
    protected int FIGURE_H2;
    protected final int SCORE_INC;
    protected final int SCORE_BONUS;
    protected int SCORE_BONUS_COUNTER = 0;
    protected int iFigureNext = 0;
    protected int iStateNext = 0;
    protected int iFigure\u0421ur = -1;
    protected int iStateCur = 0;
    protected int iStateCount = 1;
    protected final int[] iArrPos = new int[2];
    protected final int[] iArrPosInit = new int[2];
    protected boolean lock = true;
    protected int iLineToEmpty = -1;
    protected int sScoreUp = 0;
    private int nextCheatFigure = -1;
    private boolean isHotFigure = false;

    private void init() {
        this.figures = this._figures;
        this.FIGURE_COUNT = 7;
        this.FIGURE_H = 4;
        this.FIGURE_H2 = this.FIGURE_H / 2;
        E.kIgnoreFirstKeyDownDelay[10] = true;
        this.firstKeydownDelay = 140;
        this.repeatKeydownDelay = 20;
    }

    public GameLogicTetris() {
        super(4);
        this.SCORE_UP_MIN = 3000;
        this.SCORE_UP_INC = 800;
        this.FIGURE_POS_H = 4;
        this.SCORE_INC = 100;
        this.SCORE_BONUS = 50;
        this.init();
    }

    public GameLogicTetris(int Figure_H) {
        super(Figure_H);
        this.SCORE_UP_MIN = 3000;
        this.SCORE_UP_INC = 800;
        this.FIGURE_POS_H = 4;
        this.SCORE_INC = 100;
        this.SCORE_BONUS = 50;
        this.init();
    }

    protected final void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iFigureNext);
        GUtillIo.writeInt(this.iFigure\u0421ur);
        GUtillIo.writeInt(this.iStateCur);
        GUtillIo.writeInt(this.iStateNext);
        GUtillIo.writeInt(this.iStateCount);
        GUtillIo.writeArray(this.iArrPos);
        GUtillIo.writeArray(this.iArrPosInit);
        GUtillIo.writeBoolean(this.lock);
        GUtillIo.writeInt(this.iLineToEmpty);
        GUtillIo.writeInt(this.sScoreUp);
    }

    protected final void load() throws Exception {
        super.load();
        this.iFigureNext = GUtillIo.readInt();
        this.iFigure\u0421ur = GUtillIo.readInt();
        this.iStateCur = GUtillIo.readInt();
        this.iStateNext = GUtillIo.readInt();
        this.iStateCount = GUtillIo.readInt();
        GUtillIo.read(this.iArrPos);
        GUtillIo.read(this.iArrPosInit);
        this.lock = GUtillIo.readBoolean();
        this.iLineToEmpty = GUtillIo.readInt();
        this.sScoreUp = GUtillIo.readInt();
    }

    public final void updateLevel(int level) {
        this.iArrPosInit[0] = (10 - this.FIGURE_H) / 2;
        this.iArrPosInit[1] = -this.FIGURE_H;
        this.iFigure\u0421ur = -1;
        this.iFigureNext = GUtillMath.rnd(this.FIGURE_COUNT);
        this.iStateCount = this.figures[this.iFigureNext].length;
        this.iStateNext = GUtillMath.rnd(this.iStateCount);
        this.lock = false;
        this.sScoreUp = 3000 + (level - 1) * 800;
        for (int i = 0; i < 10 * (level - 1); ++i) {
            GameField.setBrickType(200 - i, GUtillMath.rnd(2) == 0 ? 1 : 0);
        }
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.iFigure\u0421ur == -1) {
                this.generateFigure();
            }
            if (!this.lock) {
                if (this.can(this.iFigure\u0421ur, this.iStateCur, this.iArrPos[0], this.iArrPos[1] + 1)) {
                    this.iArrPos[1] = this.iArrPos[1] + 1;
                    this.updateFigure();
                } else {
                    int i;
                    for (i = 0; i < this.FIGURE_H; ++i) {
                        if (this.figure_pos[i] >= 0) continue;
                        this.gameover = true;
                        break;
                    }
                    for (i = 0; i < this.FIGURE_H; ++i) {
                        GameField.setBrickType(this.figure_pos[i], 1);
                        GameField.getItem(this.figure_pos[i]).setIsHotBrick(false);
                        this.figure_pos[i] = -1;
                    }
                    if (!this.gameover) {
                        this.iLineToEmpty = -1;
                        this.lock = true;
                    }
                }
            }
        }
    }

    public void keyClicked(int key) {
        if (!this.active) {
            if (key == 7) {
                E.kStates[7] = false;
                this.active = true;
            }
        } else if (this.active && this.iFigure\u0421ur != -1 && this.canUpdate() && !this.lock) {
            int x = this.iArrPos[0];
            int y = this.iArrPos[1];
            int state = this.iStateCur;
            if (key == 6) {
                --x;
            }
            if (key == 8) {
                ++x;
            }
            if (key == 10) {
                this.isHotFigure = true;
                ++y;
            }
            if (key == 7 || key == 4) {
                E.kStates[7] = false;
                E.kStates[4] = false;
                int n = state = key == 7 ? this.iStateCur + 1 : this.iStateCur - 1;
                if (state == this.iStateCount) {
                    state = 0;
                }
                if (state < 0) {
                    state = this.iStateCount - 1;
                }
                if (!this.can(this.iFigure\u0421ur, state, x, y)) {
                    if (x < 0) {
                        for (int i = 0; i < 3 && !this.can(this.iFigure\u0421ur, state, ++x, y); ++i) {
                        }
                    } else if (x >= 7) {
                        for (int i = 0; i < 3 && !this.can(this.iFigure\u0421ur, state, --x, y); ++i) {
                        }
                    }
                    if (this.can(this.iFigure\u0421ur, state, x, y)) {
                        if ((this.iFigure\u0421ur == 1 || this.iFigure\u0421ur == 6) && this.iStateCur == 2 && x == 7) {
                            --x;
                        }
                        if (this.iFigure\u0421ur == 0 && this.iStateCur == 0 && x == 7) {
                            --x;
                        }
                    }
                }
            }
            if (this.can(this.iFigure\u0421ur, state, x, y)) {
                this.iArrPos[0] = x;
                this.iArrPos[1] = y;
                this.iStateCur = state;
                this.updateFigure();
            }
            if (E.cheatsOn && E.lastCheatKeyIndex >= 0 && E.lastCheatKeyIndex < this.FIGURE_COUNT) {
                this.nextCheatFigure = E.lastCheatKeyIndex;
                E.lastCheatKeyIndex = -1;
            }
        }
    }

    public final boolean updateEvent() {
        if (!this.active) {
            return false;
        }
        if (this.iFigure\u0421ur != -1 && this.canUpdate() && this.lock) {
            if (this.iLineToEmpty == -1) {
                boolean full = false;
                int width = 10;
                for (int i = 19; i >= 0; --i) {
                    int j;
                    int last = i * 10;
                    int first = last + 10 - 1;
                    full = true;
                    for (j = first; j >= last && (full &= GameField.getBrickType(j) == 1); --j) {
                    }
                    if (!full) continue;
                    for (j = last; j <= first; ++j) {
                        GameField.getItem(j).setIsHotBrick(true);
                    }
                    this.iLineToEmpty = first;
                    GameField.setBrickType(this.iLineToEmpty, 0);
                    --this.iLineToEmpty;
                    GameField.setBrickType(this.iLineToEmpty, 0);
                    --this.iLineToEmpty;
                    break;
                }
                if (!full) {
                    this.iFigure\u0421ur = -1;
                    this.SCORE_BONUS_COUNTER = 0;
                    this.updateState();
                }
            } else {
                int excess = this.iLineToEmpty % 10;
                if (excess != 9) {
                    GameField.setBrickType(this.iLineToEmpty, 0);
                    --this.iLineToEmpty;
                    GameField.setBrickType(this.iLineToEmpty, 0);
                    --this.iLineToEmpty;
                } else if (excess == 9) {
                    for (int i = this.iLineToEmpty; i >= 0; --i) {
                        if (GameField.getBrickType(i) != 1) continue;
                        GameField.setBrickType(i, 0);
                        GameField.setBrickType(i + 10, 1);
                    }
                    this.score += 100 + this.SCORE_BONUS_COUNTER * 50;
                    this.CurrentScore += 100 + this.SCORE_BONUS_COUNTER * 50;
                    ++this.SCORE_BONUS_COUNTER;
                    this.iLineToEmpty = -1;
                }
            }
        }
        return false;
    }

    private final int getFigureElem(int figure, int state, int elem) {
        return this.figures[figure][state] >> elem * 4 & 0xF;
    }

    private final void generateFigure() {
        int i;
        this.iFigure\u0421ur = this.iFigureNext;
        if (this.nextCheatFigure != -1) {
            this.iFigureNext = this.nextCheatFigure;
            this.nextCheatFigure = -1;
        } else {
            this.iFigureNext = GUtillMath.rnd(this.FIGURE_COUNT);
        }
        this.iStateCur = this.iStateNext;
        this.iStateCount = this.figures[this.iFigure\u0421ur].length;
        this.iStateNext = GUtillMath.rnd(this.figures[this.iFigureNext].length);
        GUtillArray.copy(this.iArrPos, this.iArrPosInit);
        this.updateFigure();
        GUtillArray.fill(this.info, false);
        for (i = 0; i < this.FIGURE_H; ++i) {
            int figureIndex = this.getFigureElem(this.iFigureNext, this.iStateNext, i);
            this.info[figureIndex] = true;
        }
        for (i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        this.lock = false;
        if (this.CurrentScore >= this.sScoreUp) {
            this.CurrentScore = 0;
            this.gameup = true;
        }
    }

    private final void updateFigure() {
        GameFieldItem tempItem = new GameFieldItem();
        for (int i = 0; i < this.FIGURE_H; ++i) {
            int fieldIndex;
            int figureIndex = this.getFigureElem(this.iFigure\u0421ur, this.iStateCur, i);
            this.figure_pos[i] = fieldIndex = this.figureToField(figureIndex);
            tempItem.setData(this.figure_elem[i]);
            tempItem.setIsHotBrick(this.isHotFigure);
            this.figure_elem[i] = tempItem.data();
        }
        this.isHotFigure = false;
    }

    private final int figureToField(int index) {
        return this.iArrPos[1] * 10 + this.iArrPos[0] + index / 4 * 10 + index % 4;
    }

    private final boolean can(int figure, int state, int x, int y) {
        boolean result = true;
        for (int i = 0; i < this.FIGURE_H; ++i) {
            int pos = this.getFigureElem(figure, state, i);
            int pos_y = y + pos / 4;
            int pos_x = x + pos % 4;
            if (pos_x < 0 || pos_x > 9) {
                result = false;
                break;
            }
            if (pos_y < 0 || GameField.getBrickType(pos_x, pos_y) != 1) continue;
            result = false;
            break;
        }
        return result;
    }

    protected final void placePlayer() {
    }
}

