/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicShootRacing
extends GameLogic {
    private static final byte CAR_SIZE = 7;
    private static final int LIFE_MAX = 3;
    private static final byte BULLET_MAX = 2;
    private static final byte ENEMY_MAX = 3;
    private int[] iBulletPos = new int[2];
    private int[] iBulletOpPos = new int[3];
    private byte gameStateUpdate = 0;
    private byte shoot_probability;
    private static final byte SCORE_INC = 10;
    private static final int SCORE_UP = 500;
    private static final int[] CAR_FIGURE = new int[]{162, 171, 172, 173, 182, 191, 193};
    private static final int[] ENEMY_FIGURE = new int[]{0, 2, 11, 20, 21, 22, 31};
    private int iCarPos;
    private byte bSideWall;
    private int[] iEnemyPos = new int[3];
    private byte bEnemyRespawn = 0;
    private static final int scoreStep = 7;
    private int currentStep = 0;

    private byte bBulletsAvailable() {
        byte result = 0;
        for (int i = 0; i < this.iBulletPos.length; ++i) {
            if (this.iBulletPos[i] != -1) continue;
            result = (byte)(result + 1);
        }
        return result;
    }

    private boolean addBullet(int pos) {
        for (int i = 0; i < this.iBulletPos.length; ++i) {
            if (this.iBulletPos[i] != -1) continue;
            this.iBulletPos[i] = pos;
            return true;
        }
        return false;
    }

    public GameLogicShootRacing() {
        super(7, 3);
    }

    protected void load() throws Exception {
        super.load();
        this.iCarPos = GUtillIo.readInt();
        this.bSideWall = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
        this.gameStateUpdate = GUtillIo.readByte();
        this.bEnemyRespawn = GUtillIo.readByte();
        this.iBulletPos = GUtillIo.readIntArray();
        this.iBulletOpPos = GUtillIo.readIntArray();
        this.iEnemyPos = GUtillIo.readIntArray();
        this.shoot_probability = GUtillIo.readByte();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iCarPos);
        GUtillIo.writeByte(this.bSideWall);
        GUtillIo.writeByte(this.bShowCollision);
        GUtillIo.writeByte(this.gameStateUpdate);
        GUtillIo.writeByte(this.bEnemyRespawn);
        GUtillIo.writeIntArray(this.iBulletPos);
        GUtillIo.writeIntArray(this.iBulletOpPos);
        GUtillIo.writeIntArray(this.iEnemyPos);
        GUtillIo.writeByte(this.shoot_probability);
    }

    private final void updatePlayer() {
        boolean lifedecr = false;
        for (int i = 0; i < 7; ++i) {
            this.figure_pos[i] = CAR_FIGURE[i] + this.iCarPos;
            if (GameField.getBrickType(this.figure_pos[i]) != 3) continue;
            lifedecr = true;
        }
        if (lifedecr) {
            this.showCollision();
        }
    }

    protected void placePlayer() {
        int i;
        this.currentStep = 0;
        for (i = 0; i < this.iBulletPos.length; ++i) {
            this.iBulletPos[i] = -1;
        }
        this.shoot_probability = (byte)(9 - (EGame.iLevel - 1) / 2);
        GameField.clear();
        this.active = false;
        this.iCarPos = (byte)GUtillMath.rnd(6);
        for (i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        GUtillArray.fill(this.iEnemyPos, -1);
        GUtillArray.fill(this.iBulletOpPos, -1);
        GUtillArray.fill(this.iBulletPos, -1);
        this.gameStateUpdate = 0;
        this.bEnemyRespawn = (byte)2;
        this.updatePlayer();
    }

    private final boolean canPlace(int pos) {
        for (int i = 0; i < 7; ++i) {
            if (GameField.getBrickType(pos + ENEMY_FIGURE[i]) != 3 && GameField.getBrickType(pos + ENEMY_FIGURE[i] + 10) != 3) continue;
            return false;
        }
        return true;
    }

    private final void updateEnemies() {
        int i;
        boolean lifedecr = false;
        for (i = 0; i < 3; ++i) {
            if (this.iEnemyPos[i] != -1) {
                for (int j = 6; j >= 0; --j) {
                    GameField.setBrickType(this.iEnemyPos[i] + ENEMY_FIGURE[j], 0);
                    GameField.setBrickType(this.iEnemyPos[i] + 10 + ENEMY_FIGURE[j], 3);
                }
                int n = i;
                this.iEnemyPos[n] = this.iEnemyPos[n] + 10;
                if (this.iEnemyPos[i] > 200) {
                    this.iEnemyPos[i] = -1;
                    this.iBulletOpPos[i] = -1;
                }
            }
            if (!lifedecr) continue;
            this.showCollision();
            break;
        }
        if (this.bEnemyRespawn <= 0) {
            for (i = 0; i < 3; ++i) {
                int pos;
                if (this.iEnemyPos[i] != -1 || !this.canPlace(pos = GUtillMath.rnd(6) + 1)) continue;
                this.iEnemyPos[i] = pos;
                for (int j = 0; j < 7; ++j) {
                    GameField.setBrickType(this.iEnemyPos[i] + ENEMY_FIGURE[j], 3);
                }
                break;
            }
            this.bEnemyRespawn = (byte)4;
        } else {
            this.bEnemyRespawn = (byte)(this.bEnemyRespawn - 1);
        }
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
            E.kStates[7] = false;
        }
    }

    public boolean updateEvent() {
        if (this.active && this.bShowCollision == 0) {
            if (E.kStates[6]) {
                if (this.iCarPos > 0) {
                    --this.iCarPos;
                    this.updatePlayer();
                }
            } else if (E.kStates[8] && this.iCarPos < 5) {
                ++this.iCarPos;
                this.updatePlayer();
            }
            if (E.kStates[7] && this.bBulletsAvailable() != 0) {
                E.kStates[7] = false;
                this.addBullet(this.iCarPos + CAR_FIGURE[0] - 10);
            }
        }
        return false;
    }

    private boolean killEnemy(int pos) {
        for (int i = 0; i < 3; ++i) {
            if (this.iEnemyPos[i] == -1) continue;
            for (int j = 0; j < 7; ++j) {
                if (this.iEnemyPos[i] + ENEMY_FIGURE[j] != pos) continue;
                this.score += 10;
                this.CurrentScore += 10;
                for (int q = 0; q < 7; ++q) {
                    GameField.setBrickType(this.iEnemyPos[i] + ENEMY_FIGURE[q], 0);
                }
                this.iEnemyPos[i] = -1;
                return true;
            }
        }
        return false;
    }

    private boolean killPlayer(int bulletpos) {
        for (int i = 0; i < 7; ++i) {
            if (this.iCarPos + CAR_FIGURE[i] != bulletpos) continue;
            this.showCollision();
            return true;
        }
        return false;
    }

    public void updateLevel(int level) {
        this.placePlayer();
        this.bSideWall = 1;
        this.bShowCollision = 0;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                int i;
                for (i = 0; i < this.iBulletOpPos.length; ++i) {
                    if (this.iBulletOpPos[i] == -1) continue;
                    GameField.setBrickType(this.iBulletOpPos[i], 0);
                    if (this.iBulletOpPos[i] / 10 == 19) {
                        this.iBulletOpPos[i] = -1;
                        continue;
                    }
                    int n = i;
                    this.iBulletOpPos[n] = this.iBulletOpPos[n] + 10;
                    if (this.killPlayer(this.iBulletOpPos[i]) || GameField.getBrickType(this.iBulletOpPos[i]) == 3) {
                        this.iBulletOpPos[i] = -1;
                        continue;
                    }
                    GameField.setBrickType(this.iBulletOpPos[i], 5);
                }
                for (i = 0; i < this.iBulletPos.length; ++i) {
                    int j;
                    if (this.iBulletPos[i] == -1) continue;
                    GameField.setBrickType(this.iBulletPos[i], 0);
                    for (j = 0; j < this.iBulletOpPos.length; ++j) {
                        if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                        this.iBulletPos[i] = -1;
                        this.iBulletOpPos[j] = -1;
                    }
                    if (this.iBulletPos[i] == -1) continue;
                    if (this.iBulletPos[i] / 10 == 0) {
                        this.iBulletPos[i] = -1;
                        continue;
                    }
                    int n = i;
                    this.iBulletPos[n] = this.iBulletPos[n] - 10;
                    if (this.killEnemy(this.iBulletPos[i])) {
                        this.iBulletPos[i] = -1;
                        continue;
                    }
                    GameField.setBrickType(this.iBulletPos[i], 0);
                    for (j = 0; j < this.iBulletOpPos.length; ++j) {
                        if (this.iBulletOpPos[j] != this.iBulletPos[i]) continue;
                        this.iBulletOpPos[j] = -1;
                        this.iBulletPos[i] = -1;
                    }
                    if (this.iBulletPos[i] == -1) continue;
                    GameField.setBrickType(this.iBulletPos[i], 4);
                }
                if (this.gameStateUpdate > 3) {
                    for (i = 19; i >= 1; --i) {
                        GameField.setBrickType(i * 10, GameField.getBrickType(i * 10 - 10));
                        GameField.setBrickType(i * 10 + 9, GameField.getBrickType(i * 10 - 1));
                    }
                    if (this.bSideWall != 3) {
                        GameField.getItem(0).setData(GameFieldItem.fieldBrickData());
                        GameField.getItem(9).setData(GameFieldItem.fieldBrickData());
                        this.bSideWall = (byte)(this.bSideWall + 1);
                    } else {
                        GameField.setBrickType(0, 0);
                        GameField.setBrickType(9, 0);
                        this.bSideWall = 1;
                    }
                    this.updateEnemies();
                    for (i = 0; i < 3; ++i) {
                        boolean shoot;
                        boolean bl = shoot = GUtillMath.rnd(this.shoot_probability) == 0;
                        if (this.iEnemyPos[i] == -1 || !shoot || this.iBulletOpPos[i] != -1) continue;
                        this.iBulletOpPos[i] = this.iEnemyPos[i] + 41;
                        GameField.setBrickType(this.iBulletOpPos[i], 5);
                    }
                    if (this.checkCollision()) {
                        this.showCollision();
                    }
                    ++this.currentStep;
                    if (this.currentStep > 7) {
                        this.currentStep = 0;
                        this.score += 10;
                        this.CurrentScore += 10;
                    } else {
                        ++this.currentStep;
                    }
                    if (this.CurrentScore == 500) {
                        this.score += 200;
                        this.CurrentScore = 0;
                        this.gameup = true;
                        this.placePlayer();
                    }
                    this.gameStateUpdate = 0;
                } else {
                    this.gameStateUpdate = (byte)(this.gameStateUpdate + 1);
                }
            }
        }
    }

    private final void showCollision() {
        int i = 0;
        for (i = 0; i < 7; ++i) {
            GameField.getItem(CAR_FIGURE[i] + this.iCarPos).setData(0);
            this.figure_pos[i] = -1;
            this.figure_elem[i] = 0;
        }
        this.collisionAtPos(this.iCarPos + 161);
    }

    protected boolean checkCollision() {
        for (int i = 0; i < 7; ++i) {
            if (GameField.getBrickType(CAR_FIGURE[i] + this.iCarPos) != 3) continue;
            return true;
        }
        return false;
    }
}

