/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicTanks
extends GameLogic {
    private static final byte TANK_SIZE = 6;
    private static final int LIFE_MAX = 3;
    protected final int SCORE_UP_MIN;
    protected final int SCORE_UP_INC;
    private static final byte SCORE_INC = 50;
    private static final int[][] TANK_FIGURE = new int[][]{{11, 10, 1, 12, 20, 22}, {11, 1, 0, 12, 20, 21}, {11, 2, 10, 0, 12, 21}, {11, 2, 10, 1, 21, 22}};
    private static final byte[] BULLET_STARTING_POS = new byte[]{1, 12, 21, 10};
    private static final int[] TANK_OP_STARTING_POS = new int[]{0, 170, 7, 177};
    private int[] iBulletPos;
    private byte[] bBulletDirection;
    private int[] iTankOpPos;
    private byte[] bTankOpDirection;
    private byte bTankOpUpdate;
    private byte bTankOpCount = (byte)4;
    private boolean[] previous_rotate;
    private byte shoot_probability;
    private int[] iBulletOpPos;
    private byte[] bBulletOpDirection;
    private int iTankPos = 74;
    private byte bTankDirection = 0;
    private final byte bMaxBulletsAvailable = (byte)2;
    private static final byte UP_DIRECTION = 0;
    private static final byte RIGHT_DIRECTION = 1;
    private static final byte DOWN_DIRECTION = 2;
    private static final byte LEFT_DIRECTION = 3;
    protected long sScoreUp = 0L;
    private int canDelay = 0;

    private byte bBulletsAvailable() {
        byte result = 0;
        for (int i = 0; i < this.iBulletPos.length; ++i) {
            if (this.iBulletPos[i] != -1) continue;
            result = (byte)(result + 1);
        }
        return result;
    }

    private boolean addBullet(int pos, byte direction) {
        for (int i = 0; i < this.iBulletPos.length; ++i) {
            if (this.iBulletPos[i] != -1) continue;
            this.iBulletPos[i] = pos;
            this.bBulletDirection[i] = direction;
            return true;
        }
        return false;
    }

    public GameLogicTanks() {
        super(6, 3);
        this.SCORE_UP_MIN = 2000;
        this.SCORE_UP_INC = 600;
        this.iBulletPos = new int[2];
        this.bBulletDirection = new byte[2];
        this.iBulletOpPos = new int[this.bTankOpCount];
        this.bBulletOpDirection = new byte[this.bTankOpCount];
        this.iTankOpPos = new int[this.bTankOpCount];
        this.bTankOpDirection = new byte[this.bTankOpCount];
        this.previous_rotate = new boolean[this.bTankOpCount];
        this.firstKeydownDelay = 90;
        GameFieldItem.TAIN_HIGHLIGHT_1_TARIN = false;
        GameFieldItem.TRAIN_LENGTH = 2;
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iTankPos);
        GUtillIo.writeByte(this.bTankDirection);
        GUtillIo.writeByte(this.bShowCollision);
        GUtillIo.writeByte(this.bTankOpCount);
        GUtillIo.writeByte(this.bTankOpUpdate);
        GUtillIo.writeIntArray(this.iBulletPos);
        GUtillIo.writeByteArray(this.bBulletDirection);
        GUtillIo.writeIntArray(this.iBulletOpPos);
        GUtillIo.writeByteArray(this.bBulletOpDirection);
        GUtillIo.writeIntArray(this.iTankOpPos);
        GUtillIo.writeByteArray(this.bTankOpDirection);
        GUtillIo.writeBooleanArray(this.previous_rotate);
        GUtillIo.writeLong(this.sScoreUp);
        GUtillIo.writeByte(this.shoot_probability);
    }

    protected void load() throws Exception {
        super.load();
        this.iTankPos = GUtillIo.readInt();
        this.bTankDirection = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
        this.bTankOpCount = GUtillIo.readByte();
        this.bTankOpUpdate = GUtillIo.readByte();
        this.iBulletPos = GUtillIo.readIntArray();
        this.bBulletDirection = GUtillIo.readByteArray();
        this.iBulletOpPos = GUtillIo.readIntArray();
        this.bBulletOpDirection = GUtillIo.readByteArray();
        this.iTankOpPos = GUtillIo.readIntArray();
        this.bTankOpDirection = GUtillIo.readByteArray();
        this.previous_rotate = GUtillIo.readBooleanArray();
        this.sScoreUp = GUtillIo.readLong();
        this.shoot_probability = GUtillIo.readByte();
    }

    private final void updateFigure() {
        for (int i = 0; i < 6; ++i) {
            this.figure_pos[i] = this.iTankPos + TANK_FIGURE[this.bTankDirection][i];
        }
    }

    protected void placePlayer() {
        int i;
        for (i = 0; i < this.iBulletPos.length; ++i) {
            this.iBulletPos[i] = -1;
        }
        this.active = false;
        this.shoot_probability = (byte)(9 - (EGame.iLevel - 1) / 2);
        GameField.clear();
        GUtillArray.fill(this.iBulletOpPos, -1);
        this.bTankOpCount = (byte)4;
        GUtillArray.fill(this.iTankOpPos, -1);
        this.iTankPos = 74;
        this.bTankDirection = 0;
        for (i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        GameFieldItem item = new GameFieldItem();
        item.setData(this.figure_elem[0]);
        item.setIsHotBrick(true);
        item.setIsBlinking(true);
        this.figure_elem[0] = item.data();
        this.bTankOpUpdate = 0;
        GUtillArray.fill(this.previous_rotate, false);
        this.updateFigure();
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
            E.kStates[7] = false;
        } else if (this.active && this.bShowCollision == 0) {
            if (key == 6) {
                if (this.bTankDirection == 3 && this.can(this.iTankPos, (byte)3, this.iTankPos - 1)) {
                    --this.iTankPos;
                }
                this.bTankDirection = (byte)3;
                this.updateFigure();
            } else if (key == 8) {
                if (this.bTankDirection == 1 && this.can(this.iTankPos, (byte)1, this.iTankPos + 1)) {
                    ++this.iTankPos;
                }
                this.bTankDirection = 1;
                this.updateFigure();
            } else if (key == 4) {
                if (this.bTankDirection == 0 && this.can(this.iTankPos, (byte)0, this.iTankPos - 10)) {
                    this.iTankPos -= 10;
                }
                this.bTankDirection = 0;
                this.updateFigure();
            } else if (key == 10) {
                if (this.bTankDirection == 2 && this.can(this.iTankPos, (byte)2, this.iTankPos + 10)) {
                    this.iTankPos += 10;
                }
                this.bTankDirection = (byte)2;
                this.updateFigure();
            }
            if (key == 7 && this.bBulletsAvailable() != 0) {
                this.addBullet(this.iTankPos + BULLET_STARTING_POS[this.bTankDirection], this.bTankDirection);
            }
        }
    }

    private int moveBullet(int bulletPos, byte bulletDirection) {
        if (bulletPos < 0 || bulletPos >= 200 || bulletDirection == -1) {
            return -1;
        }
        GameField.setBrickType(bulletPos, 0);
        int x = bulletPos % 10;
        int y = bulletPos / 10;
        switch (bulletDirection) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++x;
                break;
            }
            case 2: {
                ++y;
                break;
            }
            case 3: {
                --x;
            }
        }
        int newPos = x < 0 || x >= 10 || y < 0 || y >= 20 ? -1 : x + 10 * y;
        if (newPos != -1) {
            if (this.killTank(newPos)) {
                newPos = -1;
            } else {
                boolean bulletIsDead = false;
                for (int j = 0; j < this.bTankOpCount; ++j) {
                    if (this.iBulletOpPos[j] != newPos) continue;
                    GameField.setBrickType(this.iBulletOpPos[j], 0);
                    this.iBulletOpPos[j] = -1;
                    bulletIsDead = true;
                }
                if (bulletIsDead) {
                    newPos = -1;
                }
            }
        }
        if (newPos != -1) {
            GameField.setBrickType(newPos, 4);
        }
        return newPos;
    }

    private int moveOpBullet(int bulletPos, byte bulletDirection) {
        if (bulletPos < 0 || bulletPos >= 200 || bulletDirection == -1) {
            return -1;
        }
        if (GameField.getBrickType(bulletPos) == 1 || GameField.getBrickType(bulletPos) == 3) {
            return -1;
        }
        GameField.setBrickType(bulletPos, 0);
        for (int i = 0; i < this.iBulletPos.length; ++i) {
            if (this.iBulletPos[i] != bulletPos) continue;
            GameField.setBrickType(bulletPos, 0);
            this.iBulletPos[i] = -1;
            return -1;
        }
        int x = bulletPos % 10;
        int y = bulletPos / 10;
        switch (bulletDirection) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++x;
                break;
            }
            case 2: {
                ++y;
                break;
            }
            case 3: {
                --x;
            }
        }
        int newPos = -1;
        if (x >= 0 && x < 10 && y >= 0 && y < 20) {
            newPos = x + y * 10;
            if (!this.killPlayer(newPos) && GameField.getBrickType(newPos) != 3) {
                GameField.setBrickType(newPos, 5);
            } else {
                newPos = -1;
            }
        }
        return newPos;
    }

    public boolean updateEvent() {
        if (this.active && this.bShowCollision == 0) {
            int i;
            for (i = 0; i < this.iBulletPos.length; ++i) {
                this.iBulletPos[i] = this.moveBullet(this.iBulletPos[i], this.bBulletDirection[i]);
            }
            for (i = 0; i < this.bTankOpCount; ++i) {
                this.iBulletOpPos[i] = this.moveOpBullet(this.iBulletOpPos[i], this.bBulletOpDirection[i]);
            }
        }
        return false;
    }

    private boolean killTank(int pos) {
        boolean result = false;
        for (int i = 0; i < this.bTankOpCount; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.iTankOpPos[i] == -1 || this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j] != pos) continue;
                this.score += 50;
                this.CurrentScore += 50;
                for (int q = 0; q < 6; ++q) {
                    GameField.setBrickType(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][q], 0);
                }
                this.iTankOpPos[i] = -1;
                result = true;
            }
        }
        return result;
    }

    private boolean killPlayer(int bulletpos) {
        for (int i = 0; i < 6; ++i) {
            if (this.iTankPos + TANK_FIGURE[this.bTankDirection][i] != bulletpos) continue;
            this.showCollision();
            return true;
        }
        return false;
    }

    public void updateLevel(int level) {
        this.placePlayer();
        this.bShowCollision = 0;
        this.sScoreUp = 2000 + (level - 1) * 600;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = this.bTankOpUpdate; i < this.bTankOpCount - (2 - this.bTankOpUpdate); ++i) {
                    boolean shoot;
                    int j;
                    int new_pos = -1;
                    byte dir = -1;
                    if (this.iTankOpPos[i] != -1) {
                        for (j = 0; j < 6; ++j) {
                            GameField.setBrickType(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j], 0);
                        }
                    }
                    if (this.iTankOpPos[i] == -1) {
                        this.bTankOpDirection[i] = (byte)GUtillMath.rnd(4);
                        for (j = 0; j < 4; ++j) {
                            if (!this.canOponent(this.iTankOpPos[i], this.bTankOpDirection[i], TANK_OP_STARTING_POS[j])) continue;
                            new_pos = TANK_OP_STARTING_POS[j];
                            break;
                        }
                        this.previous_rotate[i] = false;
                    } else {
                        do {
                            if ((dir = (byte)((byte)GUtillMath.rnd(4))) != this.bTankOpDirection[i] && !this.previous_rotate[i]) {
                                this.bTankOpDirection[i] = dir;
                                new_pos = this.iTankOpPos[i];
                                this.previous_rotate[i] = true;
                                break;
                            }
                            this.bTankOpDirection[i] = dir;
                            switch (this.bTankOpDirection[i]) {
                                case 0: {
                                    new_pos = this.iTankOpPos[i] - 10;
                                    break;
                                }
                                case 1: {
                                    new_pos = this.iTankOpPos[i] + 1;
                                    break;
                                }
                                case 2: {
                                    new_pos = this.iTankOpPos[i] + 10;
                                    break;
                                }
                                case 3: {
                                    new_pos = this.iTankOpPos[i] - 1;
                                }
                            }
                            this.previous_rotate[i] = false;
                        } while (!this.canOponent(this.iTankOpPos[i], this.bTankOpDirection[i], new_pos));
                    }
                    this.iTankOpPos[i] = new_pos;
                    if (this.iTankOpPos[i] != -1) {
                        for (j = 0; j < 6; ++j) {
                            GameField.setBrickType(this.iTankOpPos[i] + TANK_FIGURE[this.bTankOpDirection[i]][j], 3);
                        }
                    }
                    boolean bl = shoot = GUtillMath.rnd(this.shoot_probability) == 0;
                    if (this.iTankOpPos[i] == -1 || !shoot || this.iBulletOpPos[i] != -1) continue;
                    this.bBulletOpDirection[i] = this.bTankOpDirection[i];
                    this.iBulletOpPos[i] = this.iTankOpPos[i] + BULLET_STARTING_POS[this.bTankOpDirection[i]];
                    int x = this.iBulletOpPos[i];
                    GameField.setBrickType(x, 0);
                    this.iBulletOpPos[i] = this.moveOpBullet(this.iBulletOpPos[i], this.bTankOpDirection[i]);
                    GameField.setBrickType(x, 3);
                }
                this.bTankOpUpdate = (byte)(this.bTankOpUpdate == 0 ? 2 : 0);
            }
            if ((long)this.CurrentScore >= this.sScoreUp) {
                this.CurrentScore = 0;
                this.gameup = true;
            }
        }
    }

    private final void showCollision() {
        int i = 0;
        for (i = 0; i < 6; ++i) {
            GameField.getItem(this.iTankPos + TANK_FIGURE[this.bTankDirection][i]).setData(0);
            this.figure_pos[i] = -1;
            this.figure_elem[i] = 0;
        }
        this.collisionAtPos(this.iTankPos);
    }

    private final boolean canOponent(int pos, byte dir, int new_pos) {
        if (this.canDelay > 0) {
            --this.canDelay;
            return false;
        }
        if (this.can(pos, dir, new_pos)) {
            this.canDelay = 4;
            return true;
        }
        return false;
    }

    private final boolean can(int pos, byte dir, int new_pos) {
        if (pos != -1) {
            if (pos % 10 == 0 && dir == 3) {
                return false;
            }
            if (pos % 10 == 7 && dir == 1) {
                return false;
            }
            if (pos / 10 == 0 && dir == 0) {
                return false;
            }
            if (pos / 10 == 17 && dir == 2) {
                return false;
            }
        }
        if (pos == -1) {
            for (int i = 0; i < 6; ++i) {
                if (GameField.getBrickType(new_pos + TANK_FIGURE[dir][i]) != 4) continue;
                return false;
            }
        }
        int new_pos_x = new_pos % 10;
        int new_pos_y = new_pos / 10;
        for (int i = 0; i < this.bTankOpCount; ++i) {
            int tank_pos_x = this.iTankOpPos[i] % 10;
            int tank_pos_y = this.iTankOpPos[i] / 10;
            if (this.iTankOpPos[i] == -1 || pos == this.iTankOpPos[i] || GUtillMath.abs(tank_pos_x - new_pos_x) >= 3 || GUtillMath.abs(tank_pos_y - new_pos_y) >= 3) continue;
            return false;
        }
        if (pos != this.iTankPos) {
            int tank_pos_x = this.iTankPos % 10;
            int tank_pos_y = this.iTankPos / 10;
            if (GUtillMath.abs(tank_pos_x - new_pos_x) < 3 && GUtillMath.abs(tank_pos_y - new_pos_y) < 3) {
                return false;
            }
        }
        return true;
    }
}

