/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.AthanException;
import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Outils.StringOutilClient;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.impl.midp.VirtualKeyboard;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import java.util.Date;

public class MenuLocalTime
extends Menu {
    private static final int HAUTEUR_LABEL = 18;
    private static final int HAUTEUR_LABEL_TOUS = 60;
    final ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
    private Command mOK;
    private TextField mDecalage;
    private ComboBox mFormatHoraire;

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuLocalTime();
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuLocalTime");
    }

    protected String getIconBaseName() {
        return "MenuConfigHeureLocale";
    }

    protected void execute(final Form f) {
        this.applyTactileSettings(f);
        Label lLabelDecalage = new Label(this.RESSOURCE.get("TimeLag"));
        this.editerLabel(lLabelDecalage);
        Label lLabelFormatHoraire = new Label(this.RESSOURCE.get("TimeFormat"));
        this.editerLabel(lLabelFormatHoraire);
        this.mDecalage = new TextField();
        this.editerTextField(this.mDecalage);
        this.mFormatHoraire = new ComboBox(TIME_FORMAT);
        Container ctnSaisie = new Container(new GridLayout(2, 2));
        ctnSaisie.addComponent(lLabelDecalage);
        ctnSaisie.addComponent(this.mDecalage);
        ctnSaisie.addComponent(lLabelFormatHoraire);
        ctnSaisie.addComponent(this.mFormatHoraire);
        ctnSaisie.setPreferredH(60);
        f.setLayout(new BoxLayout(2));
        f.addComponent(new Label());
        f.addComponent(ctnSaisie);
        if (!Main.isTactile()) {
            // empty if block
        }
        this.mOK = new Command(this.RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent ae) {
                int decalage;
                boolean contenuOk;
                block7: {
                    contenuOk = true;
                    decalage = 0;
                    try {
                        String s_decalage = MenuLocalTime.this.mDecalage.getText();
                        if (!StringOutilClient.isEmpty(s_decalage)) {
                            decalage = Integer.parseInt(s_decalage);
                            if (Math.abs(decalage) > 12) {
                                throw new AthanException("> 12");
                            }
                            break block7;
                        }
                        throw new AthanException("empty");
                    }
                    catch (Exception exc) {
                        contenuOk = false;
                    }
                }
                if (!contenuOk) {
                    ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
                    Command okCommand = new Command(RESSOURCE.get("Command.OK"));
                    Dialog.show(RESSOURCE.get("errorTitle"), RESSOURCE.get("errorTimeLagParameters"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    return;
                }
                try {
                    ServiceFactory.getFactory().getPreferences().set("decalageHoraire", Integer.toString(decalage));
                    ServiceFactory.getFactory().getPreferences().set("formatHoraire", Integer.toString(MenuLocalTime.this.mFormatHoraire.getSelectedIndex()));
                    ServiceFactory.getFactory().getPreferences().save();
                    ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                    Command okCommand = new Command(MenuLocalTime.this.RESSOURCE.get("Command.OK"));
                    Dialog.show(MenuLocalTime.this.RESSOURCE.get("propertiesSavedTitle"), MenuLocalTime.this.RESSOURCE.get("propertiesSavedContent"), okCommand, new Command[]{okCommand}, 4, null, 2000L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    f.showBack();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        f.addCommand(this.mOK);
        this.initialiserInfosDecalage();
        this.initialiserClaviers();
    }

    private void initialiserInfosDecalage() {
        String lDecalage = "0";
        int lFormatHoraire = 0;
        try {
            lDecalage = ServiceFactory.getFactory().getPreferences().get("decalageHoraire");
            lFormatHoraire = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("formatHoraire"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.mDecalage.setText(lDecalage);
        this.mFormatHoraire.setSelectedIndex(lFormatHoraire);
    }

    private void initialiserClaviers() {
        VirtualKeyboard vkbEntier = new VirtualKeyboard();
        vkbEntier.addInputMode("Val.", KB_INTEGER);
        vkbEntier.setInputModeOrder(new String[]{"Val."});
        VirtualKeyboard.bindVirtualKeyboard(this.mDecalage, vkbEntier);
    }

    private void editerLabel(Label pLabel) {
        pLabel.setUIID("LabelInfoName");
        pLabel.getUnselectedStyle().setBgTransparency(0);
        pLabel.getSelectedStyle().setBgTransparency(0);
        pLabel.setFocusable(true);
        pLabel.setAlignment(1);
        pLabel.setPreferredH(18);
    }

    private void editerTextField(TextField pTextField) {
        pTextField.setUIID("LabelLocalisationInfo");
        pTextField.setAlignment(1);
        pTextField.setRows(1);
        pTextField.setPreferredH(18);
    }
}

