/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Factory;

import athan.src.Client.AthanConstantes;
import athan.src.Client.Main;
import athan.src.Factory.Preferences;
import com.sun.lwuit.plaf.UIManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class ResourceReader
extends AthanConstantes {
    private static final String RESOURCE_FR = "messages_fr-FR.xml";
    private static final String RESOURCE_EN = "messages_en-US.xml";
    private String mLocale;
    private String xmlFileName;
    private String contenu_about;
    private String contenu_consignesGeocoding;
    public String helpMenuAlerts;
    public String helpMenuCalculationMethod;
    public String helpMenuCompass;
    public String helpMenuLanguage;
    public String helpMenuLocalTime;
    public String helpMenuLocation;
    public String helpMenuPrayers;

    public ResourceReader(Preferences lPreferences) throws IOException {
        this(null, lPreferences);
    }

    public ResourceReader(String pLocale, Preferences lPreferences) throws IOException {
        try {
            if (pLocale == null) {
                pLocale = lPreferences.getLangue();
            }
            if (pLocale.equals("en")) {
                this.xmlFileName = RESOURCE_EN;
            } else if (pLocale.equals("fr")) {
                this.xmlFileName = RESOURCE_FR;
            }
            this.mLocale = pLocale;
            UIManager.getInstance().setResourceBundle(Main.languages.getL10N("localize", this.mLocale));
        }
        catch (Exception exc) {
            this.xmlFileName = RESOURCE_EN;
            exc.printStackTrace();
        }
        this.parse(this.getClass().getResourceAsStream("/" + this.xmlFileName));
    }

    public String get(String pKey) {
        return UIManager.getInstance().localize(pKey, this.mLocale);
    }

    public void parse(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        XmlParser parser = new XmlParser(reader);
        parser.skip();
        parser.read(64, null, "strings");
        this.contenu_about = this.lireTexte(parser);
        this.contenu_consignesGeocoding = this.lireTexte(parser);
        this.helpMenuAlerts = this.lireTexte(parser);
        this.helpMenuCalculationMethod = this.lireTexte(parser);
        this.helpMenuCompass = this.lireTexte(parser);
        this.helpMenuLanguage = this.lireTexte(parser);
        this.helpMenuLocalTime = this.lireTexte(parser);
        this.helpMenuLocation = this.lireTexte(parser);
        this.helpMenuPrayers = this.lireTexte(parser);
    }

    private String lireTexte(XmlParser pParser) throws IOException {
        String retour = "";
        boolean lire = true;
        while (lire) {
            ParseEvent pe = pParser.read();
            if (pe.getType() != 64) continue;
            pe = pParser.read();
            retour = pe.getText();
            lire = false;
        }
        return retour;
    }

    public String getContenu_About() {
        return this.contenu_about;
    }

    public String getContenu_ConsignesGeocoding() {
        return this.contenu_consignesGeocoding;
    }

    public String getHelpMenuAlerts() {
        return this.helpMenuAlerts;
    }

    public String getHelpMenuCalculationMethod() {
        return this.helpMenuCalculationMethod;
    }

    public String getHelpMenuCompass() {
        return this.helpMenuCompass;
    }

    public String getHelpMenuLanguage() {
        return this.helpMenuLanguage;
    }

    public String getHelpMenuLocalTime() {
        return this.helpMenuLocalTime;
    }

    public String getHelpMenuLocation() {
        return this.helpMenuLocation;
    }

    public String getHelpMenuPrayers() {
        return this.helpMenuPrayers;
    }

    public String[] getDateFormattee(Calendar pCalendar) {
        String[] retour = new String[2];
        String jour = "";
        switch (pCalendar.get(7)) {
            case 2: {
                jour = this.get("Monday");
                break;
            }
            case 3: {
                jour = this.get("Tuesday");
                break;
            }
            case 4: {
                jour = this.get("Wednesday");
                break;
            }
            case 5: {
                jour = this.get("Thursday");
                break;
            }
            case 6: {
                jour = this.get("Friday");
                break;
            }
            case 7: {
                jour = this.get("Saturday");
                break;
            }
            case 1: {
                jour = this.get("Sunday");
                break;
            }
        }
        String mois = "";
        switch (pCalendar.get(2)) {
            case 0: {
                mois = this.get("January");
                break;
            }
            case 1: {
                mois = this.get("February");
                break;
            }
            case 2: {
                mois = this.get("March");
                break;
            }
            case 3: {
                mois = this.get("April");
                break;
            }
            case 4: {
                mois = this.get("May");
                break;
            }
            case 5: {
                mois = this.get("June");
                break;
            }
            case 6: {
                mois = this.get("July");
                break;
            }
            case 7: {
                mois = this.get("August");
                break;
            }
            case 8: {
                mois = this.get("September");
                break;
            }
            case 9: {
                mois = this.get("October");
                break;
            }
            case 10: {
                mois = this.get("November");
                break;
            }
            case 11: {
                mois = this.get("December");
                break;
            }
        }
        if (this.mLocale.equals("en")) {
            retour[0] = jour;
            retour[1] = mois + " the " + pCalendar.get(5) + this.retournerSuffixeNombreEn(pCalendar.get(5)) + " " + pCalendar.get(1);
        } else if (this.mLocale.equals("fr")) {
            retour[0] = jour;
            retour[1] = pCalendar.get(5) + " " + mois + " " + pCalendar.get(1);
        }
        return retour;
    }

    private String retournerSuffixeNombreEn(int pNombre) {
        String retour = "th";
        if (pNombre % 10 == 1) {
            retour = "st";
        } else if (pNombre % 10 == 2) {
            retour = "nd";
        }
        return retour;
    }
}

