/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Client;

import athan.src.Client.AthanConstantes;
import athan.src.Client.Main;
import athan.src.Factory.ServiceFactory;
import athan.src.Outils.StringOutilClient;
import athan.src.Priere.Horaire;
import athan.src.Priere.PrieresJournee;
import athan.src.SalaahCalc.CalculationCustomParams;
import athan.src.SalaahCalc.CalculationMethods;
import athan.src.SalaahCalc.JuristicMethods;
import athan.src.SalaahCalc.SalaahTimeCalculator;
import com.sun.lwuit.Label;
import java.util.Calendar;
import java.util.Date;

public class VuePrincipale
extends AthanConstantes {
    private PrieresJournee mPrieresJournee;
    private boolean mProchainePriereRenseignee;
    private String[] mHorairesPrieres;
    private Calendar mHoraireDernierAppel;

    public void rafraichir(Date pDate, boolean isHeureCourante, boolean pForcerCalcul) {
        String sLatitude = "";
        String sLongitude = "";
        int formatHoraire = 0;
        int methodeJuridiqueAsr = 0;
        int decalageHoraire = 0;
        int calculationMethod = 0;
        try {
            if (this.estMinuitPile(pDate) || pForcerCalcul) {
                sLatitude = ServiceFactory.getFactory().getPreferences().get("latitude");
                sLongitude = ServiceFactory.getFactory().getPreferences().get("longitude");
                formatHoraire = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("formatHoraire"));
                methodeJuridiqueAsr = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("methodeJuristiqueAsr"));
                decalageHoraire = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("decalageHoraire"));
                calculationMethod = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("methodeCalcul"));
                CalculationCustomParams customParams = ServiceFactory.getFactory().getPreferences().getCalculationCustomParams();
                SalaahTimeCalculator calc = new SalaahTimeCalculator();
                calc.setCalculationMethod(new CalculationMethods(calculationMethod), customParams);
                calc.setAsrJurusticType(new JuristicMethods(methodeJuridiqueAsr));
                calc.setTimeFormat(formatHoraire);
                this.mHorairesPrieres = calc.getPrayerTimes(pDate, Double.parseDouble(sLatitude), Double.parseDouble(sLongitude), new Integer(SalaahTimeCalculator.getTimeZone() + decalageHoraire));
                this.mPrieresJournee = new PrieresJournee(pDate, new Horaire(this.mHorairesPrieres[0], formatHoraire), new Horaire(this.mHorairesPrieres[1], formatHoraire), new Horaire(this.mHorairesPrieres[2], formatHoraire), new Horaire(this.mHorairesPrieres[3], formatHoraire), new Horaire(this.mHorairesPrieres[4], formatHoraire), new Horaire(this.mHorairesPrieres[6], formatHoraire), new Horaire(this.mHorairesPrieres[7], formatHoraire));
                Calendar cal = Calendar.getInstance();
                cal.setTime(pDate);
                this.mHoraireDernierAppel = cal;
            } else {
                formatHoraire = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("formatHoraire"));
                this.mPrieresJournee.setDateJour(pDate);
            }
            this.renseignerLieu();
            this.renseignerPrieres(isHeureCourante);
            this.renseignerDate(isHeureCourante);
            Main.getMainForm().getForm().repaint();
            Main.getMainForm().setHeureCourante(pDate);
            this.traiterAlarmes(pDate);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private boolean memeHoraire(Calendar pCal1, Calendar pCal2) {
        return pCal1.get(1) == pCal2.get(1) && pCal1.get(2) == pCal2.get(2) && pCal1.get(5) == pCal2.get(5) && pCal1.get(11) == pCal2.get(11) && pCal1.get(12) == pCal2.get(12);
    }

    private boolean faireSonner(String pPreferenceKey) {
        return Integer.parseInt(ServiceFactory.getFactory().getPreferences().get(pPreferenceKey)) == 1;
    }

    private boolean traiterAlarmePriere(Calendar pHeureCourante, Horaire pHoraire, String pPreferenceKey) {
        boolean retour = false;
        if (this.memeHoraire(pHeureCourante, pHoraire.getHoraireDate()) && !this.memeHoraire(pHeureCourante, this.mHoraireDernierAppel)) {
            if (this.faireSonner(pPreferenceKey)) {
                retour = true;
            }
            this.mHoraireDernierAppel = pHeureCourante;
        }
        return retour;
    }

    private void traiterAlarmes(Date pDate) {
        Calendar pHeureCourante = Calendar.getInstance();
        pHeureCourante.setTime(pDate);
        if (this.traiterAlarmePriere(pHeureCourante, this.mPrieresJournee.getSobh(), "alertSobh")) {
            Main.getMainForm().traiterAlarme("alertSobh");
        } else if (this.traiterAlarmePriere(pHeureCourante, this.mPrieresJournee.getDohr(), "alertDohr")) {
            Main.getMainForm().traiterAlarme("alertDohr");
        } else if (this.traiterAlarmePriere(pHeureCourante, this.mPrieresJournee.getAsr(), "alertAsr")) {
            Main.getMainForm().traiterAlarme("alertAsr");
        } else if (this.traiterAlarmePriere(pHeureCourante, this.mPrieresJournee.getMaghreb(), "alertMaghreb")) {
            Main.getMainForm().traiterAlarme("alertMaghreb");
        } else if (this.traiterAlarmePriere(pHeureCourante, this.mPrieresJournee.getIshaa(), "alertIshaa")) {
            Main.getMainForm().traiterAlarme("alertIshaa");
        }
    }

    private void renseignerLieu() {
        String lieu = "";
        try {
            String pays;
            String region;
            String ville = ServiceFactory.getFactory().getPreferences().get("cityName");
            if (!StringOutilClient.isEmpty(ville)) {
                lieu = lieu + ville;
            }
            if (!StringOutilClient.isEmpty(region = ServiceFactory.getFactory().getPreferences().get("regionName"))) {
                lieu = lieu + ", " + region;
            }
            if (!StringOutilClient.isEmpty(pays = ServiceFactory.getFactory().getPreferences().get("countryName"))) {
                lieu = lieu + ", " + pays;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Main.getMainForm().getLabelLieu().setText(lieu);
    }

    private void renseignerDate(boolean isHeureCourante) {
        String[] dateJour = this.mPrieresJournee.getDateFormattee();
        if (isHeureCourante) {
            Main.getMainForm().getLabelLibelleHeure().setText(this.mPrieresJournee.getHoraire());
            Main.getMainForm().getLabelLibelleHeure().setVisible(true);
        } else {
            Main.getMainForm().getLabelLibelleHeure().setText("");
            Main.getMainForm().getLabelLibelleHeure().setVisible(false);
        }
        try {
            Main.getMainForm().getLabelLibelleDate().setText(dateJour[0]);
            Main.getMainForm().getLabelLibelleJourSemaine().setText(dateJour[1]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void renseignerPrieres(boolean pIsHeureCourante) {
        this.mProchainePriereRenseignee = false;
        Main.getMainForm().getLabelHoraireImsak().setText(this.mPrieresJournee.getImsak().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireImsak(), this.mPrieresJournee.getImsak().isEstProchaine(), false);
        Main.getMainForm().getLabelHoraireSohb().setText(this.mPrieresJournee.getSobh().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireSohb(), this.mPrieresJournee.getSobh().isEstProchaine(), pIsHeureCourante);
        Main.getMainForm().getLabelHoraireChourouk().setText(this.mPrieresJournee.getChourouk().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireChourouk(), this.mPrieresJournee.getChourouk().isEstProchaine(), false);
        Main.getMainForm().getLabelHoraireDohr().setText(this.mPrieresJournee.getDohr().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireDohr(), this.mPrieresJournee.getDohr().isEstProchaine(), pIsHeureCourante);
        Main.getMainForm().getLabelHoraireAsr().setText(this.mPrieresJournee.getAsr().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireAsr(), this.mPrieresJournee.getAsr().isEstProchaine(), pIsHeureCourante);
        Main.getMainForm().getLabelHoraireMaghreb().setText(this.mPrieresJournee.getMaghreb().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireMaghreb(), this.mPrieresJournee.getMaghreb().isEstProchaine(), pIsHeureCourante);
        Main.getMainForm().getLabelHoraireIshaa().setText(this.mPrieresJournee.getIshaa().getHoraireFormate());
        this.changerFontPriere(Main.getMainForm().getLabelHoraireIshaa(), this.mPrieresJournee.getIshaa().isEstProchaine(), pIsHeureCourante);
    }

    private void changerFontPriere(Label pLabel, boolean pIsProchaine, boolean pIsHeureCourante) {
        if (pIsProchaine && !this.mProchainePriereRenseignee && pIsHeureCourante) {
            pLabel.setUIID("LabelNextPrayer");
            this.mProchainePriereRenseignee = true;
        } else {
            pLabel.setUIID("LabelPrayer");
        }
    }

    private boolean estMinuitPile(Date pDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDate);
        return cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0;
    }
}

