/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Priere;

import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.SalaahCalc.TimeFormat;
import java.util.Calendar;
import java.util.Date;

public class Horaire {
    private String horaire;
    private Calendar horaireDate;
    private int timeFormat;

    public Horaire(String horaire, int timeFormat) {
        this.horaire = horaire;
        this.timeFormat = timeFormat;
        ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
        Calendar calActuel = Calendar.getInstance();
        calActuel.setTime(new Date());
        Calendar calHoraire = Calendar.getInstance();
        calHoraire.setTime(new Date());
        if (timeFormat == TimeFormat.H24.getValue()) {
            calHoraire.set(11, Integer.parseInt(horaire.substring(0, 2)));
            calHoraire.set(12, Integer.parseInt(horaire.substring(3, 5)));
        } else if (timeFormat == TimeFormat.H12.getValue()) {
            calHoraire.set(10, Integer.parseInt(horaire.substring(0, 2)));
            calHoraire.set(12, Integer.parseInt(horaire.substring(3, 5)));
            if (horaire.substring(6, 8).equals(RESSOURCE.get("PM"))) {
                calHoraire.set(9, 1);
            } else {
                calHoraire.set(9, 0);
            }
        }
        this.horaireDate = calHoraire;
    }

    public static String renvoieHeureMinute(Date pDate, int pTimeFormat) {
        String retour = "";
        Calendar calActuel = Calendar.getInstance();
        calActuel.setTime(pDate);
        if (pTimeFormat == TimeFormat.H24.getValue()) {
            retour = retour + calActuel.get(11);
            retour = retour + ":";
            retour = retour + calActuel.get(12);
        } else if (pTimeFormat == TimeFormat.H12.getValue()) {
            retour = retour + calActuel.get(10);
            retour = retour + ":";
            retour = retour + calActuel.get(12);
        }
        return retour;
    }

    public String getHoraireFormate() {
        return this.horaire;
    }

    public boolean isEstProchaine() {
        boolean estProchaine = false;
        Calendar calActuel = Calendar.getInstance();
        calActuel.setTime(new Date());
        if (this.timeFormat == TimeFormat.H24.getValue()) {
            if (this.horaireDate.getTime().getTime() > calActuel.getTime().getTime()) {
                estProchaine = true;
            }
        } else if (this.timeFormat == TimeFormat.H12.getValue() && this.horaireDate.getTime().getTime() > calActuel.getTime().getTime()) {
            estProchaine = true;
        }
        return estProchaine;
    }

    public Calendar getHoraireDate() {
        return this.horaireDate;
    }
}

