/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.microfloat.Real;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;

public class MenuCompass
extends Menu {
    private static final double ERREUR_CALCUL = -1.0;
    private static final double LATITUDE_MECQUE = 21.42667;
    private static final double LONGITUDE_MECQUE = 39.82611;
    private static final int INDEX_RESULTAT_ANGLE = 0;
    private static final int INDEX_RESULTAT_DISTANCE = 1;
    private Label mLabelDistance;
    private Label mLabelAngle;
    private final ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuCompass();
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuCompass");
    }

    private void editerLabel(Label pLabel) {
        pLabel.setUIID("LabelCompassInfo");
        pLabel.getUnselectedStyle().setBgTransparency(0);
        pLabel.getSelectedStyle().setBgTransparency(0);
        pLabel.setFocusable(true);
        pLabel.setAlignment(4);
    }

    protected void execute(Form f) {
        this.applyTactileSettings(f);
        Image imgBackGround = Main.icons.getImage("CompasBG");
        Image imgForeGround = Main.icons.getImage("CompasFG");
        double latitude = Double.parseDouble(ServiceFactory.getFactory().getPreferences().get("latitude"));
        double longitude = Double.parseDouble(ServiceFactory.getFactory().getPreferences().get("longitude"));
        double[] calculs = this.getAngle(latitude, longitude);
        Image imgBoussole = imgBackGround;
        this.mLabelAngle = new Label();
        this.editerLabel(this.mLabelAngle);
        this.mLabelDistance = new Label();
        this.editerLabel(this.mLabelDistance);
        if (calculs[0] == -1.0 || calculs[1] == -1.0) {
            this.mLabelAngle.setText(this.RESSOURCE.get("errorCompassAngleCalculation"));
            this.mLabelDistance.setText(this.RESSOURCE.get("errorCompassDistanceCalculation"));
        } else if (latitude == 21.42667 && longitude == 39.82611) {
            this.mLabelAngle.setText(this.RESSOURCE.get("infoCompassAlreadyMekkah"));
            this.mLabelDistance.setText("");
        } else {
            int angleArrondi = (int)Math.ceil(calculs[0]);
            imgForeGround = imgForeGround.rotate(angleArrondi);
            imgBoussole = this.getOverlay(imgBackGround, imgForeGround, f.getStyle().getBgColor());
            int distance = (int)Math.ceil(calculs[1]);
            this.mLabelAngle.setText(Integer.toString(angleArrondi) + this.RESSOURCE.get("compassAngleSummary"));
            this.mLabelDistance.setText(Integer.toString(distance) + this.RESSOURCE.get("compassDistanceSummary"));
        }
        Container ctnLabels = new Container(new BoxLayout(2));
        ctnLabels.addComponent(this.mLabelAngle);
        ctnLabels.addComponent(this.mLabelDistance);
        Label lblImageBoussole = new Label(imgBoussole);
        lblImageBoussole.setAlignment(4);
        Container ctnGlobal = new Container(new BorderLayout());
        ctnGlobal.addComponent("Center", (Component)lblImageBoussole);
        ctnGlobal.addComponent("South", (Component)ctnLabels);
        ctnGlobal.setPreferredW(f.getWidth());
        f.addComponent(ctnGlobal);
    }

    private Image getOverlay(Image background, Image overlay, int bgColor) {
        Image img = Image.createImage(background.getWidth(), background.getHeight());
        Graphics mG = img.getGraphics();
        int x = background.getWidth() - overlay.getWidth();
        int y = background.getHeight() - overlay.getHeight();
        mG.setClip(0, 0, background.getWidth(), background.getHeight());
        mG.setColor(bgColor);
        mG.fillRect(0, 0, background.getWidth(), background.getHeight());
        mG.drawImage(background, x, y);
        mG.drawImage(overlay, x, y);
        return img;
    }

    private double[] getAngle(double lat, double lon) {
        double[] retour = new double[]{-1.0, -1.0};
        try {
            double R = 6371.0;
            double dLat = (21.42667 - lat) * Math.PI / 180.0;
            double dLon = (39.82611 - lon) * Math.PI / 180.0;
            double lat1 = lat * Math.PI / 180.0;
            double lat2 = 0.37396593923829347;
            double y = Math.sin(dLon) * Math.cos(lat2);
            double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon);
            retour[0] = this.atan2(y, x) * 180.0 / Math.PI;
            double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
            double c = 2.0 * this.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            retour[1] = R * c;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return retour;
    }

    private double atan2(double y, double x) {
        double absx;
        double M_PI = Math.PI;
        double M_PI_2 = M_PI / 2.0;
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        double absy = y < 0.0 ? -y : y;
        double d = absx = x < 0.0 ? -x : x;
        if (absy - absx == absy) {
            return y < 0.0 ? -M_PI_2 : M_PI_2;
        }
        double val = absx - absy == absx ? 0.0 : this.arctan(y / x);
        if (x > 0.0) {
            return val;
        }
        if (y < 0.0) {
            return val - M_PI;
        }
        return val + M_PI;
    }

    private double arctan(double x) {
        Real r = new Real(Double.toString(x));
        r.atan();
        return Double.parseDouble(r.toString());
    }

    protected String getIconBaseName() {
        return "MenuAffichageCompas";
    }
}

