/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Date;

public class MenuLanguage
extends Menu {
    private static final int HAUTEUR_LABEL = 23;
    private static final int HAUTEUR_LABEL_TOUS = 25;
    private Command mOK;
    private ComboBox mLangCmb;

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuLanguage();
    }

    protected String getIconBaseName() {
        return "MenuLangageApplication";
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuApplicationLanguage");
    }

    protected void execute(final Form f) {
        final ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
        this.applyTactileSettings(f);
        Label lLabelDecalage = new Label(RESSOURCE.get("LanguageChoice"));
        lLabelDecalage.setUIID("LabelInfoName");
        lLabelDecalage.getUnselectedStyle().setBgTransparency(0);
        lLabelDecalage.getSelectedStyle().setBgTransparency(0);
        lLabelDecalage.setFocusable(true);
        lLabelDecalage.setAlignment(1);
        lLabelDecalage.setPreferredH(23);
        this.mLangCmb = new ComboBox(LANGUE_APPLICATIONS);
        this.mLangCmb.setSelectedIndex(0);
        Container ctnSaisie = new Container(new BoxLayout(1));
        ctnSaisie.addComponent(lLabelDecalage);
        ctnSaisie.addComponent(this.mLangCmb);
        ctnSaisie.setPreferredH(25);
        f.setLayout(new BoxLayout(2));
        f.addComponent(new Label());
        f.addComponent(ctnSaisie);
        if (!Main.isTactile()) {
            // empty if block
        }
        this.mOK = new Command(RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent ae) {
                boolean contenuOk = true;
                String s_lang = "en";
                try {
                    int i_lang = MenuLanguage.this.mLangCmb.getSelectedIndex();
                    if (i_lang == 0) {
                        s_lang = "en";
                    } else if (i_lang == 1) {
                        s_lang = "fr";
                    }
                }
                catch (Exception exc) {
                    contenuOk = false;
                }
                if (!contenuOk) {
                    ResourceReader RESSOURCE2 = ServiceFactory.getFactory().getResourceReader();
                    Command okCommand = new Command(RESSOURCE2.get("Command.OK"));
                    Dialog.show(RESSOURCE2.get("errorTitle"), RESSOURCE2.get("errorLangApplicationParameters"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    return;
                }
                try {
                    ServiceFactory.getFactory().getPreferences().set("langue", s_lang);
                    ServiceFactory.getFactory().getPreferences().save();
                    ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                    Command okCommand = new Command(RESSOURCE.get("Command.OK"));
                    Dialog.show(RESSOURCE.get("propertiesSavedTitle"), RESSOURCE.get("warningLangChanging"), okCommand, new Command[]{okCommand}, 4, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    f.showBack();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        f.addCommand(this.mOK);
        this.initialiserInfosLangue();
    }

    private void initialiserInfosLangue() {
        String lLang = "en";
        try {
            lLang = ServiceFactory.getFactory().getPreferences().get("langue");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (lLang.equals("en")) {
            this.mLangCmb.setSelectedIndex(0);
        } else if (lLang.equals("fr")) {
            this.mLangCmb.setSelectedIndex(1);
        }
    }
}

