/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.serialization;

import java.util.Hashtable;
import java.util.Vector;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.PropertyInfo;

public class SoapObject
implements KvmSerializable {
    String namespace;
    String name;
    Vector info = new Vector();
    Vector data = new Vector();

    public SoapObject(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SoapObject)) {
            return false;
        }
        SoapObject so = (SoapObject)o;
        int cnt = this.data.size();
        if (cnt != so.data.size()) {
            return false;
        }
        try {
            for (int i = 0; i < cnt; ++i) {
                if (this.data.elementAt(i).equals(so.getProperty(((PropertyInfo)this.info.elementAt((int)i)).name))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getProperty(int index) {
        return this.data.elementAt(index);
    }

    public Object getProperty(String name) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!name.equals(((PropertyInfo)this.info.elementAt((int)i)).name)) continue;
            return this.data.elementAt(i);
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public int getPropertyCount() {
        return this.data.size();
    }

    public void getPropertyInfo(int index, Hashtable properties, PropertyInfo propertyInfo) {
        PropertyInfo p = (PropertyInfo)this.info.elementAt(index);
        propertyInfo.name = p.name;
        propertyInfo.namespace = p.namespace;
        propertyInfo.flags = p.flags;
        propertyInfo.type = p.type;
        propertyInfo.elementType = p.elementType;
    }

    public SoapObject newInstance() {
        SoapObject o = new SoapObject(this.namespace, this.name);
        for (int i = 0; i < this.data.size(); ++i) {
            PropertyInfo propertyInfo = (PropertyInfo)this.info.elementAt(i);
            o.addProperty(propertyInfo, this.data.elementAt(i));
        }
        return o;
    }

    public void setProperty(int index, Object value) {
        this.data.setElementAt(value, index);
    }

    public SoapObject addProperty(String name, Object value) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = name;
        propertyInfo.type = value == null ? PropertyInfo.OBJECT_CLASS : value.getClass();
        return this.addProperty(propertyInfo, value);
    }

    public SoapObject addProperty(PropertyInfo propertyInfo, Object value) {
        this.info.addElement(propertyInfo);
        this.data.addElement(value);
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("" + this.name + "{");
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            buf.append("" + ((PropertyInfo)this.info.elementAt((int)i)).name + "=" + this.getProperty(i) + "; ");
        }
        buf.append("}");
        return buf.toString();
    }
}

