/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.io;

import java.io.IOException;
import java.io.Reader;
import org.kxml.Attribute;
import org.kxml.io.AbstractXmlReader;

public class XmlReader
extends AbstractXmlReader {
    static final String UNEXPECTED_EOF = "Unexpected EOF";
    char[] buf = new char[Runtime.getRuntime().freeMemory() >= 0x100000L ? 8192 : 128];
    boolean eof;
    int bufPos;
    int bufCount;
    Reader reader;
    int line = 1;
    int column = 1;

    private int peekChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bufPos >= this.bufCount) {
            this.bufCount = this.reader.read(this.buf, 0, this.buf.length);
            this.bufPos = 0;
            if (this.bufCount == -1) {
                this.eof = true;
                return -1;
            }
        }
        return this.buf[this.bufPos];
    }

    private int readChar() throws IOException {
        int n = this.peekChar();
        ++this.bufPos;
        ++this.column;
        if (n == 10) {
            ++this.line;
            this.column = 1;
        }
        return n;
    }

    private void skipWhitespace() throws IOException {
        while (!this.eof && this.peekChar() <= 32) {
            this.readChar();
        }
    }

    private String readName() throws IOException {
        int n = this.readChar();
        if (!(n >= 128 || n == 95 || n == 58 || n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
            this.exception("name expected!");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)n);
        while (!this.eof) {
            n = this.peekChar();
            if (!(n >= 128 || n == 95 || n == 45 || n == 58 || n == 46 || n >= 48 && n <= 57 || n >= 97 && n <= 122 || n >= 65 && n <= 90)) break;
            stringBuffer.append((char)this.readChar());
        }
        return stringBuffer.toString();
    }

    private StringBuffer readTo(char c, StringBuffer stringBuffer) throws IOException {
        while (!this.eof && this.peekChar() != c) {
            stringBuffer.append((char)this.readChar());
        }
        return stringBuffer;
    }

    public XmlReader(Reader reader) throws IOException {
        this.reader = reader;
    }

    /*
     * Unable to fully structure code
     */
    private void parseComment() throws IOException {
        var1_1 = new StringBuffer();
        if (this.readChar() != 45) {
            this.exception("'-' expected");
        }
        while (true) {
            this.readTo('-', var1_1);
            if (this.readChar() == -1) {
                this.exception("Unexpected EOF");
            }
            var2_2 = 0;
            do {
                var3_3 = this.readChar();
                ++var2_2;
            } while (var3_3 == 45);
            if (var3_3 != 62 || var2_2 < 2) ** GOTO lbl18
            if (true) ** GOTO lbl25
lbl-1000:
            // 1 sources

            {
                var1_1.append('-');
lbl18:
                // 2 sources

                ** while (var2_2-- > 0)
            }
lbl19:
            // 1 sources

            var1_1.append((char)var3_3);
        }
        do {
            var1_1.append('-');
lbl25:
            // 2 sources

        } while (var2_2-- > 2);
        this.type = 1;
        this.text = var1_1.toString();
        this.name = null;
        this.namespace = null;
    }

    private void parseDoctype() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (true) {
            int n2 = this.readChar();
            switch (n2) {
                case -1: {
                    this.exception(UNEXPECTED_EOF);
                }
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n == 0) {
                        this.namespace = null;
                        this.name = null;
                        this.type = 2;
                        this.text = stringBuffer.toString();
                        break;
                    }
                    stringBuffer.append((char)n2);
                }
            }
        }
    }

    private void parseCData() throws IOException {
        StringBuffer stringBuffer = this.readTo('[', new StringBuffer());
        if (!stringBuffer.toString().equals("CDATA")) {
            this.exception("Invalid CDATA start!");
        }
        stringBuffer.setLength(0);
        this.readChar();
        int n = this.readChar();
        int n2 = this.readChar();
        while (true) {
            int n3;
            if ((n3 = this.readChar()) == -1) {
                this.exception(UNEXPECTED_EOF);
            }
            if (n == 93 && n2 == 93 && n3 == 62) break;
            stringBuffer.append((char)n);
            n = n2;
            n2 = n3;
        }
        this.type = 128;
        this.text = stringBuffer.toString();
        this.name = null;
        this.namespace = null;
    }

    private void parseEndTag() throws IOException {
        this.skipWhitespace();
        this.name = this.readName();
        this.skipWhitespace();
        if (this.readChar() != 62) {
            this.exception("'>' expected");
        }
        this.type = 16;
        this.text = null;
    }

    private void parsePI() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.readTo('?', stringBuffer);
        this.readChar();
        while (this.peekChar() != 62) {
            stringBuffer.append('?');
            int n = this.readChar();
            if (n == -1) {
                this.exception(UNEXPECTED_EOF);
            }
            stringBuffer.append((char)n);
            this.readTo('?', stringBuffer);
            this.readChar();
        }
        this.readChar();
        this.type = 32;
        this.text = stringBuffer.toString();
        this.name = null;
        this.namespace = null;
    }

    private void parseStartTag() throws IOException {
        this.namespace = null;
        this.name = this.readName();
        this.type = 64;
        this.text = null;
        while (true) {
            String string;
            this.skipWhitespace();
            int n = this.peekChar();
            if (n == 47) {
                this.degenerated = true;
                this.readChar();
                this.skipWhitespace();
                if (this.readChar() == 62) break;
                this.exception("illegal element termination");
                break;
            }
            if (n == 62) {
                this.readChar();
                break;
            }
            if (n == -1) {
                this.exception(UNEXPECTED_EOF);
            }
            if ((string = this.readName()).length() == 0) {
                this.exception("illegal char / attr");
            }
            this.skipWhitespace();
            if (this.readChar() != 61) {
                this.exception("Attribute name " + string + "must be followed by '='!");
            }
            this.skipWhitespace();
            int n2 = this.readChar();
            if (n2 != 39 && n2 != 34) {
                if (!this.relaxed) {
                    this.exception("<" + this.name + ">: invalid delimiter: " + (char)n2);
                }
                n2 = 32;
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.readText(stringBuffer, (char)n2);
            if (this.attributeCount == this.attributes.length) {
                Attribute[] attributeArray = new Attribute[this.attributeCount + 8];
                System.arraycopy(this.attributes, 0, attributeArray, 0, this.attributeCount);
                this.attributes = attributeArray;
            }
            this.attributes[this.attributeCount++] = new Attribute(null, string, stringBuffer.toString());
            if (n2 == 32) continue;
            this.readChar();
        }
    }

    private int readText(StringBuffer stringBuffer, char c) throws IOException {
        int n;
        int n2 = 256;
        while ((n = this.peekChar()) != -1 && n != c && (c != ' ' || n != 62 && n >= 32)) {
            this.readChar();
            if (n == 38) {
                String string = this.readTo(';', new StringBuffer()).toString();
                this.readChar();
                if (string.charAt(0) == '#') {
                    int n3 = n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
                    if (n > 32) {
                        n2 = 128;
                    }
                    stringBuffer.append((char)n);
                    continue;
                }
                if (string.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string.equals("amp")) {
                    stringBuffer.append('&');
                } else {
                    String string2;
                    String string3 = string2 = this.characterEntityTable == null ? null : (String)this.characterEntityTable.get(string);
                    if (string2 == null) {
                        if (!this.relaxed) {
                            this.exception("Undef. &" + string + ";");
                        }
                        string2 = "&" + string + ";";
                    }
                    stringBuffer.append(string2);
                }
                n2 = 128;
                continue;
            }
            if (n > 32) {
                n2 = 128;
            }
            stringBuffer.append((char)n);
        }
        return n2;
    }

    private void parseSpecial() throws IOException {
        block0 : switch (this.peekChar()) {
            case -1: {
                this.exception(UNEXPECTED_EOF);
            }
            case 33: {
                this.readChar();
                switch (this.peekChar()) {
                    case 45: {
                        this.readChar();
                        this.parseComment();
                        break block0;
                    }
                    case 91: {
                        this.readChar();
                        this.parseCData();
                        break block0;
                    }
                }
                this.parseDoctype();
                break;
            }
            case 63: {
                this.readChar();
                this.parsePI();
                break;
            }
            case 47: {
                this.readChar();
                this.parseEndTag();
                break;
            }
            default: {
                this.parseStartTag();
            }
        }
    }

    public void nextImpl() throws IOException {
        this.attributeCount = 0;
        if (this.degenerated) {
            this.type = 16;
            this.degenerated = false;
        } else {
            switch (this.peekChar()) {
                case 60: {
                    this.readChar();
                    this.parseSpecial();
                    break;
                }
                case -1: {
                    this.type = 8;
                    this.name = null;
                    this.namespace = null;
                    this.text = null;
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer();
                    this.type = this.readText(stringBuffer, '<');
                    this.text = stringBuffer.toString();
                    this.namespace = null;
                    this.name = null;
                }
            }
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }
}

